/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.PostgresExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.PostgresIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern PG_VERSION_PATTERN = Pattern.compile("(\\d+(?:(?:alpha|beta|rc)\\d*|\\.\\d+)(?:\\.\\d+)*)", 2);

    public PgJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("POSTGRES", version, connection);
    }

    public PgJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return PgJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            PgJdbcHelper.$$$reportNull$$$0(0);
        }
        return new PostgresIntermediateFacade(ds, 1, false, PostgresExceptionRecognizer.INSTANCE);
    }

    @NotNull
    protected static PgJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        String version = PgJdbcHelper.extractVersion(productVer);
        return new PgJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, PG_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper", "createFacade"));
    }
}

