/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.MssqlIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class MssqlIntermediateFacade
extends JdbcIntermediateFacade {
    private static final String CONNECTION_INFO_QUERY = "select db_name(), schema_name(), original_login(), @@version";

    public MssqlIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(1);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        JdbcIntermediateSession session = this.openSession();
        try {
            String driverVersionStr;
            String serverVersionStr;
            String rdbmsName;
            String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            if (env == null) {
                env = new String[]{null, null, null, null};
            }
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                if (env[3] != null && env[3].contains("Azure")) {
                    rdbmsName = "AZURE";
                } else {
                    rdbmsName = md.getDatabaseProductName();
                    if (rdbmsName == null) {
                        rdbmsName = session.getConnection().getClass().getName();
                    }
                }
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            Version serverVersion = MssqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            Version driverVersion = MssqlIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @Override
    @NotNull
    protected MssqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(2);
        }
        return new MssqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/MssqlIntermediateFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiateSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

