/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.CassandraIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassandraIntermediateFacade
extends JdbcIntermediateFacade {
    private static final String CONNECTION_INFO_QUERY = "select release_version from system.local";

    public CassandraIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            CassandraIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            CassandraIntermediateFacade.$$$reportNull$$$0(1);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            CassandraIntermediateFacade.$$$reportNull$$$0(2);
        }
        return new CassandraIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @Override
    @Nullable
    protected ConnectionInfo obtainConnectionInfoNatively() {
        String driverVersionStr;
        String schemaName;
        String rdbmsName;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 1, String.class);
            Connection connection = session.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            rdbmsName = md.getDatabaseProductName();
            schemaName = connection.getCatalog();
            if (rdbmsName == null) {
                rdbmsName = connection.getClass().getName();
            }
            driverVersionStr = md.getDriverVersion();
        }
        catch (SQLException sqle) {
            throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
        }
        finally {
            session.close();
        }
        Version driverVersion = CassandraIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 1);
            Version serverVersion = CassandraIntermediateFacade.extractVersion(env[0], SIMPLE_VERSION_PATTERN, 1);
            return new ConnectionInfo(rdbmsName, null, schemaName, null, serverVersion, driverVersion);
        }
        return new ConnectionInfo(rdbmsName, null, schemaName, null, Version.ZERO, driverVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/CassandraIntermediateFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiateSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

