/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.pooling.ConnectionPool;
import com.intellij.database.remote.jdba.jdbc.pooling.SimpleDataSource;
import com.intellij.database.remote.jdba.util.Version;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntermediateFacade
implements PrimeIntermediateFacade {
    @NotNull
    protected final ConnectionPool myPool;
    @NotNull
    protected final DBExceptionRecognizer myExceptionRecognizer;
    private final LinkedBlockingQueue<JdbcIntermediateSession> mySessions;
    protected static final Pattern SIMPLE_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,3}){1,5})");

    public JdbcIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (connectionString == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (exceptionRecognizer == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(2);
        }
        this(JdbcIntermediateFacade.prepareDataSource(connectionString, connectionProperties, driver), connectionsLimit, true, exceptionRecognizer);
    }

    public JdbcIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(3);
        }
        if (exceptionRecognizer == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(4);
        }
        this.mySessions = new LinkedBlockingQueue();
        this.myPool = new ConnectionPool(dataSource, ownConnections);
        this.myPool.setConnectionsLimit(connectionsLimit);
        this.myExceptionRecognizer = exceptionRecognizer;
    }

    @NotNull
    private static JdbcConnectionProvider prepareDataSource(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver) {
        if (connectionString == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(5);
        }
        if (driver == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(6);
        }
        SimpleDataSource dataSource = new SimpleDataSource(connectionString, connectionProperties, driver);
        dataSource.setLogWriter(new PrintWriter(System.out));
        SimpleDataSource simpleDataSource = dataSource;
        if (simpleDataSource == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(7);
        }
        return simpleDataSource;
    }

    @Override
    public synchronized void connect() {
        try {
            this.myPool.connect();
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "connect");
        }
    }

    @Override
    public synchronized void reconnect() {
        throw new RuntimeException("The JdbcInterFacade.reconnect has not been implemented yet.");
    }

    @Override
    public synchronized void disconnect() {
        try {
            while (!this.mySessions.isEmpty()) {
                Thread.sleep(10L);
                ArrayList sessionsToClose = new ArrayList(10);
                this.mySessions.drainTo(sessionsToClose, 10);
                for (JdbcIntermediateSession sessionToClose : sessionsToClose) {
                    sessionToClose.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myPool.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.myPool.isReady();
    }

    @Override
    @NotNull
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo info = null;
        try {
            info = this.obtainConnectionInfoNatively();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (info == null) {
            info = this.obtainConnectionInfoFromJdbc();
        }
        ConnectionInfo connectionInfo = info;
        if (connectionInfo == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(8);
        }
        return connectionInfo;
    }

    @Nullable
    protected ConnectionInfo obtainConnectionInfoNatively() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected ConnectionInfo obtainConnectionInfoFromJdbc() {
        Connection connection = this.myPool.borrow();
        DatabaseMetaData md = connection.getMetaData();
        String rdbmsName = md.getDatabaseProductName();
        if (rdbmsName == null) {
            rdbmsName = connection.getClass().getName();
        }
        String databaseName = connection.getCatalog();
        String schemaName = JdbcIntermediateFacade.getSchema(connection);
        String userName = this.getUserNameSafe(md);
        Version serverVersion = Version.of(md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion());
        Version driverVersion = Version.of(md.getDriverMajorVersion(), md.getDriverMinorVersion());
        ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, databaseName, schemaName, userName, serverVersion, driverVersion);
        this.myPool.release(connection);
        ConnectionInfo connectionInfo2 = connectionInfo;
        if (connectionInfo2 == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(9);
        }
        return connectionInfo2;
        {
            catch (Throwable throwable) {
                try {
                    this.myPool.release(connection);
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw this.myExceptionRecognizer.recognizeException(sqle, "getting brief connection info using JDBC connection metadata");
                }
            }
        }
    }

    private String getUserNameSafe(DatabaseMetaData md) {
        try {
            return md.getUserName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    private static String getSchema(Connection connection) {
        String schemaName = null;
        try {
            Class<?> connectionClass = connection.getClass();
            Method getSchemaMethod = connectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null) {
                schemaName = (String)getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schemaName;
    }

    @Override
    @NotNull
    public JdbcIntermediateSession openSession() {
        Connection connection;
        try {
            connection = this.myPool.borrow();
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "borrow a connection from the pool");
        }
        JdbcIntermediateSession session = this.instantiateSession(connection, false);
        this.mySessions.add(session);
        JdbcIntermediateSession jdbcIntermediateSession = session;
        if (jdbcIntermediateSession == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(10);
        }
        return jdbcIntermediateSession;
    }

    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(11);
        }
        return new JdbcIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @NotNull
    public DBExceptionRecognizer getExceptionRecognizer() {
        DBExceptionRecognizer dBExceptionRecognizer = this.myExceptionRecognizer;
        if (dBExceptionRecognizer == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(12);
        }
        return dBExceptionRecognizer;
    }

    void sessionIsClosed(@NotNull JdbcIntermediateSession session, @NotNull Connection connection) {
        if (session == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(13);
        }
        if (connection == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(14);
        }
        this.mySessions.remove(session);
        this.myPool.release(connection);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(15);
        }
        if (serviceName == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(16);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ConnectionInfo getConnectionInfoSmartly(String envQuery, Pattern serverVersionPattern, int serverVersionGroupIndex, Pattern driverVersionPattern, int driverVersionGroupIndex) {
        String driverVersionStr;
        String serverVersionStr;
        String rdbmsName;
        JdbcIntermediateSession session = this.openSession();
        String[] env = session.queryOneRow(envQuery, 3, String.class);
        if (env == null) {
            env = new String[]{null, null, null};
        }
        assert (env.length == 3) : "Session info should contain 3 components";
        try {
            DatabaseMetaData md = session.getConnection().getMetaData();
            rdbmsName = md.getDatabaseProductName();
            if (rdbmsName == null) {
                rdbmsName = session.getConnection().getClass().getName();
            }
            serverVersionStr = md.getDatabaseProductVersion();
            driverVersionStr = md.getDriverVersion();
        }
        catch (SQLException sqle) {
            throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
        }
        Version serverVersion = JdbcIntermediateFacade.extractVersion(serverVersionStr, serverVersionPattern, serverVersionGroupIndex);
        Version driverVersion = JdbcIntermediateFacade.extractVersion(driverVersionStr, driverVersionPattern, driverVersionGroupIndex);
        ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
        ConnectionInfo connectionInfo2 = connectionInfo;
        if (connectionInfo2 == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(17);
        }
        return connectionInfo2;
        finally {
            session.close();
        }
    }

    @NotNull
    protected static Version extractVersion(@Nullable String serverVersionStr, @NotNull Pattern versionPattern, int groupIndex) {
        if (versionPattern == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(18);
        }
        if (serverVersionStr == null || serverVersionStr.isEmpty()) {
            Version version = Version.ZERO;
            if (version == null) {
                JdbcIntermediateFacade.$$$reportNull$$$0(19);
            }
            return version;
        }
        Matcher m = versionPattern.matcher(serverVersionStr);
        if (m.find()) {
            Version version = Version.of(m.group(groupIndex));
            if (version == null) {
                JdbcIntermediateFacade.$$$reportNull$$$0(20);
            }
            return version;
        }
        Version version = Version.ZERO;
        if (version == null) {
            JdbcIntermediateFacade.$$$reportNull$$$0(21);
        }
        return version;
    }

    public int countOpenedSessions() {
        return this.mySessions.size();
    }

    public int countOpenedConnections() {
        return this.myPool.countAllConnections();
    }

    public int countOpenedSeances() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedSeances();
        }
        return count;
    }

    public int countOpenedCursors() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedCursors();
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFacade";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFacade";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainConnectionInfoFromJdbc";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "openSession";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionRecognizer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionInfoSmartly";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareDataSource";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sessionIsClosed";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

