/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote;

import com.intellij.execution.rmi.RemoteServer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.rmi.Remote;
import org.jetbrains.annotations.NotNull;

public class RemoteJdbcServerBase
extends RemoteServer {
    public static final String BITNESS_PATTERN = "#BITNESS";
    public static final String DOMAIN_AUTH_LIBRARY_PATH = "domain.auth.library";
    public static final String DOMAIN_AUTH_MISSING_FILES = "Missing native authentication library: ";

    protected static void start(Remote remote) throws Exception {
        RemoteJdbcServerBase.setupDomainAuth();
        RemoteServer.start((Remote)remote);
    }

    private static void setupDomainAuth() {
        String property = System.getProperty(DOMAIN_AUTH_LIBRARY_PATH);
        if (property != null) {
            try {
                String bitness = SystemInfoRt.is32Bit ? "x86" : "x64";
                File extracted = RemoteJdbcServerBase.extractLibraryFromJar(property.replace(BITNESS_PATTERN, bitness));
                RemoteJdbcServerBase.setLibraryPath(extracted.getParentFile().getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File extractLibraryFromJar(@NotNull String path) throws Exception {
        String filename;
        if (path == null) {
            RemoteJdbcServerBase.$$$reportNull$$$0(0);
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null) {
            throw new IllegalArgumentException("The filename extracted from the path: '" + path + "' is null");
        }
        File auth = FileUtilRt.createTempDirectory((String)"win_auth", null, (boolean)true);
        File temp = new File(auth, filename);
        temp.deleteOnExit();
        if (!temp.createNewFile() || !temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[5120];
        InputStream is = RemoteServer.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(DOMAIN_AUTH_MISSING_FILES + path);
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        File file = temp;
        if (file == null) {
            RemoteJdbcServerBase.$$$reportNull$$$0(1);
        }
        return file;
    }

    private static void setLibraryPath(@NotNull String path) throws NoSuchFieldException, IllegalAccessException {
        if (path == null) {
            RemoteJdbcServerBase.$$$reportNull$$$0(2);
        }
        System.setProperty("java.library.path", path);
        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
        fieldSysPath.setAccessible(true);
        fieldSysPath.set(null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/RemoteJdbcServerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/RemoteJdbcServerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLibraryFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractLibraryFromJar";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLibraryPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

