/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlatformUtils {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String IDEA_CE_PREFIX = "Idea";
    public static final String IDEA_EDU_PREFIX = "IdeaEdu";
    public static final String APPCODE_PREFIX = "AppCode";
    public static final String CLION_PREFIX = "CLion";
    public static final String PYCHARM_PREFIX = "Python";
    public static final String PYCHARM_CE_PREFIX = "PyCharmCore";
    public static final String PYCHARM_EDU_PREFIX = "PyCharmEdu";
    public static final String RUBY_PREFIX = "Ruby";
    public static final String PHP_PREFIX = "PhpStorm";
    public static final String WEB_PREFIX = "WebStorm";
    public static final String DBE_PREFIX = "DataGrip";
    public static final String RIDER_PREFIX = "Rider";
    public static final String GOIDE_PREFIX = "GoLand";
    private static final Set<String> COMMERCIAL_EDITIONS = new HashSet<String>(Arrays.asList("idea", "AppCode", "CLion", "Python", "Ruby", "PhpStorm", "WebStorm", "DataGrip", "Rider", "GoLand"));

    @NotNull
    public static String getPlatformPrefix() {
        String string = PlatformUtils.getPlatformPrefix(IDEA_PREFIX);
        if (string == null) {
            PlatformUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getPlatformPrefix(@Nullable String defaultPrefix) {
        return System.getProperty(PLATFORM_PREFIX_KEY, defaultPrefix);
    }

    public static void setDefaultPrefixForCE() {
        System.setProperty(PLATFORM_PREFIX_KEY, PlatformUtils.getPlatformPrefix(IDEA_CE_PREFIX));
    }

    public static boolean isJetBrainsProduct() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        return appInfo != null && appInfo.getShortCompanyName().equals("JetBrains");
    }

    public static boolean isIntelliJ() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity() || PlatformUtils.isIdeaEducational();
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is(IDEA_PREFIX);
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is(IDEA_CE_PREFIX);
    }

    public static boolean isIdeaEducational() {
        return PlatformUtils.is(IDEA_EDU_PREFIX);
    }

    public static boolean isRubyMine() {
        return PlatformUtils.is(RUBY_PREFIX);
    }

    public static boolean isAppCode() {
        return PlatformUtils.is(APPCODE_PREFIX);
    }

    public static boolean isCLion() {
        return PlatformUtils.is(CLION_PREFIX);
    }

    public static boolean isCidr() {
        return PlatformUtils.isAppCode() || PlatformUtils.isCLion();
    }

    public static boolean isPyCharm() {
        return PlatformUtils.isPyCharmPro() || PlatformUtils.isPyCharmCommunity() || PlatformUtils.isPyCharmEducational();
    }

    public static boolean isPyCharmPro() {
        return PlatformUtils.is(PYCHARM_PREFIX);
    }

    public static boolean isPyCharmCommunity() {
        return PlatformUtils.is(PYCHARM_CE_PREFIX);
    }

    public static boolean isPyCharmEducational() {
        return PlatformUtils.is(PYCHARM_EDU_PREFIX);
    }

    public static boolean isPhpStorm() {
        return PlatformUtils.is(PHP_PREFIX);
    }

    public static boolean isWebStorm() {
        return PlatformUtils.is(WEB_PREFIX);
    }

    public static boolean isDataGrip() {
        return PlatformUtils.is(DBE_PREFIX);
    }

    public static boolean isRider() {
        return PlatformUtils.is(RIDER_PREFIX);
    }

    public static boolean isGoIde() {
        return PlatformUtils.is(GOIDE_PREFIX);
    }

    public static boolean isCommunityEdition() {
        return PlatformUtils.isIdeaCommunity() || PlatformUtils.isPyCharmCommunity();
    }

    public static boolean isCommercialEdition() {
        return COMMERCIAL_EDITIONS.contains(PlatformUtils.getPlatformPrefix());
    }

    private static boolean is(@NotNull String idePrefix) {
        if (idePrefix == null) {
            PlatformUtils.$$$reportNull$$$0(1);
        }
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PlatformUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PlatformUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

