/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefDisposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JBCefBrowser
implements JBCefDisposable {
    private static final String BLANK_URI = "about:blank";
    @NotNull
    private final JBCefClient myCefClient;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final CefBrowser myCefBrowser;
    @NotNull
    private final CefFocusHandler myCefFocusHandler;
    @Nullable
    private final CefLifeSpanHandler myLifeSpanHandler;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    private final boolean myIsDefaultClient;
    private volatile boolean myIsCefBrowserCreated;
    @Nullable
    private volatile LoadDeferrer myLoadDeferrer;
    private JDialog myDevtoolsFrame;
    protected CefContextMenuHandler myDefaultContextMenuHandler;

    public JBCefBrowser(@NotNull JBCefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(0);
        }
        this(client, false, url);
    }

    public JBCefBrowser(@NotNull CefBrowser cefBrowser, @NotNull JBCefClient client) {
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(1);
        }
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(2);
        }
        this(cefBrowser, client, false, null);
    }

    private JBCefBrowser(@NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(3);
        }
        this(null, client, isDefaultClient, url);
    }

    private JBCefBrowser(@Nullable CefBrowser cefBrowser, @NotNull JBCefClient client, boolean isDefaultClient, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(4);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.myDevtoolsFrame = null;
        if (client.isDisposed()) {
            throw new IllegalArgumentException("JBCefClient is disposed");
        }
        this.myCefClient = client;
        this.myIsDefaultClient = isDefaultClient;
        this.myComponent = new MyComponent(new BorderLayout());
        this.myComponent.setBackground(JBColor.background());
        this.myCefBrowser = cefBrowser != null ? cefBrowser : this.myCefClient.getCefClient().createBrowser(url != null ? url : BLANK_URI, false, false);
        this.myComponent.add(this.myCefBrowser.getUIComponent(), "Center");
        if (cefBrowser == null) {
            this.myLifeSpanHandler = new CefLifeSpanHandlerAdapter(){

                public void onAfterCreated(CefBrowser browser) {
                    JBCefBrowser.this.myIsCefBrowserCreated = true;
                    LoadDeferrer loader = JBCefBrowser.this.myLoadDeferrer;
                    if (loader != null) {
                        loader.load(browser);
                        JBCefBrowser.this.myLoadDeferrer = null;
                    }
                }
            };
            this.myCefClient.addLifeSpanHandler(this.myLifeSpanHandler, this.myCefBrowser);
        } else {
            this.myLifeSpanHandler = null;
        }
        this.myCefFocusHandler = new CefFocusHandlerAdapter(){

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION) {
                    return true;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                return false;
            }
        };
        this.myCefClient.addFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
        this.myDefaultContextMenuHandler = this.createDefaultContextMenuHandler();
        this.myCefClient.addContextMenuHandler(this.myDefaultContextMenuHandler, this.getCefBrowser());
    }

    protected DefaultCefContextMenuHandler createDefaultContextMenuHandler() {
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        return new DefaultCefContextMenuHandler(isInternal);
    }

    public void loadURL(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(5);
        }
        if (this.myIsCefBrowserCreated) {
            this.myCefBrowser.loadURL(url);
        } else {
            this.myLoadDeferrer = LoadDeferrer.urlDeferrer(url);
        }
    }

    public void loadHTML(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowser.$$$reportNull$$$0(6);
        }
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(7);
        }
        if (this.myIsCefBrowserCreated) {
            this.myCefBrowser.loadString(html, url);
        } else {
            this.myLoadDeferrer = LoadDeferrer.htmlDeferrer(html, url);
        }
    }

    public void loadHTML(@NotNull String html) {
        if (html == null) {
            JBCefBrowser.$$$reportNull$$$0(8);
        }
        this.loadHTML(html, BLANK_URI);
    }

    public JBCefBrowser() {
        this(JBCefApp.getInstance().createClient(), true, null);
    }

    public JBCefBrowser(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(9);
        }
        this(JBCefApp.getInstance().createClient(), true, url);
    }

    @NotNull
    public JComponent getComponent() {
        MyComponent myComponent = this.myComponent;
        if (myComponent == null) {
            JBCefBrowser.$$$reportNull$$$0(10);
        }
        return myComponent;
    }

    @NotNull
    public CefBrowser getCefBrowser() {
        CefBrowser cefBrowser = this.myCefBrowser;
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(11);
        }
        return cefBrowser;
    }

    @NotNull
    public JBCefClient getJBCefClient() {
        JBCefClient jBCefClient = this.myCefClient;
        if (jBCefClient == null) {
            JBCefBrowser.$$$reportNull$$$0(12);
        }
        return jBCefClient;
    }

    @Nullable
    private Window getActiveFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    public void openDevtools() {
        if (this.myDevtoolsFrame != null) {
            this.myDevtoolsFrame.toFront();
            return;
        }
        Window activeFrame = this.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        Rectangle bounds = activeFrame.getGraphicsConfiguration().getBounds();
        this.myDevtoolsFrame = new JDialog(activeFrame);
        this.myDevtoolsFrame.setTitle("JCEF DevTools");
        this.myDevtoolsFrame.setDefaultCloseOperation(2);
        this.myDevtoolsFrame.setBounds(bounds.width / 4 + 100, bounds.height / 4 + 100, bounds.width / 2, bounds.height / 2);
        this.myDevtoolsFrame.setLayout(new BorderLayout());
        final JBCefBrowser devTools = new JBCefBrowser(this.myCefBrowser.getDevTools(), this.myCefClient);
        this.myDevtoolsFrame.add((Component)devTools.getComponent(), "Center");
        this.myDevtoolsFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JBCefBrowser.this.myDevtoolsFrame = null;
                Disposer.dispose((Disposable)devTools);
            }
        });
        this.myDevtoolsFrame.setVisible(true);
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            this.myCefClient.removeFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
            if (this.myLifeSpanHandler != null) {
                this.myCefClient.removeLifeSpanHandler(this.myLifeSpanHandler, this.myCefBrowser);
            }
            this.myCefBrowser.stopLoad();
            this.myCefBrowser.close(false);
            if (this.myIsDefaultClient) {
                Disposer.dispose((Disposable)this.myCefClient);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    @Contract(value="null->null; !null->!null")
    protected static JBCefBrowser getJBCefBrowser(CefBrowser browser) {
        if (browser == null) {
            return null;
        }
        return ((MyComponent)browser.getUIComponent().getParent()).getJBCefBrowser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefBrowser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadURL";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadHTML";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyComponent
    extends JPanel {
        MyComponent(BorderLayout layout) {
            super(layout);
        }

        JBCefBrowser getJBCefBrowser() {
            return JBCefBrowser.this;
        }
    }

    protected class DefaultCefContextMenuHandler
    extends CefContextMenuHandlerAdapter {
        protected static final int DEBUG_COMMAND_ID = 28500;
        private final boolean isInternal;

        public DefaultCefContextMenuHandler(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
            if (this.isInternal) {
                model.addItem(28500, "Open DevTools");
            }
        }

        public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
            if (commandId == 28500) {
                JBCefBrowser.this.openDevtools();
                return true;
            }
            return false;
        }
    }

    private static class LoadDeferrer {
        @Nullable
        protected final String myHtml;
        @NotNull
        protected final String myUrl;

        private LoadDeferrer(@Nullable String html, @NotNull String url) {
            if (url == null) {
                LoadDeferrer.$$$reportNull$$$0(0);
            }
            this.myHtml = html;
            this.myUrl = url;
        }

        @NotNull
        public static LoadDeferrer urlDeferrer(String url) {
            return new LoadDeferrer(null, url);
        }

        @NotNull
        public static LoadDeferrer htmlDeferrer(String html, String url) {
            return new LoadDeferrer(html, url);
        }

        public void load(@NotNull CefBrowser browser) {
            if (browser == null) {
                LoadDeferrer.$$$reportNull$$$0(1);
            }
            SwingUtilities.invokeLater(this.myHtml == null ? () -> browser.loadURL(this.myUrl) : () -> browser.loadString(this.myHtml, this.myUrl));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser$LoadDeferrer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

