/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CheckSharedIndices
extends AbstractCommand {
    public static final String PREFIX = "%checkSharedIndices";
    private static final Logger LOG = Logger.getInstance(CheckSharedIndices.class);
    private final Project myProject;

    public CheckSharedIndices(String text, int line, Project project) {
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.checkSharedIndexRetainFileCount(actionCallback), PerformanceTestingBundle.message("checking.shared.indexes", new Object[0]), false, this.myProject));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private void checkSharedIndexRetainFileCount(@NotNull ActionCallback callback) {
        if (callback == null) {
            CheckSharedIndices.$$$reportNull$$$0(0);
        }
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).flushIndexes();
        ApplicationManager.getApplication().runReadAction(() -> {
            List<VirtualFile> retainFiles = this.getSharedIndexRetainFiles();
            List<VirtualFile> allFiles = this.getProjectNonTriviallyIndexedFilesFiles();
            if (retainFiles.isEmpty()) {
                LOG.warn("getSharedIndexRetainFiles returned empty collection");
                callback.setRejected();
            } else {
                LOG.info("Project files indexed by shared indexes: " + retainFiles.size() + ". All project indexed files: " + allFiles.size() + "\n. Files without shared index " + CheckSharedIndices.getSharedIndexMissesMessage(retainFiles, allFiles));
                callback.setDone();
            }
        });
    }

    private static String getSharedIndexMissesMessage(@NotNull List<VirtualFile> sharedIndexRetainFiles, @NotNull List<VirtualFile> allFiles) {
        if (sharedIndexRetainFiles == null) {
            CheckSharedIndices.$$$reportNull$$$0(1);
        }
        if (allFiles == null) {
            CheckSharedIndices.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> misses = new ArrayList<VirtualFile>(allFiles);
        misses.removeAll(sharedIndexRetainFiles);
        return StringUtil.join(misses, f -> f.getName(), (String)", ");
    }

    private List<VirtualFile> getSharedIndexRetainFiles() {
        FileContentHashIndex hashIndex = FileContentHashService.getInstance().getFileContentHashIndex();
        CommonProcessors.CollectProcessor allKeysCollector = new CommonProcessors.CollectProcessor();
        GlobalSearchScope projectAllScope = GlobalSearchScope.allScope((Project)this.myProject);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        try {
            hashIndex.processAllKeys((Processor)allKeysCollector, projectAllScope, null);
            LOG.info("Collected " + allKeysCollector.getResults().size() + " from hashIndex");
            TIntHashSet fileIds = new TIntHashSet();
            for (Long compositeHashId : allKeysCollector.getResults()) {
                hashIndex.getData((Object)compositeHashId).forEach((k, v) -> {
                    if (!fileIds.add(k)) {
                        LOG.error("Duplicate fileId " + k + " in hashIndex");
                        return false;
                    }
                    return true;
                });
            }
            for (Object fileId : (Object)fileIds.toArray()) {
                VirtualFile fileById = ManagingFS.getInstance().findFileById((int)fileId);
                if (fileById == null) {
                    LOG.error("Can't find virtual file for id " + (int)fileId);
                    return Collections.emptyList();
                }
                if (!projectAllScope.contains(fileById)) continue;
                files.add(fileById);
            }
        }
        catch (StorageException ex) {
            LOG.error("Failed to check shared indexes " + ex.getMessage(), (Throwable)ex);
        }
        LOG.info("Command CheckSharedIndexes finished successful.");
        return files;
    }

    @NotNull
    private List<VirtualFile> getProjectNonTriviallyIndexedFilesFiles() {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        List providers = fileBasedIndex.getOrderedIndexableFilesProviders(this.myProject);
        ConcurrentBitSet visitedFiles = new ConcurrentBitSet();
        ArrayList<VirtualFile> projectFiles = new ArrayList<VirtualFile>();
        Set contentDependentIndexes = FileBasedIndexExtension.EXTENSION_POINT_NAME.extensions().filter(ex -> ex.dependsOnFileContent()).map(ex -> ex.getName()).collect(Collectors.toSet());
        for (IndexableFilesProvider provider : providers) {
            provider.iterateFiles(this.myProject, f -> {
                List nonTrivialIds;
                ID anyContentDependentId;
                if (!f.isDirectory() && (anyContentDependentId = (ID)ContainerUtil.find((Iterable)(nonTrivialIds = IndexingStamp.getNontrivialFileIndexedStates((int)((VirtualFileWithId)f).getId())), id -> contentDependentIndexes.contains(id))) != null) {
                    projectFiles.add(f);
                }
                return true;
            }, visitedFiles);
        }
        ArrayList<VirtualFile> arrayList = projectFiles;
        if (arrayList == null) {
            CheckSharedIndices.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedIndexRetainFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/CheckSharedIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/CheckSharedIndices";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNonTriviallyIndexedFilesFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSharedIndexRetainFileCount";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSharedIndexMissesMessage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

