/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Asserts;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    @NotNull
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    @NotNull
    public static final Charset ASCII = StandardCharsets.US_ASCII;
    public static final char LEFT_ARROW = '\u2190';
    public static final char RIGHT_ARROW = '\u2192';
    public static final String RIGHT_ARROW_IN_SPACES = " \u2192 ";
    public static final char APPROX = '\u2248';
    public static final String APPROX_PREFIX = "\u2248 ";
    public static final char GE = '\u2265';
    public static final String GE_PREFIX = "\u2265 ";
    public static final char LE = '\u2264';
    public static final char DASH = '\u2014';
    @NotNull
    public static final String DASH_IN_SPACES = " \u2014 ";
    public static final char SHORT_DASH = '\u2013';
    @NotNull
    public static final String SHORT_DASH_IN_SPACES = " \u2013 ";
    public static final char BULLET = '\u2022';
    public static final String MKS = "\u00b5s";
    private static final char[] DIGITS_HIGH = "0123456789ABCDEF".toCharArray();
    private static final char[] DIGITS_LOW = "0123456789abcdef".toCharArray();
    private static final ThreadLocal<byte[]> ourUnsignedDecimalBuffer = new ThreadLocal<byte[]>(){

        @Override
        @NotNull
        protected byte[] initialValue() {
            return new byte[9];
        }

        @Override
        public byte[] get() {
            byte[] result = (byte[])super.get();
            Arrays.fill(result, (byte)0);
            return result;
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String replace(@NotNull String text, @NotNull String oldSubstring, @NotNull String newSubstring) {
        String string;
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (oldSubstring == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (newSubstring == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (text.length() < oldSubstring.length()) {
            String string2 = text;
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("Method must not return null");
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int i1 = text.indexOf(oldSubstring, i);
            if (i1 < 0) {
                if (i == 0) {
                    String string3 = text;
                    string = string3;
                    if (string3 == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                newText.append(text.substring(i));
                break;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text, i, i1);
            newText.append(newSubstring);
            i = i1 + oldSubstring.length();
        }
        if (newText == null) return "";
        String string4 = newText.toString();
        return string4;
    }

    @NotNull
    public static String replaceMultiple(@NotNull String text, String ... oldAndNewValuePairs) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (oldAndNewValuePairs == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (oldAndNewValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("array length must be even");
        }
        String result = text;
        int i = 0;
        while (i < oldAndNewValuePairs.length) {
            String oldValue = oldAndNewValuePairs[i++];
            String newValue = oldAndNewValuePairs[i++];
            result = Strings.replace(result, oldValue, newValue);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String decapitalize(@NotNull String original) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder(original.length());
        StringTokenizer tokenizer = new StringTokenizer(original, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (result.length() == 0) {
                result.append(word);
                continue;
            }
            result.append(' ');
            if (word.equals("Microsoft") || word.equals("Visual") || word.equals("Studio")) {
                result.append(word);
                continue;
            }
            if (word.length() >= 2 && Character.isUpperCase(word.charAt(0)) && !Character.isUpperCase(word.charAt(1))) {
                result.append(word.toLowerCase());
                continue;
            }
            result.append(word);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private static boolean startsWithIgnoreCase(@NotNull String original, @NotNull String prefix, int startOffset) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int prefixLength = prefix.length();
        if (original.length() < prefixLength) {
            return false;
        }
        int offset = startOffset;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            if (Character.toLowerCase(original.charAt(offset++)) == Character.toLowerCase(prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(@NotNull String original, @NotNull String prefix) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return Strings.startsWithIgnoreCase(original, prefix, 0);
    }

    public static boolean endsWithIgnoreCase(@NotNull String original, @NotNull String prefix) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return Strings.startsWithIgnoreCase(original, prefix, original.length() - prefix.length());
    }

    @NotNull
    public static String removeComments(@NotNull String original, @NotNull String commentStart, @NotNull String commentEnd) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (commentStart == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (commentEnd == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (commentStart.isEmpty()) {
            Asserts.fail();
        }
        if (commentEnd.isEmpty()) {
            Asserts.fail();
        }
        if (commentStart.endsWith(commentEnd)) {
            Asserts.fail();
        }
        StringBuilder builder = new StringBuilder();
        int length = original.length();
        boolean inComment = false;
        int i = 0;
        while (i < length) {
            if (!inComment) {
                if (original.startsWith(commentStart, i)) {
                    inComment = true;
                    i += commentStart.length();
                    continue;
                }
                builder.append(original.charAt(i));
                ++i;
                continue;
            }
            if (original.startsWith(commentEnd, i)) {
                inComment = false;
                i += commentEnd.length();
                continue;
            }
            ++i;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(byte v) {
        String string = Strings.toHex(v, 2);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(char v) {
        String string = Strings.toHex(v, 4);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(short v) {
        String string = Strings.toHex(v, 4);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(int v) {
        String string = Strings.toHex(v, 8);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(long v) {
        String string = Strings.toHex(v, 16);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHexCutLeadingZeros(long v) {
        int i;
        if (v == 0L) {
            return "0";
        }
        String result = Strings.toHex(v);
        for (i = 0; i < result.length() && result.charAt(i) == '0'; ++i) {
        }
        String string = result.substring(i);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String toHex(long v, int hexDigits) {
        char[] buffer = new char[hexDigits];
        long _v = v;
        for (int i = hexDigits - 1; i >= 0; --i) {
            buffer[i] = DIGITS_HIGH[(int)_v & 0xF];
            _v >>= 4;
        }
        return new String(buffer);
    }

    @NotNull
    public static String toHexLowCase(long v, int hexDigits) {
        char[] buffer = new char[hexDigits];
        long _v = v;
        for (int i = hexDigits - 1; i >= 0; --i) {
            buffer[i] = DIGITS_LOW[(int)_v & 0xF];
            _v >>= 4;
        }
        return new String(buffer);
    }

    public static String toUnsignedDecimal(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        byte[] val = ourUnsignedDecimalBuffer.get();
        long x = value;
        for (int i = 0; i < 8; ++i) {
            val[val.length - i - 1] = (byte)x;
            x >>= 8;
        }
        return new BigInteger(val).toString();
    }

    @NotNull
    public static byte[] getUtf8Bytes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] byArray = s.getBytes(UTF_8);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    @NotNull
    public static String createUtf8String(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return new String(bytes, UTF_8);
    }

    @NotNull
    public static String notNull(@Nullable String value) {
        String string = Strings.notNull(value, "");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String notNull(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = value != null ? value : defaultValue;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String s) {
        return s != null && s.isEmpty() ? null : s;
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @NotNull
    public static String notEmpty(@Nullable String value, @NotNull String defaultValue) {
        String v;
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (defaultValue.isEmpty()) {
            Asserts.fail();
        }
        String string = (v = Strings.notNull(value)).isEmpty() ? defaultValue : v;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String notNullAndNotEmpty(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (defaultValue.isEmpty()) {
            Asserts.fail();
        }
        String string = value == null || value.isEmpty() ? defaultValue : value.trim();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String limit(@NotNull String text, int maxLength) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("invalid maxLength: " + maxLength);
        }
        int toCut = text.length() - maxLength;
        String string = toCut <= 3 ? text : text.substring(0, maxLength) + "...";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String normalizeSpaces(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = text.length();
        StringBuilder result = new StringBuilder(length);
        boolean wasSpace = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n' || ch == ' ') {
                if (wasSpace) continue;
                result.append(' ');
                wasSpace = true;
                continue;
            }
            result.append(ch);
            wasSpace = false;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String normalizeSpaces2(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (String s : text.split("\n")) {
            String t = s.trim();
            if (t.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(DASH_IN_SPACES);
            }
            result.append(t);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String normalizeMultiLineText(@NotNull String text) {
        String string;
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String trimmed = text.trim();
        if (trimmed.indexOf(10) == -1) {
            string = trimmed;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        StringBuilder result = new StringBuilder();
        boolean previousLineEmpty = false;
        for (String line : trimmed.split("\n")) {
            if (line.trim().isEmpty()) {
                if (previousLineEmpty) continue;
                result.append('\n');
                previousLineEmpty = true;
                continue;
            }
            result.append(line);
            result.append("\n");
            previousLineEmpty = false;
        }
        string = result.toString();
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String normalizeEOLs(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.replace(text, "\r\n", "\n");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String prefix, @NotNull String[] lines, @NotNull String separator, boolean addSeparatorAfterLastLine) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StringBuilder result = new StringBuilder();
        int lineCount = lines.length;
        for (int idx = 0; idx < lineCount; ++idx) {
            String line = lines[idx];
            result.append(prefix);
            result.append(line);
            if (!addSeparatorAfterLastLine && idx >= lineCount - 1) continue;
            result.append(separator);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String[] lines, @NotNull String separator, boolean addSeparatorAfterLastLine) {
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = Strings.join("", lines, separator, addSeparatorAfterLastLine);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String prefix, @NotNull List<? extends String> lines, @NotNull String separator, boolean addSeparatorAfterLastLine) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StringBuilder result = new StringBuilder();
        int lineCount = lines.size();
        for (int idx = 0; idx < lineCount; ++idx) {
            String line = lines.get(idx);
            result.append(prefix);
            result.append(line);
            if (!addSeparatorAfterLastLine && idx >= lineCount - 1) continue;
            result.append(separator);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull List<? extends String> lines, @NotNull String separator, boolean addSeparatorAfterLastLine) {
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = Strings.join("", lines, separator, addSeparatorAfterLastLine);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String join(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.join("", lines, "\n", true);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String prefixLines(@NotNull String prefix, @NotNull String lines) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (lines == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string = Strings.join(prefix, lines.split("\n"), "\n", true);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getFirstToken(@NotNull String str, @NotNull String separatorCharacters) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separatorCharacters == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        } else {
            int separatorsLength = separatorCharacters.length();
            int strLength = str.length();
            int strIndex = 0;
            while (true) {
                char ch;
                if (strIndex < strLength) {
                    ch = str.charAt(strIndex);
                } else {
                    string = str;
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                    if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                    string = str.substring(0, strIndex);
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                ++strIndex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getFirstToken(@NotNull String str, char separator) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        int index = str.indexOf(separator);
        string = index < 0 ? str : str.substring(0, index);
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getLastToken(@NotNull String str, @NotNull String separatorCharacters) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (separatorCharacters == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        } else {
            int separatorsLength = separatorCharacters.length();
            int strIndex = str.length() - 1;
            while (true) {
                char ch;
                if (strIndex >= 0) {
                    ch = str.charAt(strIndex);
                } else {
                    string = str;
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                    if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                    string = str.substring(strIndex + 1);
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                }
                --strIndex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getLastToken(@NotNull String str, char separator) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str.isEmpty()) {
            string = str;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        int index = str.lastIndexOf(separator);
        string = index < 0 ? str : str.substring(index + 1);
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutPrefix(@NotNull String str, @NotNull String prefix) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.startsWith(prefix)) {
            string = str.substring(prefix.length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = str;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutPostfix(@NotNull String str, @NotNull String postfix) {
        String string;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (postfix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.endsWith(postfix)) {
            string = str.substring(0, str.length() - postfix.length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = str;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String fill(char ch, int count) {
        if (count <= 0) {
            return "";
        }
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    @NotNull
    public static String padPostfix(@NotNull String s, int desiredLength, char ch) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = s.length();
        int padding = desiredLength - length;
        if (padding <= 0) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
        char[] chars = new char[length + padding];
        s.getChars(0, length, chars, 0);
        Arrays.fill(chars, length, length + padding, ch);
        return new String(chars);
    }

    @NotNull
    public static String padPostfix(@NotNull String s, int desiredLength) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.padPostfix(s, desiredLength, ' ');
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String padPrefix(@NotNull String s, int desiredLength) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = s.length();
        int padding = desiredLength - length;
        if (padding <= 0) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
        char[] chars = new char[length + padding];
        Arrays.fill(chars, 0, padding, ' ');
        s.getChars(0, length, chars, padding);
        return new String(chars);
    }

    @NotNull
    public static String trimEnd(@NotNull String s) {
        int length;
        if (s == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (length = s.length(); length > 0 && s.charAt(length - 1) <= ' '; --length) {
        }
        String string = s.substring(0, length);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static String trim(@NotNull String str, char charToTrim) {
        int start;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int len = str.length();
        for (start = 0; start < len && str.charAt(start) == charToTrim; ++start) {
        }
        while (start < len && str.charAt(len - 1) == charToTrim) {
            --len;
        }
        return str.substring(start, len);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String countToString(long count, @NotNull String string) {
        void unitNameSingular;
        if (string == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String string2 = count + " " + (String)unitNameSingular + (count == 1L ? "" : "s");
        if (string2 == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String countToString(long count, @NotNull String singularUnitName, @NotNull String string) {
        void pluralUnitName;
        if (singularUnitName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        String string2 = count + " " + (String)(count == 1L ? singularUnitName : pluralUnitName);
        if (string2 == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string2;
    }

    @NotNull
    public static String quote(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = "\"" + str + "\"";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String singleQuote(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = "'" + str + "'";
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String quoteIfWithSpaces(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = str.contains(" ") ? Strings.quote(str) : str;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeJson(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = null;
        for (int i = 0; i < str.length(); ++i) {
            char quotedChar;
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    quotedChar = '\\';
                    break;
                }
                case '\"': {
                    quotedChar = '\"';
                    break;
                }
                case '\n': {
                    quotedChar = 'n';
                    break;
                }
                case '\r': {
                    quotedChar = 'r';
                    break;
                }
                case '\t': {
                    quotedChar = 't';
                    break;
                }
                case '\b': {
                    quotedChar = 'b';
                    break;
                }
                case '\f': {
                    quotedChar = 'f';
                    break;
                }
                default: {
                    quotedChar = '\u0000';
                }
            }
            if (quotedChar != '\u0000') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(str, 0, i);
                }
                result.append('\\');
                result.append(quotedChar);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        String string = result != null ? result.toString() : str;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeXml(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.escapeXmlImpl(str, false);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeHtml(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Strings.escapeXmlImpl(str, true);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    private static String escapeXmlImpl(@NotNull String str, boolean newLineToBr) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = null;
        block7: for (int i = 0; i < str.length(); ++i) {
            String replacement;
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\"': {
                    replacement = "&quot;";
                    break;
                }
                case '\'': {
                    replacement = "&apos;";
                    break;
                }
                default: {
                    if (newLineToBr && c == '\n') {
                        replacement = "<br/>";
                        break;
                    }
                    if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                        replacement = " ";
                        break;
                    }
                    if (result == null) continue block7;
                    result.append(c);
                    continue block7;
                }
            }
            if (result == null) {
                result = new StringBuilder();
                result.append(str, 0, i);
            }
            result.append(replacement);
        }
        String string = result != null ? result.toString() : str;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static boolean isAlphaNumeric(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str.isEmpty() || str.startsWith(".") || str.endsWith(".") || str.contains("..")) {
            return false;
        }
        for (String token : str.split("\\.")) {
            if (!Character.isJavaIdentifierStart(token.charAt(0))) {
                return false;
            }
            for (int i = 1; i < token.length(); ++i) {
                if (Character.isJavaIdentifierPart(token.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDecimalCandidate(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int prefixLength = Strings.getDecimalPrefixLength(str);
        return prefixLength > 0 && prefixLength == str.length();
    }

    private static int getDecimalPrefixLength(@NotNull String str) {
        int startIndex;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = str.length();
        if (length == 0) {
            return 0;
        }
        char ch0 = str.charAt(0);
        if (ch0 == '+' || ch0 == '-') {
            if (length < 2) {
                return 0;
            }
            startIndex = 1;
        } else {
            startIndex = 0;
        }
        for (int i = startIndex; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return i;
        }
        return length;
    }

    @Nullable
    public static Integer parseIntPrefix(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int prefixLength = Strings.getDecimalPrefixLength(str);
        if (prefixLength == 0) {
            return null;
        }
        return Strings.parseInt(str.substring(0, prefixLength));
    }

    public static int parseIntPrefix(@NotNull String str, int defaultValue) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Integer value = Strings.parseIntPrefix(str);
        return value == null ? defaultValue : value;
    }

    @Nullable
    public static Integer parseInt(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!Strings.isDecimalCandidate(str)) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static boolean isInt(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Strings.parseInt(str) != null;
    }

    public static int parseInt(@Nullable String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if (!Strings.isDecimalCandidate(str)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    public static Long parseLong(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!Strings.isDecimalCandidate(str)) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static long parseLong(@Nullable String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if (!Strings.isDecimalCandidate(str)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    public static Double parseDouble(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static Number parseNumber(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Long aLong = Strings.parseLong(str);
        if (aLong != null) {
            return aLong;
        }
        return Strings.parseDouble(str);
    }

    public static void appendSeparatorIfNotEmpty(@NotNull StringBuilder buf, char separator) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buf.length() > 0) {
            buf.append(separator);
        }
    }

    public static void appendSeparated(@NotNull StringBuilder buf, @NotNull CharSequence str, char separator) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (str.length() == 0) {
            return;
        }
        Strings.appendSeparatorIfNotEmpty(buf, separator);
        buf.append(str);
    }

    public static void appendSeparated(@NotNull StringBuilder buf, @NotNull CharSequence str, @NotNull CharSequence separator) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (str.length() == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append(separator);
        }
        buf.append(str);
    }

    public static void appendCommaSeparated(@NotNull StringBuilder buf, @NotNull CharSequence str) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Strings.appendSeparated(buf, str, ',');
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String concatenateWithComma(@Nullable String str1, @Nullable String str2) {
        String string;
        String _str1 = Strings.notNull(str1);
        String _str2 = Strings.notNull(str2);
        if (_str1.isEmpty()) {
            string = _str2;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        if (_str2.isEmpty()) {
            string = _str1;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = _str1 + "," + _str2;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static boolean greaterOrEqual(@NotNull String str, int minValue) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Integer value = Strings.parseInt(str);
        return value != null && value >= minValue;
    }

    @NotNull
    public static ArrayList<String> split(@NotNull String str, int lineLengthLimit) {
        int charToCopy;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (lineLengthLimit <= 0) {
            throw new IllegalArgumentException("invalid lineLengthLimit: " + lineLengthLimit);
        }
        int strLen = str.length();
        int pos = 0;
        ArrayList<String> result = new ArrayList<String>(strLen / lineLengthLimit + 1);
        do {
            charToCopy = Math.min(strLen - pos, lineLengthLimit);
            result.add(str.substring(pos, pos + charToCopy));
        } while ((pos += charToCopy) < strLen);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }

    public static int getJavaVersion(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int version = versionStr.startsWith("1.") ? Strings.parseIntPrefix(versionStr.substring(2), 0) : Strings.parseIntPrefix(versionStr, 0);
        return Math.max(version, 0);
    }
}

