/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateHighlighter
extends SyntaxHighlighterBase {
    private static final PlainSyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new PlainSyntaxHighlighter();
    @Nullable
    private final Lexer myLexer;
    private final TextMateSelectorWeigher mySelectorWeigher;

    public TextMateHighlighter(@Nullable Lexer lexer) {
        this.myLexer = lexer;
        this.mySelectorWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.myLexer == null ? PLAIN_SYNTAX_HIGHLIGHTER.getHighlightingLexer() : this.myLexer;
        if (lexer == null) {
            TextMateHighlighter.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (!(tokenType instanceof TextMateElementType)) {
            TextAttributesKey[] textAttributesKeyArray = PLAIN_SYNTAX_HIGHLIGHTER.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                TextMateHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextMateService service = TextMateService.getInstance();
        Map<CharSequence, TextMateCustomTextAttributes> customHighlightingColors = service.getCustomHighlightingColors();
        SmartList highlightingRules = new SmartList((Object)new HighlightingRule("textmate.default", TextMateWeigh.ZERO));
        for (CharSequence currentRule : ContainerUtil.union(customHighlightingColors.keySet(), TextMateTheme.INSTANCE.getRules())) {
            TextMateWeigh weigh = this.mySelectorWeigher.weigh(currentRule, tokenType.toString());
            if (weigh.weigh <= 0) continue;
            highlightingRules.add(new HighlightingRule(currentRule, weigh));
        }
        ContainerUtil.sort((List)highlightingRules);
        TextAttributesKey[] textAttributesKeyArray = (TextAttributesKey[])ContainerUtil.map2Array((Collection)highlightingRules, TextAttributesKey.class, rule -> {
            TextMateCustomTextAttributes customTextAttributes = (TextMateCustomTextAttributes)customHighlightingColors.get(rule.myName);
            if (customTextAttributes != null) {
                TextAttributes textAttributes = customTextAttributes.getTextAttributes();
                Color backgroundColor = textAttributes.getBackgroundColor();
                if (backgroundColor != null) {
                    Color defaultBackground = TextMateTheme.INSTANCE.getDefaultBackground();
                    double backgroundAlpha = customTextAttributes.getBackgroundAlpha();
                    if (backgroundAlpha > -1.0) {
                        textAttributes.setBackgroundColor(ColorUtil.mix((Color)defaultBackground, (Color)backgroundColor, (double)backgroundAlpha));
                        return TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + TextMateTheme.INSTANCE.getName() + rule.myName), (TextAttributes)textAttributes);
                    }
                }
                return TextAttributesKey.createTextAttributesKey((String)("TextMateCustomRule_" + rule.myName), (TextAttributes)textAttributes);
            }
            return TextMateTheme.INSTANCE.getTextAttributesKey(rule.myName);
        });
        if (textAttributesKeyArray == null) {
            TextMateHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class HighlightingRule
    implements Comparable<HighlightingRule> {
        public final CharSequence myName;
        private final TextMateWeigh myWeigh;

        private HighlightingRule(CharSequence name, TextMateWeigh weigh) {
            this.myName = name;
            this.myWeigh = weigh;
        }

        @Override
        public int compareTo(@NotNull HighlightingRule rule) {
            if (rule == null) {
                HighlightingRule.$$$reportNull$$$0(0);
            }
            return this.myWeigh.compareTo(rule.myWeigh);
        }

        public String toString() {
            return this.myName.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateHighlighter$HighlightingRule", "compareTo"));
        }
    }
}

