/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import com.sixrr.inspectjs.functionmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthJSInspection
extends FunctionMetricsInspection {
    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("nesting.depth.limit", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function2 != null);
        NestingDepthVisitor visitor = new NestingDepthVisitor();
        function2.accept((PsiElementVisitor)visitor);
        int nestingDepth = visitor.getMaximumDepth();
        if (NestingDepthJSInspection.functionHasIdentifier(function2)) {
            return InspectionJSBundle.message("function.is.overly.nested.error.string", nestingDepth, this.getLimit());
        }
        return InspectionJSBundle.message("anonymous.function.is.overly.nested.error.string", nestingDepth, this.getLimit());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            NestingDepthVisitor visitor = new NestingDepthVisitor();
            function2.accept((PsiElementVisitor)visitor);
            int count = visitor.getMaximumDepth();
            if (count <= NestingDepthJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function2);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/NestingDepthJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

