/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.confusing.CalculationResult;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import com.sixrr.inspectjs.utils.BoolUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionJSInspection
extends JSInspection {
    private static final Set<IElementType> booleanTokens = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.ANDAND, JSTokenTypes.AND, JSTokenTypes.OROR, JSTokenTypes.OR, JSTokenTypes.XOR});
    private static final Set<IElementType> equalsOperators = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.EQEQ, JSTokenTypes.EQEQEQ});
    private static final Set<IElementType> nonEqualsOperators = ContainerUtil.immutableSet((Object[])new IElementType[]{JSTokenTypes.NE, JSTokenTypes.NEQEQ});

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return new PointlessBooleanExpressionVisitor(holder);
    }

    @NotNull
    private static CalculationResult checkPrefixExpression(@NotNull JSPrefixExpression expression, boolean conditionContext) {
        IElementType sign;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(2);
        }
        if ((sign = expression.getOperationSign()) == null || !JSTokenTypes.EXCL.equals(sign)) {
            return new CalculationResult.SimpleResult((JSExpression)expression);
        }
        JSExpression innerExpression = expression.getExpression();
        if (innerExpression != null) {
            return PointlessBooleanExpressionJSInspection.notExpressionIsPointless(innerExpression, conditionContext, (JSExpression)expression);
        }
        return new CalculationResult.SimpleResult((JSExpression)expression);
    }

    @NotNull
    private static CalculationResult notExpressionIsPointless(@NotNull JSExpression arg, boolean conditionContext, JSExpression expression) {
        JSExpression innerExpr;
        JSPrefixExpression prefixExpression;
        CalculationResult result2;
        if (arg == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(3);
        }
        if (CalculationResult.isTrueResult(result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(arg, conditionContext))) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.FALSE);
        }
        if (CalculationResult.isFalseResult(result2)) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.TRUE);
        }
        if (result2.isSimplified()) {
            return new CalculationResult.NotResult(arg, conditionContext, expression);
        }
        if (arg instanceof JSPrefixExpression && (prefixExpression = (JSPrefixExpression)arg).getOperationSign() == JSTokenTypes.EXCL && (innerExpr = prefixExpression.getExpression()) != null && BoolUtils.isBoolean(innerExpr, false)) {
            CalculationResult calculationResult = new CalculationResult.SimpleResult(innerExpr, true).withExpression(expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(4);
            }
            return calculationResult;
        }
        return new CalculationResult.SimpleResult(expression);
    }

    private static boolean equalityExpressionCanBeSimplified(@NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull CalculationResult lhsResult, @NotNull CalculationResult rhsResult) {
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(5);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(6);
        }
        if (lhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(7);
        }
        if (rhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(8);
        }
        if (DialectDetector.isTypeScript((PsiElement)rhs) && TypeScriptConfigUtil.strictNullChecks((PsiElement)rhs)) {
            return BoolUtils.isBoolean(lhs, false) && BoolUtils.isBoolean(rhs, false);
        }
        if (PointlessBooleanExpressionJSInspection.trueFalseResult(lhsResult) && PointlessBooleanExpressionJSInspection.trueFalseResult(rhsResult)) {
            return true;
        }
        return BoolUtils.isBoolean(lhs, false) || BoolUtils.isBoolean(rhs, false);
    }

    @NotNull
    private static CalculationResult calculateNullOrUndefinedGuard(@NotNull IElementType sign, @NotNull JSExpression left, @NotNull JSExpression right, @NotNull JSExpression initialExpression) {
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(9);
        }
        if (left == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(10);
        }
        if (right == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(11);
        }
        if (initialExpression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(12);
        }
        if (!JSTypeGuardChecker.isNarrowableReference(left)) {
            return new CalculationResult.SimpleResult(left);
        }
        boolean isEqualCheckToNullOrUndefined = equalsOperators.contains(sign);
        boolean isDoubleEq = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        Set<JSDecoratedType.TypeDecoration> decoratorsToCheck = JSTypeGuardChecker.getDecoratorsForNullOrUndefinedExpression(isDoubleEq, right, false);
        if (decoratorsToCheck.isEmpty() || !(left instanceof JSReferenceExpression)) {
            return new CalculationResult.SimpleResult(left);
        }
        Set<JSDecoratedType.TypeDecoration> decorators = JSTypeGuardChecker.getDecoratorsForExpression((JSReferenceExpression)left);
        if (!decorators.containsAll(decoratorsToCheck)) {
            return new CalculationResult.SimpleResult(left);
        }
        return isEqualCheckToNullOrUndefined ? new CalculationResult.ConstantResult(initialExpression, CalculationResult.ConstantType.FALSE) : new CalculationResult.ConstantResult(initialExpression, CalculationResult.ConstantType.TRUE);
    }

    @NotNull
    private static CalculationResult checkBinaryExpression(@NotNull JSBinaryExpression expression, boolean conditionContext) {
        CalculationResult result2;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(13);
        }
        JSExpression rhs = expression.getROperand();
        JSExpression lhs = expression.getLOperand();
        IElementType sign = expression.getOperationSign();
        if (rhs == null || lhs == null || sign == null) {
            return new CalculationResult.SimpleResult((JSExpression)expression);
        }
        if (JSTokenTypes.ANDAND.equals(sign)) {
            return PointlessBooleanExpressionJSInspection.checkAndExpression(expression, conditionContext, rhs, lhs, sign);
        }
        if (JSTokenTypes.OROR.equals(sign)) {
            return PointlessBooleanExpressionJSInspection.checkOrExpression(expression, conditionContext, lhs, rhs, sign);
        }
        if (JSTokenTypes.EQUALITY_OPERATIONS.contains(sign)) {
            CalculationResult result3 = PointlessBooleanExpressionJSInspection.checkEqualityExpression(expression, conditionContext, rhs, lhs, sign);
            if (result3 != null) {
                CalculationResult calculationResult = result3;
                if (calculationResult == null) {
                    PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(14);
                }
                return calculationResult;
            }
        } else if (JSTokenTypes.XOR.equals(sign) && conditionContext && !ControlFlowUtils.isUndefinedOrNull(lhs) && !ControlFlowUtils.isUndefinedOrNull(rhs) && (result2 = PointlessBooleanExpressionJSInspection.checkXorExpression(expression, rhs, lhs, sign)) != null) {
            CalculationResult calculationResult = result2;
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(15);
            }
            return calculationResult;
        }
        return new CalculationResult.SimpleResult((JSExpression)expression);
    }

    @Nullable
    private static CalculationResult checkXorExpression(@NotNull JSBinaryExpression expression, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(16);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(17);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(18);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(19);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, true);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, true);
        if (lhsResult.isSimplified() || rhsResult.isSimplified()) {
            if (CalculationResult.isFalseResult(lhsResult)) {
                return rhsResult.asSimplified().withExpression((JSExpression)expression);
            }
            if (CalculationResult.isFalseResult(rhsResult)) {
                return lhsResult.asSimplified().withExpression((JSExpression)expression);
            }
            if (CalculationResult.isTrueResult(rhsResult)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return new CalculationResult.ConstantResult((JSExpression)expression, CalculationResult.ConstantType.FALSE);
                }
                return new CalculationResult.NotResult(lhs, true, (JSExpression)expression);
            }
            if (CalculationResult.isTrueResult(lhsResult)) {
                return new CalculationResult.NotResult(rhs, true, (JSExpression)expression);
            }
            return new CalculationResult.ComplexResult(lhsResult.withExpression((JSExpression)expression), rhsResult.withExpression((JSExpression)expression), (JSExpression)expression, sign);
        }
        return null;
    }

    @Nullable
    private static CalculationResult checkEqualityExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        CalculationResult result2;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(20);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(21);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(22);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(23);
        }
        JSExpression left = JSTypeGuardUtil.getReferenceCandidate(lhs);
        JSExpression right = JSTypeGuardUtil.getReferenceCandidate(rhs);
        if (left != null && right != null && (JSTypeGuardChecker.isUndefinedOrNullExpression(left) ? (result2 = PointlessBooleanExpressionJSInspection.calculateNullOrUndefinedGuard(sign, rhs, left, (JSExpression)expression)) instanceof CalculationResult.ConstantResult : JSTypeGuardChecker.isUndefinedOrNullExpression(right) && (result2 = PointlessBooleanExpressionJSInspection.calculateNullOrUndefinedGuard(sign, left, right, (JSExpression)expression)) instanceof CalculationResult.ConstantResult)) {
            return result2.withExpression((JSExpression)expression);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (lhsResult instanceof CalculationResult.ConstantResult && rhsResult instanceof CalculationResult.ConstantResult) {
            if (equalsOperators.contains(sign)) {
                return ((CalculationResult.ConstantResult)lhsResult).equalsResult((CalculationResult.ConstantResult)rhsResult, (JSExpression)expression, sign);
            }
            if (nonEqualsOperators.contains(sign)) {
                return ((CalculationResult.ConstantResult)lhsResult).notEqualsResult((CalculationResult.ConstantResult)rhsResult, (JSExpression)expression, sign);
            }
        }
        if (PointlessBooleanExpressionJSInspection.equalityExpressionCanBeSimplified(lhs, rhs, lhsResult, rhsResult)) {
            if (equalsOperators.contains(sign)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return rhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(lhsResult)) {
                    return new CalculationResult.NotResult(rhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isTrueResult(rhsResult)) {
                    return lhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(rhsResult)) {
                    return new CalculationResult.NotResult(lhs, conditionContext, (JSExpression)expression);
                }
            }
            if (nonEqualsOperators.contains(sign)) {
                if (CalculationResult.isTrueResult(lhsResult)) {
                    return new CalculationResult.NotResult(rhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(lhsResult)) {
                    return rhsResult.asSimplified().withExpression((JSExpression)expression);
                }
                if (CalculationResult.isTrueResult(rhsResult)) {
                    return new CalculationResult.NotResult(lhs, conditionContext, (JSExpression)expression);
                }
                if (CalculationResult.isFalseResult(rhsResult)) {
                    return lhsResult.asSimplified().withExpression((JSExpression)expression);
                }
            }
        }
        if (lhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(lhs) || rhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(rhs)) {
            return new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
        }
        return null;
    }

    private static boolean trueFalseResult(@NotNull CalculationResult result2) {
        if (result2 == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(24);
        }
        return result2 instanceof CalculationResult.ConstantResult;
    }

    @NotNull
    private static CalculationResult checkAndExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression rhs, @NotNull JSExpression lhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(25);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(26);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(27);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(28);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (CalculationResult.isFalseNullUndefinedResult(lhsResult)) {
            CalculationResult calculationResult = CalculationResult.createConstantResult(lhsResult, (JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(29);
            }
            return calculationResult;
        }
        if (CalculationResult.isTrueResult(lhsResult)) {
            CalculationResult calculationResult = rhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(30);
            }
            return calculationResult;
        }
        if (conditionContext && CalculationResult.isTrueResult(rhsResult)) {
            CalculationResult calculationResult = lhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(31);
            }
            return calculationResult;
        }
        return PointlessBooleanExpressionJSInspection.getAndOrResult(expression, rhs, sign, lhsResult, rhsResult);
    }

    @NotNull
    private static CalculationResult getAndOrResult(@NotNull JSBinaryExpression expression, @NotNull JSExpression rhs, @NotNull IElementType sign, @NotNull CalculationResult lhsResult, @NotNull CalculationResult rhsResult) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(32);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(33);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(34);
        }
        if (lhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(35);
        }
        if (rhsResult == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(36);
        }
        if (rhsResult.isSimplified() && ControlFlowUtils.isNotConstantExpression(rhs)) {
            return new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
        }
        if (lhsResult.isSimplified()) {
            return new CalculationResult.ComplexResult(lhsResult, rhsResult, (JSExpression)expression, sign);
        }
        return new CalculationResult.SimpleResult((JSExpression)expression);
    }

    @NotNull
    private static CalculationResult checkOrExpression(@NotNull JSBinaryExpression expression, boolean conditionContext, @NotNull JSExpression lhs, @NotNull JSExpression rhs, @NotNull IElementType sign) {
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(37);
        }
        if (lhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(38);
        }
        if (rhs == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(39);
        }
        if (sign == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(40);
        }
        CalculationResult lhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(lhs, conditionContext);
        CalculationResult rhsResult = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(rhs, conditionContext);
        if (CalculationResult.isTrueResult(lhsResult)) {
            return new CalculationResult.ConstantResult((JSExpression)expression, CalculationResult.ConstantType.TRUE);
        }
        if (CalculationResult.isFalseNullUndefinedResult(lhsResult)) {
            CalculationResult calculationResult = rhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(41);
            }
            return calculationResult;
        }
        if (conditionContext && CalculationResult.isFalseResult(rhsResult)) {
            CalculationResult calculationResult = lhsResult.asSimplified().withExpression((JSExpression)expression);
            if (calculationResult == null) {
                PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(42);
            }
            return calculationResult;
        }
        return PointlessBooleanExpressionJSInspection.getAndOrResult(expression, rhs, sign, lhsResult, rhsResult);
    }

    @NotNull
    public static CalculationResult calculateSimplifiedExpression(@Nullable JSExpression expression, boolean conditionContext) {
        JSExpression nestedExpression;
        CalculationResult result2;
        if (expression instanceof JSParenthesizedExpression && (result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(nestedExpression = JSUtils.unparenthesize(expression), conditionContext)).isSimplified()) {
            if (result2 instanceof CalculationResult.ConstantResult) {
                CalculationResult calculationResult = result2.withExpression(expression);
                if (calculationResult == null) {
                    PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(43);
                }
                return calculationResult;
            }
            return new CalculationResult.ParenthesizedResult(result2, expression);
        }
        if (ControlFlowUtils.isFalse(expression)) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.FALSE);
        }
        if (ControlFlowUtils.isNull(expression)) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.NULL);
        }
        if (ControlFlowUtils.isUndefined(expression)) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.UNDEFINED);
        }
        if (ControlFlowUtils.isTrue(expression)) {
            return new CalculationResult.ConstantResult(expression, CalculationResult.ConstantType.TRUE);
        }
        if (expression instanceof JSBinaryExpression) {
            return PointlessBooleanExpressionJSInspection.checkBinaryExpression((JSBinaryExpression)expression, conditionContext);
        }
        if (expression instanceof JSPrefixExpression) {
            return PointlessBooleanExpressionJSInspection.checkPrefixExpression((JSPrefixExpression)expression, conditionContext);
        }
        return new CalculationResult.SimpleResult(expression);
    }

    private static boolean conditionContext(@NotNull PsiElement expression) {
        PsiElement parent;
        if (expression == null) {
            PointlessBooleanExpressionJSInspection.$$$reportNull$$$0(44);
        }
        if (!((parent = expression.getParent()) instanceof JSStatement)) {
            return false;
        }
        return !(parent instanceof JSForInStatement) && parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == expression;
    }

    private static boolean isAcceptableExpressionParent(@Nullable PsiElement parent) {
        if (!(parent instanceof JSExpression)) {
            return false;
        }
        if (parent instanceof JSPrefixExpression) {
            return ((JSPrefixExpression)parent).getOperationSign() == JSTokenTypes.EXCL;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return true;
        }
        if (parent instanceof JSBinaryExpression) {
            boolean isConditionalContext = PointlessBooleanExpressionJSInspection.conditionContext(parent);
            IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
            if (sign == JSTokenTypes.XOR) {
                return isConditionalContext;
            }
            return booleanTokens.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection";
                break;
            }
            case 5: 
            case 17: 
            case 21: 
            case 26: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 7: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhsResult";
                break;
            }
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhsResult";
                break;
            }
            case 9: 
            case 19: 
            case 23: 
            case 28: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialExpression";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "notExpressionIsPointless";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "checkBinaryExpression";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndExpression";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "checkOrExpression";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSimplifiedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefixExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notExpressionIsPointless";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalityExpressionCanBeSimplified";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateNullOrUndefinedGuard";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkBinaryExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkXorExpression";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkEqualityExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "trueFalseResult";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAndExpression";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAndOrResult";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkOrExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "conditionContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PointlessBooleanExpressionVisitor
    extends JSElementVisitor {
        @NotNull
        private final ProblemsHolder myProblemsHolder;

        private PointlessBooleanExpressionVisitor(@NotNull ProblemsHolder problemsHolder) {
            if (problemsHolder == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            this.myProblemsHolder = problemsHolder;
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSBinaryExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        private void checkExpression(@NotNull JSExpression expression) {
            PsiElement parent;
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(2);
            }
            if (PointlessBooleanExpressionJSInspection.isAcceptableExpressionParent(parent = expression.getParent())) {
                return;
            }
            boolean context = PointlessBooleanExpressionJSInspection.conditionContext((PsiElement)expression);
            CalculationResult result2 = PointlessBooleanExpressionJSInspection.calculateSimplifiedExpression(expression, context);
            if (!result2.isSimplified()) {
                return;
            }
            Set<CalculationResult> simplifiedResults = result2.getSimplifiedResults();
            for (CalculationResult res : simplifiedResults) {
                String fix = res.getSimplifiedText();
                if (JSInheritedLanguagesHelper.isSimplifyBooleanFixEnabled((PsiElement)expression)) {
                    this.myProblemsHolder.registerProblem((PsiElement)res.getInitialExpression(), InspectionJSBundle.message("pointless.boolean.error.string", fix), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new BooleanLiteralComparisonFix(fix)});
                    return;
                }
                this.myProblemsHolder.registerProblem((PsiElement)res.getInitialExpression(), InspectionJSBundle.message("pointless.boolean.error.string", fix), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression node) {
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSParenthesizedExpression(node);
            this.checkExpression((JSExpression)node);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(4);
            }
            super.visitJSPrefixExpression(expression);
            this.checkExpression((JSExpression)expression);
        }

        public void visitJSIfStatement(@NotNull JSIfStatement node) {
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(5);
            }
            super.visitJSIfStatement(node);
            this.checkIfStatement(node);
        }

        public void visitJSWhileStatement(JSWhileStatement node) {
            super.visitJSWhileStatement(node);
            this.checkLoopStatement((JSLoopStatement)node);
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement node) {
            super.visitJSDoWhileStatement(node);
            this.checkLoopStatement((JSLoopStatement)node);
        }

        private void checkLoopStatement(JSLoopStatement statement) {
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            if (ControlFlowUtils.isFalse(condition) || ControlFlowUtils.isUndefinedOrNull(condition)) {
                this.myProblemsHolder.registerProblem((PsiElement)statement.getCondition(), InspectionJSBundle.message("pointless.statement.error.string", "While"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new JSSimplifyIfStatementFix(true)});
            }
        }

        private void checkIfStatement(@NotNull JSIfStatement node) {
            JSExpression condition;
            if (node == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(6);
            }
            if ((condition = node.getCondition()) == null) {
                return;
            }
            JSStatement thenBranch = node.getThen();
            if (thenBranch == null) {
                return;
            }
            if (ControlFlowUtils.isConstantExpression(condition)) {
                this.myProblemsHolder.registerProblem((PsiElement)node.getCondition(), InspectionJSBundle.message("pointless.statement.error.string", "If"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new JSSimplifyIfStatementFix(PointlessBooleanExpressionVisitor.getReturnValueForIfStatement(node.getCondition()))});
            }
        }

        private static boolean getReturnValueForIfStatement(@NotNull JSExpression condition) {
            if (condition == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(7);
            }
            if (ControlFlowUtils.isTrue(condition)) {
                return false;
            }
            return ControlFlowUtils.isFalse(condition) || ControlFlowUtils.isUndefinedOrNull(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$PointlessBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSParenthesizedExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkIfStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReturnValueForIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanLiteralComparisonFix
    extends InspectionJSFix {
        @NotNull
        private final String fix;

        public BooleanLiteralComparisonFix(@NotNull String fix) {
            if (fix == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(0);
            }
            this.fix = fix;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (element instanceof JSExpression) {
                BooleanLiteralComparisonFix.replaceExpression((JSExpression)element, this.fix);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$BooleanLiteralComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/confusing/PointlessBooleanExpressionJSInspection$BooleanLiteralComparisonFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

