/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicIntroducedEntityInfoProvider
implements IntroducedEntityInfoProvider {
    public final JSExpression[] myOccurrences;
    public final JSExpression myMainOccurrence;
    private final PsiElement myScope;

    public BasicIntroducedEntityInfoProvider(@NotNull JSExpression mainOccurrence, JSExpression[] occurrences, PsiElement scope) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(0);
        }
        this.myOccurrences = occurrences;
        this.myMainOccurrence = mainOccurrence;
        this.myScope = scope;
    }

    @Override
    public int getOccurrenceCount() {
        return this.myOccurrences.length;
    }

    @Override
    @Nullable
    public String evaluateType() {
        JSType type = JSResolveUtil.getExpressionJSType(this.myMainOccurrence);
        String finalType = BasicIntroducedEntityInfoProvider.shouldUseContextualType(type, this.myMainOccurrence) ? BaseCreateFix.guessTypeForExpression(this.myMainOccurrence, (PsiElement)this.myMainOccurrence, false) : type.getTypeText(JSType.TypeTextFormat.CODE);
        String typeString = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)finalType, (PsiElement)this.myMainOccurrence, (boolean)false, (boolean)false).first);
        return typeString;
    }

    @Contract(value="null, _ -> true")
    private static boolean shouldUseContextualType(JSType type, @NotNull JSExpression mainOccurrence) {
        if (mainOccurrence == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(1);
        }
        if (!(mainOccurrence instanceof JSReferenceExpression) && DialectDetector.isActionScript((PsiElement)mainOccurrence)) {
            return false;
        }
        return type == null || type instanceof JSAnyType || JSTypeUtils.isNullOrUndefinedType(type);
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myMainOccurrence.getContainingFile();
    }

    @Override
    public String[] suggestCandidateNames() {
        return ArrayUtilRt.toStringArray(JSNameSuggestionsUtil.generateVariableNamesFromExpression(this.myMainOccurrence, this.myScope, Collections.emptyList()));
    }

    @Override
    public boolean checkConflicts(@NotNull String name) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(2);
        }
        PsiElement scope = this.myScope;
        assert (scope != null);
        JSNamedElement existing = JSNameSuggestionsUtil.findExistingInScopeAndUp(name, scope, null);
        if (existing != null) {
            return BasicIntroducedEntityInfoProvider.showMemberAlreadyExists((PsiElement)existing);
        }
        return true;
    }

    public static boolean showMemberAlreadyExists(@NotNull PsiElement existing) {
        if (existing == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(3);
        }
        String msg = JSRefactoringUtil.getMemberAlreadyExistsMessage(existing);
        MultiMap conflicts = new MultiMap();
        conflicts.putValue((Object)existing, (Object)msg);
        return new ConflictsDialog(existing.getProject(), conflicts).showAndGet();
    }

    @Override
    public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
        if (name == null) {
            BasicIntroducedEntityInfoProvider.$$$reportNull$$$0(4);
        }
        return (PsiElement)ContainerUtil.getFirstItem(JSRefactoringUtil.findExistingInScope(name, place, this.processStatics(place)));
    }

    protected boolean processStatics(PsiElement place) {
        return JSResolveUtil.calculateStaticFromContext(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseContextualType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConflicts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showMemberAlreadyExists";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findNamedElementInScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

