/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQualifiedReferenceType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSTypeWithDeclarations,
JSReferenceItem {
    @NotNull
    private final String myReferenceName;
    @NotNull
    private final JSType myQualifierType;

    public JSQualifiedReferenceType(@NotNull String referenceName, @NotNull JSType qualifierType, @NotNull JSTypeSource source) {
        if (referenceName == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(0);
        }
        if (qualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReferenceName = referenceName;
        this.myQualifierType = qualifierType;
    }

    public JSQualifiedReferenceType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(4);
        }
        super(source);
        this.myReferenceName = JSTypeSerializer.readString(inputStream);
        this.myQualifierType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myReferenceName, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myQualifierType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(6);
        }
        this.myQualifierType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(7);
        }
        return new JSQualifiedReferenceType(this.myReferenceName, this.myQualifierType, source);
    }

    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean hasQualifier() {
        return true;
    }

    @NotNull
    public JSType getQualifierType() {
        JSType jSType = this.myQualifierType;
        if (jSType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.myReferenceName, this.getSourceHashCode(), this.myQualifierType.resolvedHashCode());
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(10);
        }
        JSQualifiedReferenceType other = (JSQualifiedReferenceType)type;
        return this.myReferenceName.equals(other.myReferenceName) && Objects.equals(this.getSourceElement(), other.getSourceElement()) && this.myQualifierType.isEquivalentTo(other.myQualifierType, context, allowResolve);
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        PsiElement element = this.getSourceElement();
        if (element == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        JSType substitute = this.substitute();
        if (substitute instanceof JSTypeWithDeclarations && substitute != this) {
            results.addAll(((JSTypeWithDeclarations)substitute).getDeclarations());
        }
        String name = this.getReferenceName();
        JSType rawQualifierType = this.getQualifierType();
        results.addAll(JSQualifiedReferenceType.resolveNamespaceElements(element, name, rawQualifierType));
        ArrayList<PsiElement> arrayList = results;
        if (arrayList == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveNamespaceElements(@NotNull PsiElement context, @NotNull String name, @NotNull JSType rawQualifierType) {
        if (context == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(13);
        }
        if (name == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(14);
        }
        if (rawQualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(15);
        }
        if (DialectDetector.isTypeScript(context)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(16);
            }
            return list2;
        }
        PsiFile targetFile = context.getContainingFile();
        if (targetFile == null) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(17);
            }
            return list3;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, targetFile, (PsiElement)targetFile);
        processor.setAddOnlyCompleteMatches();
        JSType qualifierType = rawQualifierType.substitute();
        if (qualifierType instanceof JSNamespace) {
            processor.addTypeHierarchy((JSNamespace)qualifierType);
            JSIndexBasedResolveUtil.processAllSymbols(processor);
            List list4 = ((StreamEx)StreamEx.of(JSResolveResult.toElements(processor.getResults(), true)).limit((long)JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP)).toList();
            if (list4 == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(18);
            }
            return list4;
        }
        List<PsiElement> list5 = Collections.emptyList();
        if (list5 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(19);
        }
        return list5;
    }

    @Nullable
    public JSReferenceItem getReferenceItemQualifier() {
        return (JSReferenceItem)ObjectUtils.tryCast((Object)this.myQualifierType, JSReferenceItem.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifierType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespaceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespaceElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

