/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionType {
    public static final int TYPES_NUMBER_LIMIT = 5;
    private final boolean myAnyType;

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE);
    }

    @NotNull
    public static JSType optimizeTypeForSubstitute(@NotNull JSType currentType, @Nullable PsiElement context) {
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        boolean keepNullTypes = context == null || TypeScriptConfigUtil.strictNullChecks(context) || currentType.getSourceElement() instanceof JSDocComment;
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, keepNullTypes ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @Contract(value="!null,_->!null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(2);
        }
        if (currentType instanceof JSDistributedType && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) {
            currentType = ((JSDistributedType)currentType).distributeType();
        }
        if (!(currentType instanceof JSUnionOrIntersectionType)) {
            return currentType;
        }
        JSUnionOrIntersectionType unionOrIntersection = (JSUnionOrIntersectionType)currentType;
        return JSCompositeTypeImpl.optimizeTypeIfUnionOrIntersection(unionOrIntersection, targetKind);
    }

    @Contract(value="!null,_ -> !null")
    private static JSType optimizeTypeIfUnionOrIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(3);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(4);
        }
        boolean allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        Set<JSUnionOrIntersectionType.OptimizedKind> set = currentOptimized = allowResolve ? currentType.getResolvedOptimized() : Collections.emptySet();
        if (JSCompositeTypeImpl.isResolvedOptimizedAcceptable(currentOptimized, targetKind)) {
            return currentType;
        }
        boolean isUnion = currentType.isUnionType();
        boolean isWeakType = !currentType.getSource().isStrict() || !currentType.isTypeScript();
        List<JSType> originalTypes = currentType.getTypes();
        Collection<? extends JSType> results = JSCompositeTypeImpl.flattenAndDeduplicate(originalTypes, currentOptimized, targetKind, isUnion);
        if (results.size() == 1) {
            return results.iterator().next();
        }
        JSTypeSource source = currentType.getSource();
        if (results.isEmpty()) {
            return isWeakType ? JSAnyType.get(currentType.getSourceElement(), false) : new TypeScriptNeverJSTypeImpl(source);
        }
        if (isUnion) {
            JSUnionOrIntersectionType result2;
            JSUnionOrIntersectionType jSUnionOrIntersectionType = JSCompositeTypeImpl.equalsIdentity(results, originalTypes) ? currentType : (result2 = results.size() == 1 ? results.iterator().next() : new JSCompositeTypeImpl(source, results));
            if (allowResolve && result2 instanceof JSUnionOrIntersectionType) {
                JSCompositeTypeImpl.saveResolveOptimized(result2, targetKind);
            }
            return result2;
        }
        return JSCompositeTypeImpl.normalizeAndOptimizeIntersection(currentType, results, targetKind, source);
    }

    private static boolean equalsIdentity(Collection<? extends JSType> results, List<JSType> originalTypes) {
        return results instanceof List && ContainerUtil.equalsIdentity((List)((List)results), originalTypes);
    }

    @NotNull
    private static JSType normalizeAndOptimizeIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull Collection<? extends JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source) {
        boolean isContextual;
        boolean allowResolve;
        JSType normalized;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(5);
        }
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(6);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(7);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(8);
        }
        if ((normalized = JSCompositeTypeFactory.normalizeIfPossible((allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) ? StreamEx.of(results).map(el -> TypeScriptTypeRelations.expandAliasesRecursive(el)).toList() : results, source, allowResolve, !(isContextual = currentType instanceof JSContextualUnionType))) != null) {
            JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(normalized, targetKind);
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        return JSCompositeTypeImpl.setTargetAndReturnIntersection(currentType, results, targetKind, source, isContextual);
    }

    @NotNull
    private static JSType setTargetAndReturnIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull Collection<? extends JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source, boolean isContextual) {
        JSUnionOrIntersectionType result2;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(10);
        }
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(11);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(12);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(13);
        }
        JSUnionOrIntersectionType jSUnionOrIntersectionType = result2 = JSCompositeTypeImpl.equalsIdentity(results, currentType.getTypes()) ? currentType : JSCompositeTypeImpl.createIntersectionLikeType(results, source, isContextual);
        if (targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE && result2 instanceof JSUnionOrIntersectionType) {
            JSCompositeTypeImpl.saveResolveOptimized(result2, targetKind);
        }
        JSUnionOrIntersectionType jSUnionOrIntersectionType2 = result2;
        if (jSUnionOrIntersectionType2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(14);
        }
        return jSUnionOrIntersectionType2;
    }

    @NotNull
    private static JSType createIntersectionLikeType(@NotNull Collection<? extends JSType> results, @NotNull JSTypeSource source, boolean isContextual) {
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(16);
        }
        JSType jSType = isContextual ? JSCompositeTypeFactory.createContextualUnionType(results, source) : JSCompositeTypeFactory.createIntersectionType(results, source);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    @NotNull
    static Collection<? extends JSType> flattenAndDeduplicate(@NotNull Collection<? extends JSType> originalNestedTypes, @NotNull Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, boolean isUnion) {
        StreamEx typesStream;
        boolean allowResolve;
        if (originalNestedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(18);
        }
        if (currentOptimized == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(19);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(20);
        }
        boolean bl = allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        StreamEx streamEx = !currentOptimized.isEmpty() ? StreamEx.of(originalNestedTypes) : (typesStream = (StreamEx)JSCompositeTypeImpl.flattenTypesStream((StreamEx<? extends JSType>)StreamEx.of(originalNestedTypes).map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)), isUnion ? JSUnionType.class : JSIntersectionType.class).filter(el -> isUnion ? !JSCompositeTypeImpl.isEmptyType(el) : el != null && !(el instanceof JSUnknownType) && (!(el instanceof JSRecordType) || !((JSRecordType)el).getTypeMembers().isEmpty())));
        if (targetKind == JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED) {
            typesStream = (StreamEx)typesStream.filter(el -> !JSTypeUtils.isNullOrUndefinedType(el));
        } else if (targetKind == JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY) {
            typesStream = (StreamEx)typesStream.filter(el -> !JSTypeCastUtil.isFalsy(el));
        }
        List types2 = typesStream.toList();
        if (types2.size() <= 1) {
            List list2 = types2;
            if (list2 == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(21);
            }
            return list2;
        }
        return allowResolve ? JSCompositeTypeImpl.deduplicate(types2, isUnion) : JSCompositeTypeImpl.deduplicateNoResolve(types2, isUnion);
    }

    @NotNull
    private static List<JSType> deduplicate(@NotNull Collection<? extends JSType> types2, boolean isUnion) {
        if (types2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(22);
        }
        ArrayList<JSType> result2 = new ArrayList<JSType>(types2.size());
        TObjectIntHashMap indexes = new TObjectIntHashMap();
        JSUnknownType unknownType = null;
        for (JSType jSType : types2) {
            if (jSType instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list2 = Collections.singletonList(jSType);
                    if (list2 == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(23);
                    }
                    return list2;
                }
                unknownType = (JSUnknownType)jSType;
                continue;
            }
            if (jSType instanceof TypeScriptNeverJSTypeImpl && !isUnion) {
                List<JSType> list3 = Collections.singletonList(jSType);
                if (list3 == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(24);
                }
                return list3;
            }
            JSType forChecking = JSCompositeTypeImpl.toTypeForCheckingDuplication(jSType);
            JSResolvedTypeId id = forChecking.getResolvedTypeId();
            if (!indexes.containsKey((Object)id)) {
                indexes.put((Object)id, result2.size());
                result2.add(jSType);
                continue;
            }
            int oldIndex = indexes.get((Object)id);
            JSType oldType = (JSType)result2.get(oldIndex);
            JSType replacement = JSCompositeTypeImpl.getReplacementType(oldType, jSType);
            if (replacement == oldType) continue;
            result2.set(oldIndex, replacement);
        }
        if (result2.isEmpty() && unknownType != null) {
            List<Object> list4 = Collections.singletonList(unknownType);
            if (list4 == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(25);
            }
            return list4;
        }
        ArrayList<JSType> arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static JSType getReplacementType(@NotNull JSType oldType, @NotNull JSType newType) {
        if (oldType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(27);
        }
        if (newType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(28);
        }
        if (oldType instanceof JSDecoratedTypeImpl) {
            if (!(newType instanceof JSDecoratedTypeImpl)) {
                JSType jSType = newType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(29);
                }
                return jSType;
            }
            if (newType.getResolvedTypeId().equals(oldType.getResolvedTypeId())) {
                JSType jSType = oldType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(30);
                }
                return jSType;
            }
            JSDecoratedTypeImpl oldDecorated = (JSDecoratedTypeImpl)oldType;
            JSDecoratedTypeImpl newDecorated = (JSDecoratedTypeImpl)newType;
            Collection resultDecorators = ContainerUtil.intersection(oldDecorated.getDecorations(), newDecorated.getDecorations());
            if (resultDecorators.isEmpty()) {
                JSType jSType = oldDecorated.getOriginalType();
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(31);
                }
                return jSType;
            }
            return new JSDecoratedTypeImpl(oldDecorated.getSource(), oldDecorated.getOriginalType(), EnumSet.copyOf(resultDecorators));
        }
        JSType jSType = oldType;
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    private static JSType toTypeForCheckingDuplication(@NotNull JSType type) {
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(33);
        }
        if (type instanceof JSDecoratedTypeImpl) {
            return ((JSDecoratedTypeImpl)type).getOriginalType();
        }
        return type;
    }

    @NotNull
    private static List<JSType> deduplicateNoResolve(@NotNull Collection<? extends JSType> types2, boolean isUnion) {
        if (types2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(34);
        }
        ProcessingContext context = new ProcessingContext();
        ArrayList<JSType> result2 = new ArrayList<JSType>(types2.size());
        JSUnknownType hasUnknown = null;
        for (JSType jSType : types2) {
            if (jSType instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list2 = Collections.singletonList(jSType);
                    if (list2 == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(35);
                    }
                    return list2;
                }
                hasUnknown = (JSUnknownType)jSType;
                continue;
            }
            if (!result2.stream().noneMatch(resultedType -> fromCompare.isEquivalentTo(resultedType, context, false))) continue;
            result2.add(jSType);
        }
        if (result2.isEmpty() && hasUnknown != null) {
            List<Object> list3 = Collections.singletonList(hasUnknown);
            if (list3 == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(36);
            }
            return list3;
        }
        ArrayList<JSType> arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private static boolean isResolvedOptimizedAcceptable(@NotNull Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (currentOptimized == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(38);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(39);
        }
        return currentOptimized.contains((Object)targetKind);
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(40);
        }
        if (type2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(41);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(42);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(43);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(44);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(46);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(47);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSUnionType.class);
        if (source == null) {
            source = type1 instanceof JSUnionType || !(type2 instanceof JSUnionType) ? type1.getSource() : type2.getSource();
        }
        return JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<? extends JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(48);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(49);
        }
        JSUnionOrIntersectionType.OptimizedKind target = !allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE : (source.isTypeScript() ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        Collection<? extends JSType> types2 = JSCompositeTypeImpl.flattenAndDeduplicate(allCommonTypes, Collections.emptySet(), target, true);
        if (types2.size() == 0) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (types2.size() == 1) {
            JSType jSType = types2.iterator().next();
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(50);
            }
            return jSType;
        }
        return new JSCompositeTypeImpl(source, types2);
    }

    private static void saveResolveOptimized(@NotNull JSUnionOrIntersectionType type, @NotNull JSUnionOrIntersectionType.OptimizedKind kind) {
        EnumSet<JSUnionOrIntersectionType.OptimizedKind> flag;
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(51);
        }
        if (kind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(52);
        }
        if ((flag = (EnumSet<JSUnionOrIntersectionType.OptimizedKind>)type.getResolvedFlag(KEY_RESOLVE_OPTIMIZED)) == null) {
            flag = EnumSet.of(kind);
            type.setResolvedFlag(KEY_RESOLVE_OPTIMIZED, flag);
        } else {
            flag.add(kind);
        }
    }

    @ApiStatus.Internal
    public JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(53);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(54);
        }
        super(source, _types);
        this.myAnyType = this.getTypes().stream().anyMatch(el -> el instanceof JSAnyType);
    }

    @ApiStatus.Internal
    public JSCompositeTypeImpl(@NotNull JSTypeSource source, JSType ... _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(55);
        }
        this(source, Arrays.asList(_types));
    }

    JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(56);
        }
        if (inputStream == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(57);
        }
        super(source, inputStream);
        this.myAnyType = this.getTypes().stream().anyMatch(el -> el instanceof JSAnyType);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(58);
        }
        if (processingContext == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(59);
        }
        if (this.isAnyType()) {
            return true;
        }
        if (TypeScriptTypeRelations.isBooleanUnionType(this) && elementType instanceof JSBooleanType) {
            return true;
        }
        if (this.anyNestedTypeEqualsTo(elementType = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType), processingContext)) {
            return true;
        }
        boolean processingInProgress = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        if (elementType instanceof JSUnionType) {
            boolean checkAll = this.isTypeScript() && this.isSourceStrict() && elementType.isSourceStrict() || processingInProgress;
            return JSTypeCastUtil.checkAssignableComposite(this, (JSUnionType)elementType, processingContext, checkAll);
        }
        return this.anyNestedTypeIsAssignableTo(elementType, processingContext);
    }

    private boolean anyNestedTypeIsAssignableTo(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(60);
        }
        boolean hasAssignable = false;
        boolean isProcessingGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        for (JSType t : this.getTypes()) {
            if (JSCompositeTypeImpl.isEmptyType(t) || JSTypeUtils.isNullOrUndefinedType(t) || isProcessingGenerics && hasAssignable && JSCompositeTypeImpl.allGenericsMapped(t, processingContext) || !t.isDirectlyAssignableType(elementType, processingContext)) continue;
            hasAssignable = true;
            if (isProcessingGenerics) continue;
            return true;
        }
        return hasAssignable;
    }

    private static boolean allGenericsMapped(@NotNull JSType t, @NotNull ProcessingContext context) {
        if (t == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(61);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(62);
        }
        HashSet allIDs = new HashSet();
        t.transformTypeHierarchy(tt -> {
            if (tt instanceof JSGenericParameterImpl && ((JSGenericParameterImpl)tt).isApplying()) {
                allIDs.add(((JSGenericParameterImpl)tt).getGenericId());
            }
            return tt;
        });
        JSGenericMappings mappings = (JSGenericMappings)context.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        Set allInferredKeys = mappings.getMapping().keySet();
        allIDs.removeAll(allInferredKeys);
        return allIDs.isEmpty();
    }

    private boolean anyNestedTypeEqualsTo(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(63);
        }
        JSType regularLiteralType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(elementType);
        return this.getTypes().stream().anyMatch(type -> type != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(type).isEquivalentTo(regularLiteralType, processingContext));
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(64);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(65);
        }
        if (sourceOnly) {
            return new JSCompositeTypeImpl(newSource, transformedTypes);
        }
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(newSource, JSCompositeTypeImpl.flattenTypes((Stream<? extends JSType>)StreamEx.of(transformedTypes), this.getClass())), JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(66);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType result2;
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(67);
        }
        if ((result2 = this.getSimpleCompositeTypeResult()) != null) {
            return result2;
        }
        return TypeScriptTypeRelations.expandUnionOrIntersectionType(this, context);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeForSubstitute(this, this.getSourceElement());
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSRecordType jSRecordType = rawTypeToProcess.asRecordType();
            if (jSRecordType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(68);
            }
            return jSRecordType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            return new JSRecordTypeImpl(this.getSource(), ContainerUtil.emptyList());
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        ArrayList<JSRecordType.TypeMember> resultMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            ProgressManager.checkCanceled();
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            this.addCommonPropertyMember(resolvedTypes, resultMembers, (JSRecordType.PropertySignature)member);
        }
        this.addCommonCallSignatureMembers(resolvedTypes, resultMembers, item.getCallSignatures());
        return new JSRecordTypeImpl(this.getSource(), resultMembers);
    }

    private void addCommonCallSignatureMembers(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        JSRecordType functionTypeMembers;
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(69);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(70);
        }
        if (callSignatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(71);
        }
        if (callSignatures.isEmpty()) {
            return;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element == null || !element.isValid()) {
            return;
        }
        ProgressManager.checkCanceled();
        SmartList toProcessNewSignatures = new SmartList();
        SmartList toProcessCallSignatures = new SmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            (signature.hasNew() ? toProcessNewSignatures : toProcessCallSignatures).add(signature);
        }
        boolean collectNew = !toProcessNewSignatures.isEmpty();
        boolean collectCall = !toProcessCallSignatures.isEmpty();
        List<List<JSRecordType.CallSignature>> newTable = collectNew ? JSCompositeTypeImpl.createTable((List<JSRecordType.CallSignature>)toProcessNewSignatures) : ContainerUtil.emptyList();
        List<List<JSRecordType.CallSignature>> callTable = collectCall ? JSCompositeTypeImpl.createTable((List<JSRecordType.CallSignature>)toProcessCallSignatures) : ContainerUtil.emptyList();
        for (JSRecordType type : typesToMerge) {
            List signatures = type.getCallSignatures();
            if (collectCall) {
                collectCall = JSCompositeTypeImpl.addToTable(callTable, signatures, false);
            }
            if (!collectNew) continue;
            collectNew = JSCompositeTypeImpl.addToTable(newTable, signatures, true);
        }
        int before = resultMembers.size();
        if (collectCall) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(callTable, element));
        }
        if (collectNew) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(newTable, element));
        }
        if ((collectCall || collectNew) && before == resultMembers.size() && (functionTypeMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement())) != null) {
            resultMembers.addAll(functionTypeMembers.getTypeMembers());
        }
    }

    private static boolean addToTable(@NotNull List<List<JSRecordType.CallSignature>> callTable, @NotNull List<JSRecordType.CallSignature> signatures, boolean b) {
        if (callTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(72);
        }
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(73);
        }
        List<JSRecordType.CallSignature> collected = JSCompositeTypeImpl.getSignaturesWithKind(signatures, b);
        callTable.add(collected);
        return !collected.isEmpty();
    }

    @NotNull
    private static List<JSRecordType.CallSignature> getSignaturesWithKind(@NotNull List<JSRecordType.CallSignature> signatures, boolean hasNew) {
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(74);
        }
        List list2 = ContainerUtil.filter(signatures, el -> el.hasNew() == hasNew);
        if (list2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(75);
        }
        return list2;
    }

    private static List<List<JSRecordType.CallSignature>> createTable(@NotNull List<JSRecordType.CallSignature> value) {
        if (value == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(76);
        }
        ArrayList<List<JSRecordType.CallSignature>> result2 = new ArrayList<List<JSRecordType.CallSignature>>();
        result2.add(value);
        return result2;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> getUnionSignatures(@NotNull List<? extends List<JSRecordType.CallSignature>> signatureTable, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (signatureTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(77);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(78);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(79);
            }
            return list2;
        }
        ArrayList<JSRecordType.CallSignature> result2 = new ArrayList<JSRecordType.CallSignature>();
        ArrayList<JSRecordType.CallSignature> postponed = new ArrayList<JSRecordType.CallSignature>();
        for (int i = 0; i < signatureTable.size(); ++i) {
            List<JSRecordType.CallSignature> signatures = signatureTable.get(i);
            for (JSRecordType.CallSignature signature : signatures) {
                JSFunctionType type;
                JSRecordType.CallSignature callSignature;
                if (!result2.isEmpty() && TypeScriptSignatureChooser.findMatchedSignature(result2, signature, false, true) != null) continue;
                List<JSRecordType.CallSignature> matchingSignatures = TypeScriptSignatureChooser.findMatchingSignatures(signatureTable, signature, i);
                if (matchingSignatures.size() > 1) {
                    callSignature = matchingSignatures.get(0);
                    type = callSignature.getFunctionType();
                    boolean postponedAdd = false;
                    for (JSRecordType.CallSignature matchingSignature : matchingSignatures) {
                        JSFunctionType candidate = matchingSignature.getFunctionType();
                        if (type != candidate) {
                            JSFunctionType commonFunctionType = JSCompositeTypeImpl.getCommonFunctionType(type, candidate, holder);
                            if (commonFunctionType != null) {
                                type = commonFunctionType;
                            } else if (candidate.hasGenericArguments()) {
                                postponedAdd = true;
                                break;
                            }
                        }
                        if (!candidate.hasGenericArguments()) continue;
                        postponed.add(matchingSignature);
                        postponedAdd = true;
                        break;
                    }
                    if (postponedAdd) continue;
                    result2.add(new JSRecordTypeImpl.CallSignatureImpl(callSignature.hasNew(), type));
                    continue;
                }
                if (matchingSignatures.size() != 1) continue;
                callSignature = matchingSignatures.get(0);
                type = callSignature.getFunctionType();
                if (type.hasGenericArguments()) {
                    postponed.add(callSignature);
                    continue;
                }
                result2.add(callSignature);
            }
        }
        result2.addAll(postponed);
        ArrayList<JSRecordType.CallSignature> arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @Nullable
    private static JSFunctionType getCommonFunctionType(@NotNull JSFunctionType lType, @NotNull JSFunctionType rType, @NotNull DialectOptionHolder holder) {
        if (lType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(81);
        }
        if (rType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(82);
        }
        if (holder == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(83);
        }
        if (rType.isEquivalentTo((JSType)lType, null)) {
            return lType;
        }
        int count = JSCompositeTypeImpl.getIntersectionParameters(lType, rType);
        if (count == -1) {
            return null;
        }
        List lParameters = lType.getParameters();
        List rParameters = rType.getParameters();
        ArrayList<JSParameterTypeDecoratorImpl> resultParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        int lLength = lParameters.size();
        int rLength = rParameters.size();
        for (int i = 0; i < count; ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = lLength > i ? (JSParameterTypeDecorator)lParameters.get(i) : null;
            JSParameterTypeDecorator rDecorator = rLength > i ? (JSParameterTypeDecorator)rParameters.get(i) : null;
            JSType lParameterType = lDecorator == null || lDecorator.isRest() && rDecorator != null && !rDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(lParameters) : lDecorator.getSimpleType();
            JSType jSType = rParameterType = rDecorator == null || rDecorator.isRest() && lDecorator != null && !lDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(rParameters) : rDecorator.getSimpleType();
            if (lDecorator == null) {
                lDecorator = rDecorator;
            }
            if (rDecorator == null) {
                rDecorator = lDecorator;
            }
            if (rDecorator == null) {
                Logger.getInstance(JSCompositeTypeImpl.class).error("Incorrect state in signature merging \nltype: " + lType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) + "\nrtype: " + rType.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                return null;
            }
            JSType parameterType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lParameterType, rParameterType);
            boolean isOptional = lDecorator.isOptional() && rDecorator.isOptional();
            boolean explicit = rDecorator.isExplicitlyDeclared() && lDecorator.isExplicitlyDeclared();
            boolean isRest = lDecorator.isRest() && rDecorator.isRest();
            resultParameters.add(new JSParameterTypeDecoratorImpl(parameterType, isOptional, isRest, explicit));
        }
        JSType lReturnType = lType.getReturnType();
        JSType rReturnType = rType.getReturnType();
        JSType resultReturn = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lReturnType, rReturnType);
        return new JSFunctionTypeImpl(lType.getSource(), resultParameters, resultReturn);
    }

    private static int getIntersectionParameters(JSFunctionType commonCurrent, JSFunctionType type) {
        int min2;
        List commonCurrentParameters = commonCurrent.getParameters();
        List typeParameters = type.getParameters();
        int max1 = TypeScriptSignatureChooser.getMaxArgumentCount(commonCurrentParameters);
        int max2 = TypeScriptSignatureChooser.getMaxArgumentCount(typeParameters);
        int commonMaxLength = Math.min(max1, max2);
        int min1 = TypeScriptSignatureChooser.getMinArgumentCount(commonCurrentParameters);
        int commonMinLength = Math.max(min1, min2 = TypeScriptSignatureChooser.getMinArgumentCount(typeParameters));
        if (commonMinLength > commonMaxLength) {
            return -1;
        }
        if (commonMaxLength == commonMinLength) {
            return commonMaxLength;
        }
        return commonMaxLength == Integer.MAX_VALUE ? Math.min(commonCurrentParameters.size(), typeParameters.size()) : commonMaxLength;
    }

    @Nullable
    private static JSType getRestComponentType(@NotNull List<JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(84);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getSimpleType() != null ? JSTypeUtils.getIndexableComponentType(last.getSimpleType()) : null;
    }

    @Nullable
    private static JSType getCommonTypeWithDialect(@Nullable DialectOptionHolder holder, @Nullable JSType lType, @Nullable JSType rType) {
        JSType parameterType = null;
        if (lType != null && rType != null) {
            parameterType = JSTypeUtils.getCommonType(lType, rType, holder, true);
        }
        return parameterType != null ? parameterType : (lType == null ? rType : lType);
    }

    private void addCommonPropertyMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.PropertySignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(85);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(86);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(87);
        }
        ProgressManager.checkCanceled();
        ArrayList<JSType> commonTypes = new ArrayList<JSType>();
        JSType startType = currentProperty.getJSType();
        ContainerUtil.addIfNotNull(commonTypes, (Object)startType);
        String memberName = currentProperty.getMemberName();
        JSRecordType.MemberSource source = currentProperty.getMemberSource();
        HashSet<PsiElement> allProps = new HashSet<PsiElement>(source.getAllSourceElements());
        boolean isOptional = currentProperty.isOptional();
        boolean isReadonly = currentProperty.isConst();
        JSAnyType anyType = startType instanceof JSAnyType ? (JSAnyType)startType : null;
        for (JSRecordType resolvedType : typesToMerge) {
            ProgressManager.checkCanceled();
            JSRecordType.PropertySignature signature = resolvedType.findPropertySignature(memberName);
            if (signature == null) {
                JSRecordType.IndexSignature indexer = resolvedType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
                if (indexer != null) {
                    commonTypes.add(indexer.getMemberType());
                    continue;
                }
                return;
            }
            if (currentProperty == signature) continue;
            if (signature.isOptional()) {
                isOptional = true;
            }
            if (signature.isConst()) {
                isReadonly = true;
            }
            JSType type = signature.getJSType();
            if (anyType == null) {
                if (type instanceof JSAnyType) {
                    anyType = (JSAnyType)type;
                } else {
                    ContainerUtil.addIfNotNull(commonTypes, (Object)type);
                }
            }
            allProps.addAll(signature.getMemberSource().getAllSourceElements());
        }
        JSAnyType commonType = anyType != null ? anyType : JSCompositeTypeImpl.getCommonType(commonTypes, this.getSource(), true);
        String name = currentProperty.getMemberName();
        resultMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)commonType, isOptional, isReadonly, JSRecordMemberSourceFactory.createSource(allProps, JSRecordType.MemberSourceKind.Union)));
    }

    @Override
    public final boolean isAnyType() {
        return this.myAnyType;
    }

    @Override
    protected boolean skipTypeFromPresentable(JSType t) {
        return t instanceof TypeScriptNeverJSTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 66: 
            case 68: 
            case 75: 
            case 79: 
            case 80: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 66: 
            case 68: 
            case 75: 
            case 79: 
            case 80: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 66: 
            case 68: 
            case 75: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: 
            case 20: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 49: 
            case 53: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalNestedTypes";
                break;
            }
            case 19: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOptimized";
                break;
            }
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 33: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 58: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 62: 
            case 67: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 69: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMerge";
                break;
            }
            case 70: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultMembers";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTable";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureTable";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeForSubstitute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargetAndReturnIntersection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersectionLikeType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndDeduplicate";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementType";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateNoResolve";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesWithKind";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeForSubstitute";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 66: 
            case 68: 
            case 75: 
            case 79: 
            case 80: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfComposite";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfUnionOrIntersection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setTargetAndReturnIntersection";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createIntersectionLikeType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndDeduplicate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toTypeForCheckingDuplication";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateNoResolve";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedOptimizedAcceptable";
                break;
            }
            case 40: 
            case 41: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "saveResolveOptimized";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeIsAssignableTo";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "allGenericsMapped";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeEqualsTo";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addCommonCallSignatureMembers";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addToTable";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesWithKind";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getUnionSignatures";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFunctionType";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addCommonPropertyMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 66: 
            case 68: 
            case 75: 
            case 79: 
            case 80: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

