/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHelper {
    protected JSTypeHelper() {
    }

    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(2);
        }
        String lOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(lOpType, true);
        String rOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true);
        if (lOpQualifiedName == null || rOpQualifiedName == null) {
            return lOpQualifiedName == rOpQualifiedName;
        }
        PsiFile context = rOpType.getSource().getScope();
        if ("Iterable".equals(lOpQualifiedName) && JSTypeHelper.isBuiltInIterable(rOpQualifiedName)) {
            return true;
        }
        if (context == null) {
            return lOpQualifiedName.equals(rOpQualifiedName);
        }
        final Collection<String> possibleLNames = JSTypeHelper.getPossibleTypeNames(lOpType, lOpQualifiedName);
        if (possibleLNames.contains(rOpQualifiedName)) {
            return true;
        }
        final Ref result2 = Ref.create((Object)false);
        JSTypeEvaluateManager.iterateTypeHierarchy(rOpType, new JSHierarchyProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean process(@NotNull JSType type, @NotNull VirtualFile file2) {
                String qName;
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (qName = JSTypeUtils.getQualifiedNameMatchingType(type, false)) == null || this.processQName(qName);
            }

            @Override
            public boolean processClass(@NotNull JSClass clazz) {
                String qName;
                if (clazz == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((qName = clazz.getQualifiedName()) == null) {
                    return true;
                }
                if (!this.processQName(qName)) {
                    return false;
                }
                String name = clazz.getName();
                if (name == null || qName.equals(name)) {
                    return true;
                }
                PsiElement moduleCandidate = clazz.getContext();
                if (ES6PsiUtil.isExternalModule(moduleCandidate)) {
                    return this.processQName(name);
                }
                return true;
            }

            private boolean processQName(@Nullable String qName) {
                if (qName == null) {
                    return true;
                }
                if (this.visited.add(qName) && possibleLNames.contains(qName)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PsiElement)context, true, false, true);
        return (Boolean)result2.get();
    }

    @NotNull
    private static Collection<String> getPossibleTypeNames(@NotNull JSNamedType type, @NotNull String qName) {
        PsiElement module;
        String className2;
        JSResolvedTypeInfo info;
        JSClass jsClass;
        String text;
        if (type == null) {
            JSTypeHelper.$$$reportNull$$$0(3);
        }
        if (qName == null) {
            JSTypeHelper.$$$reportNull$$$0(4);
        }
        if (Objects.equals(text = type.getTypeText(), qName)) {
            List<String> list2 = Collections.singletonList(qName);
            if (list2 == null) {
                JSTypeHelper.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (type.isTypeScript() && type instanceof JSResolvableType && (jsClass = (info = ((JSResolvableType)((Object)type)).resolveType()).getDeclarationOfType(JSClass.class)) != null && (className2 = jsClass.getName()) != null && ES6PsiUtil.isExternalModule(module = jsClass.getContext())) {
            THashSet tHashSet = ContainerUtil.newTroveSet((Object[])new String[]{qName, className2});
            if (tHashSet == null) {
                JSTypeHelper.$$$reportNull$$$0(6);
            }
            return tHashSet;
        }
        Set<String> set = Collections.singleton(qName);
        if (set == null) {
            JSTypeHelper.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static boolean isBuiltInIterable(String rOpQualifiedName) {
        return "Set".equals(rOpQualifiedName) || "WeakSet".equals(rOpQualifiedName) || "Array".equals(rOpQualifiedName);
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(8);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(10);
        }
        if (rOpType instanceof JSNamedType) {
            JSResolvedTypeInfo info;
            boolean checkWithNamedType = true;
            if (!(rOpType instanceof JSResolvableType) && ((info = lOpType.resolveType()).isEnum() || info.isEnumLiteral())) {
                checkWithNamedType = false;
            }
            if (checkWithNamedType) {
                return this.areNamedTypesAssignable(lOpType, (JSNamedType)rOpType, processingContext);
            }
        }
        if (rOpType instanceof JSGenericTypeImpl) {
            return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
        }
        if (rOpType instanceof JSNullType) {
            return true;
        }
        if (rOpType instanceof JSArrayType && !((JSArrayType)rOpType).isPrimitive()) {
            return this.isAssignableToNamedType(lOpType, ((JSArrayType)rOpType).asGenericType(), processingContext);
        }
        if (rOpType instanceof JSRecordType) {
            return this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext).isAssignable();
        }
        return false;
    }

    protected JSTypeCastUtil.AssignableResult substituteLeftTypeAndCheckAssignable(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(11);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(13);
        }
        if (lOpType.isJavaScript() && lOpType.allowWidening()) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        JSRecordType lOpResolvedType = lOpType.asRecordType();
        if (lOpResolvedType == JSTypeCastUtil.NO_RECORD_TYPE) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        if (lOpResolvedType != lOpType) {
            return JSTypeCastUtil.toStrictAssignable(lOpResolvedType.isDirectlyAssignableType(rOpType, processingContext));
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    @Nullable
    public JSType getTypeForIndexing(@Nullable JSExpression expression, @NotNull PsiElement context) {
        JSType constant;
        if (context == null) {
            JSTypeHelper.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            return new JSUndefinedType(JSTypeSourceFactory.createTypeSource(context, true));
        }
        if (expression instanceof JSLiteralExpression && (constant = JSTypeEvaluator.getTypeFromConstant(expression)) != null) {
            return constant;
        }
        return null;
    }

    @NotNull
    public Object getScopeId(@NotNull JSNamedType type) {
        PsiFile scope;
        if (type == null) {
            JSTypeHelper.$$$reportNull$$$0(15);
        }
        if ((scope = type.getScope()) != null && scope.isValid() && JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)scope)) {
            PsiFile psiFile = scope;
            if (psiFile == null) {
                JSTypeHelper.$$$reportNull$$$0(16);
            }
            return psiFile;
        }
        String string = type.getResolvedTypeText();
        if (string == null) {
            JSTypeHelper.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTypeNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesAssignable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypeNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToNamedType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteLeftTypeAndCheckAssignable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForIndexing";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getScopeId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

