/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JavaScriptTypeGuard;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluationHelper {
    public static final JSTypeEvaluationHelper DEFAULT = new JSTypeEvaluationHelper();

    public JSGenericTypesEvaluator getGenericTypeEvaluator() {
        return TypeScriptGenericTypesEvaluator.getInstance();
    }

    @Nullable
    @Contract(value="!null,_,_ -> !null")
    protected JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
        PsiElement resolvedElement;
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(0);
        }
        if ((resolvedElement = context.getSource()) == null && source != null && source != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && source.isValid()) {
            resolvedElement = source;
        }
        return this.getGuardedTypeByEvaluateContext(type, context, resolvedElement, context.getProcessedExpression());
    }

    @Nullable
    @Contract(value="!null,_,_,_ -> !null")
    protected JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement resolvedElement, @Nullable JSReferenceExpression processedExpression) {
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(1);
        }
        if (resolvedElement != null && processedExpression != null && this.shouldGetTypeFromTypeGuard(context) && context.isJSElementsToApplyEmpty()) {
            JSType guardType;
            PsiElement namedCandidate = resolvedElement;
            if (resolvedElement instanceof TypeScriptMergedTypeImplicitElement) {
                namedCandidate = (PsiElement)ObjectUtils.chooseNotNull((Object)((TypeScriptMergedTypeImplicitElement)resolvedElement).getExplicitElement(), (Object)resolvedElement);
            }
            return (guardType = this.getTypeFromTypeGuard(namedCandidate, processedExpression, type, resolvedElement)) == null ? type : guardType;
        }
        return type;
    }

    protected boolean shouldGetTypeFromTypeGuard(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(2);
        }
        return context.isAstAccessAllowed();
    }

    @Nullable
    public JSType getTypeFromTypeGuard(@NotNull PsiElement namedElement, @Nullable JSReferenceExpression expression, @Nullable JSType preprocessedType, @Nullable PsiElement resolvedElement) {
        if (namedElement == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(3);
        }
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, namedElement)) {
            return this.createGuard(expression, preprocessedType, resolvedElement).getNarrowedType();
        }
        return preprocessedType;
    }

    @NotNull
    protected JSTypeGuardChecker createGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (reference == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(4);
        }
        return new JSTypeGuardChecker(reference, startType, false, JavaScriptTypeGuard.useAutoVariableType(reference, resolveElement), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluationHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGuardedTypeByEvaluateContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldGetTypeFromTypeGuard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromTypeGuard";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createGuard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

