/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexBasedResolveUtil {
    private static final int MAX_FILES_TO_PROCESS = Integer.valueOf(System.getProperty("js.max.files.to.process", "10"));

    public static void processAllSymbols(WalkUpResolveProcessor processor) {
        JSIndexBasedResolveUtil.processAllSymbols(processor, false, null, false, true);
    }

    static void processAllSymbols(@NotNull WalkUpResolveProcessor processor, boolean ignorePerformanceLimit, @Nullable PsiFile limitingScope, boolean excludeJsLibs, boolean includeTypeOnlyContextSymbols) {
        PsiElement context;
        GlobalSearchScope allScope;
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = allScope = DialectDetector.isTypeScript(context = processor.getContext()) ? TypeScriptConfigService.Provider.getConfigResolveScope(context) : JSResolveUtil.getResolveScope(context);
        if (excludeJsLibs) {
            allScope = JSIndexBasedResolveUtil.getScopeForGlobalResolve(allScope);
        }
        if (limitingScope != null) {
            allScope = GlobalSearchScope.fileScope((PsiFile)limitingScope).intersectWith(allScope);
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor, allScope, ignorePerformanceLimit, includeTypeOnlyContextSymbols);
    }

    @NotNull
    public static GlobalSearchScope getScopeForGlobalResolve(GlobalSearchScope allScope) {
        final Set<VirtualFile> files = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles();
        Object object = allScope = new DelegatingGlobalSearchScope((GlobalSearchScope)allScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && !files.contains(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$1", "contains"));
            }
        };
        if (object == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static void processAllSymbols(final @NotNull WalkUpResolveProcessor processor, @NotNull GlobalSearchScope includeScope, boolean ignorePerformanceLimit, boolean includeTypeOnlyContextSymbols) {
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(2);
        }
        if (includeScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(3);
        }
        PsiFile file2 = processor.getBaseFile();
        Project project = file2.getProject();
        String name = processor.getRequiredName();
        Set resultsBeforeProcessingFromIndex = processor.getTaggedResolveResults().stream().map(result2 -> result2.result.getElement()).collect(Collectors.toSet());
        JSSymbolCollector collector = new JSSymbolCollector(resultsBeforeProcessingFromIndex, includeTypeOnlyContextSymbols, processor.myContext);
        for (JSContextLevel level : processor.getTypeInfo().myContextLevels) {
            GlobalSearchScope scope;
            JSNamespace namespace = level.myNamespace;
            JSQualifiedName ns = namespace.getQualifiedName();
            String qName = ns != null ? ns.getQualifiedName() + "." + name : name;
            PsiFile fileToIncludeLocal = level.myNamespace.getSource().getScope();
            GlobalSearchScope globalSearchScope = scope = level.myNamespace.isLocal() && fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : includeScope;
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcessByQName(includeScope, project, qName)) {
                JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, scope, fileToIncludeLocal, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_QNAME, (Object)collector.myCollectedElements.size());
                continue;
            }
            processor.setTooManyCandidates();
            return;
        }
        JSIndexBasedResolveUtil.checkElements(processor, collector);
        List<JSTaggedResolveResult> resultsWithCompleteMatches = processor.getTaggedResolveResults();
        boolean hasValidResult = false;
        for (JSTaggedResolveResult completeMatchResult : resultsWithCompleteMatches) {
            if (!completeMatchResult.result.isValidResult() || completeMatchResult.hasTag(JSTaggedResolveResult.ResolveResultTag.PARTIAL)) continue;
            hasValidResult = true;
            break;
        }
        if (!hasValidResult && !processor.addOnlyCompleteMatches()) {
            StubIndexKey<String, JSElement> indexKey;
            StubIndexKey<String, JSElement> stubIndexKey = processor.getTypeInfo().isGlobalContext() ? JSGlobalSymbolIndex.KEY : (indexKey = processor.getTypeInfo().isNonGlobalContext() ? JSNonGlobalSymbolIndex.KEY : JSSymbolIndex2.KEY);
            if (ignorePerformanceLimit || JSIndexBasedResolveUtil.cheapEnoughToProcess(includeScope, project, name, indexKey)) {
                JSClassResolver.processElementsByNameIncludingImplicit(name, includeScope, false, indexKey, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_NAME, (Object)collector.myCollectedElements.size());
                JSIndexBasedResolveUtil.checkElements(processor, collector);
            } else {
                processor.setTooManyCandidates();
                return;
            }
        }
        JSIndexBasedResolveUtil.processImplicitElementProxies(name, includeScope, project, new JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return processor.acceptsFile(file2);
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                processor.doQualifiedCheck(element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean cheapEnoughToProcessByQName(@NotNull GlobalSearchScope allScope, @NotNull Project project, @NotNull String name) {
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(6);
        }
        IdIterator ids = StubIndex.getInstance().getContainingIds(JSSymbolQualifiedNamesIndex.KEY, (Object)name.hashCode(), project, allScope);
        return JSIndexBasedResolveUtil.hasLessFilesInScope(allScope, ids, MAX_FILES_TO_PROCESS * 3);
    }

    private static boolean cheapEnoughToProcess(@NotNull GlobalSearchScope allScope, @NotNull Project project, @NotNull String name, @NotNull StubIndexKey<String, JSElement> indexKey) {
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(9);
        }
        if (indexKey == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(10);
        }
        IdIterator ids = StubIndex.getInstance().getContainingIds(indexKey, (Object)name, project, allScope);
        return JSIndexBasedResolveUtil.hasLessFilesInScope(allScope, ids, MAX_FILES_TO_PROCESS);
    }

    private static boolean hasLessFilesInScope(@NotNull GlobalSearchScope allScope, IdIterator ids, int filesLimit) {
        if (allScope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(11);
        }
        int exactSize = 0;
        if (ids.size() <= filesLimit) {
            return true;
        }
        while (ids.hasNext()) {
            VirtualFile file2 = ManagingFS.getInstance().findFileById(ids.next());
            if (file2 == null || allScope.contains(file2)) {
                ++exactSize;
            }
            if (exactSize <= filesLimit) continue;
            return false;
        }
        return true;
    }

    private static void checkElements(WalkUpResolveProcessor processor, JSSymbolCollector collector) {
        collector.checkElements(element -> {
            ProgressManager.checkCanceled();
            if (!processor.acceptsFile(element.getContainingFile())) {
                return;
            }
            if (element instanceof JSQualifiedNamedElement || element instanceof JSImplicitElement) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
            } else {
                processor.doUnqualifiedCheck((PsiElement)element);
            }
        });
    }

    public static boolean processImplicitElementProxies(@Nullable String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull JSSymbolProcessor processor) {
        if (scope == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            JSIndexBasedResolveUtil.$$$reportNull$$$0(14);
        }
        Set<String> implicitKeys = name != null ? Collections.singleton(name) : FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        ArrayList implicitElementProxies = new ArrayList();
        for (String key : implicitKeys) {
            FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key, null, (virtualFile, value) -> {
                implicitElementProxies.add(Pair.create((Object)virtualFile, (Object)value));
                return true;
            }, scope);
        }
        for (Pair pair : implicitElementProxies) {
            VirtualFile virtualFile2 = (VirtualFile)pair.first;
            Collection value2 = (Collection)pair.second;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile == null || !processor.acceptsFile(psiFile)) continue;
            for (JSImplicitElementsIndex.JSElementProxy proxy : value2) {
                JSOffsetBasedImplicitElement element = proxy.toOffsetBasedImplicitElement(psiFile);
                if (element.getUserString() != null || processor.process((JSPsiElementBase)element)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeScope";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allScope";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForGlobalResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllSymbols";
                break;
            }
            case 1: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cheapEnoughToProcessByQName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cheapEnoughToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasLessFilesInScope";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElementProxies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSSymbolCollector
    implements Processor<JSPsiElementBase> {
        @NotNull
        private final List<PsiElement> myCollectedElements;
        @Nullable
        private Set<PsiElement> myCheckedElements;
        private Set<? super PsiElement> myProcessedElements;
        private final boolean myIncludeTypeOnlyContextSymbols;
        @Nullable
        private final JSCoreLibraryElementsCollector<Void> myCoreLibraryElementsCollector;

        JSSymbolCollector(@NotNull Set<? super PsiElement> alreadyProcessed, boolean includeTypeOnlyContextSymbols, @NotNull PsiElement context) {
            if (alreadyProcessed == null) {
                JSSymbolCollector.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSSymbolCollector.$$$reportNull$$$0(1);
            }
            this.myIncludeTypeOnlyContextSymbols = includeTypeOnlyContextSymbols;
            this.myCoreLibraryElementsCollector = new JSCoreLibraryElementsCollector(context);
            this.myCollectedElements = new ArrayList<PsiElement>();
            this.myProcessedElements = alreadyProcessed;
        }

        public boolean process(JSPsiElementBase element) {
            if (this.myCoreLibraryElementsCollector != null && this.myCoreLibraryElementsCollector.isLibraryElement((PsiElement)element)) {
                this.myCoreLibraryElementsCollector.addElement((PsiElement)element, null);
                return true;
            }
            if (this.myCheckedElements != null) {
                if (this.myProcessedElements == null) {
                    this.myProcessedElements = this.myCheckedElements;
                } else {
                    this.myProcessedElements.addAll(this.myCheckedElements);
                }
                this.myCheckedElements = null;
            }
            if (element instanceof JSFunctionExpression || element instanceof ES6Decorator || !this.myIncludeTypeOnlyContextSymbols && element instanceof TypeScriptInterface) {
                return true;
            }
            if (this.myProcessedElements == null || !this.myProcessedElements.contains(element)) {
                this.myCollectedElements.add((PsiElement)element);
            }
            return true;
        }

        public void checkElements(@NotNull Consumer<? super PsiElement> consumer) {
            if (consumer == null) {
                JSSymbolCollector.$$$reportNull$$$0(2);
            }
            Set<PsiElement> coreElements = this.myCoreLibraryElementsCollector == null ? Collections.emptySet() : this.myCoreLibraryElementsCollector.getElements();
            THashSet elements = new THashSet(this.myCollectedElements.size() + coreElements.size());
            Consumer<PsiElement> elementConsumer = arg_0 -> JSSymbolCollector.lambda$checkElements$0((Set)elements, consumer, arg_0);
            this.myCollectedElements.forEach(elementConsumer);
            coreElements.forEach(elementConsumer);
            this.myCheckedElements = elements;
            this.myCollectedElements.clear();
        }

        private static /* synthetic */ void lambda$checkElements$0(Set elements, Consumer consumer, PsiElement e) {
            if (elements.add(e)) {
                consumer.accept(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alreadyProcessed";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSIndexBasedResolveUtil$JSSymbolCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface JSSymbolProcessor {
        public boolean acceptsFile(@NotNull PsiFile var1);

        public boolean process(@NotNull JSPsiElementBase var1);
    }
}

