/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceSetElement
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    @NotNull
    protected final String myCanonicalText;
    @NotNull
    protected final TextRange myRangeInElement;
    @NotNull
    protected final JSReferenceSet mySet;

    protected JSReferenceSetElement(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSReferenceSetElement.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSReferenceSetElement.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(2);
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.mySet.getElement();
        if (psiElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSReferenceSetElement.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    public final PsiElement resolve() {
        Object[] resolveResults = this.multiResolve(false);
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    public final ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.mySet.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file2, this, (reference, __) -> reference.doResolve(), incompleteCode);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] doResolve() {
        ResolveResult[] resolveResultArray = this.doResolveQualifiedName(this.getQualifiedName());
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public ResolveResult @NotNull [] doResolveQualifiedName(@NotNull JSQualifiedName qualifiedName) {
        ResolveResult[] localResults;
        if (qualifiedName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(7);
        }
        PsiElement referenceElement = this.mySet.getElement();
        PsiFile psiFile = this.getElement().getContainingFile();
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(qualifiedName.getName(), psiFile, referenceElement);
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            processor.addTypeHierarchy(JSNamedTypeFactory.createNamespace(qualifier, JSContext.UNKNOWN, this.getElement(), true));
        }
        processor.allowPartialResults();
        String str = qualifiedName.getQualifiedName();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(referenceElement, str));
            this.processLocalVariants(localProcessor);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            if (localResults == null) {
                JSReferenceSetElement.$$$reportNull$$$0(8);
            }
            return localResults;
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor);
        ResolveResult[] results = processor.getResults();
        if (results.length == 0 && "undefined".equals(str)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(referenceElement)};
            if (resolveResultArray == null) {
                JSReferenceSetElement.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSReferenceSetElement.$$$reportNull$$$0(10);
        }
        return results;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            JSReferenceSetElement.$$$reportNull$$$0(11);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(12);
        }
        return JSReferenceSetElement.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qName;
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(13);
        }
        if ((qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element)) != null) {
            JSReferenceSetElement.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    @Nullable
    public PsiReference getQualifier() {
        if (this.isPrimary()) {
            return null;
        }
        PsiReference qualifier = null;
        for (PsiReference reference : this.mySet.getReferences()) {
            if (reference == this) {
                return qualifier;
            }
            qualifier = reference;
        }
        return qualifier;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    public LocalQuickFix[] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedNameImpl qName = null;
        for (PsiReference ref : this.mySet.myReferences) {
            qName = JSQualifiedNameImpl.create(ref.getCanonicalText(), qName);
            if (ref == this) break;
        }
        assert (qName != null) : this;
        JSQualifiedNameImpl jSQualifiedNameImpl = qName;
        if (jSQualifiedNameImpl == null) {
            JSReferenceSetElement.$$$reportNull$$$0(15);
        }
        return jSQualifiedNameImpl;
    }

    public void processLocalVariants(SinkResolveProcessor<?> processor) {
    }

    protected static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.handleContentChange((PsiElement)elt, (TextRange)range, (String)newElementName);
    }

    @NotNull
    public JSReferenceSet getSet() {
        JSReferenceSet jSReferenceSet = this.mySet;
        if (jSReferenceSet == null) {
            JSReferenceSetElement.$$$reportNull$$$0(16);
        }
        return jSReferenceSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

