/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionParameterExpectedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSReturnedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeEvaluator
extends JSElementVisitor {
    protected final PsiElement myParent;
    protected final JSExpectedTypeKind myExpectedTypeKind;
    protected final PsiElement myGrandParent;
    private JSType myResult;

    public ExpectedTypeEvaluator(@NotNull PsiElement parent, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (parent == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(1);
        }
        this.myParent = parent;
        this.myExpectedTypeKind = expectedTypeKind;
        this.myGrandParent = this.myParent.getParent();
    }

    private static JSType findExpectedTypeWithNewEvaluator(@NotNull JSExpression parent, @NotNull JSExpectedTypeKind kind) {
        if (parent == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(3);
        }
        return JSDialectSpecificHandlersFactory.findExpectedType(parent, kind);
    }

    protected void setResult(@Nullable JSType result2) {
        this.myResult = result2;
    }

    protected JSType getResult() {
        return this.myResult;
    }

    @Nullable
    public final JSType findExpectedType() {
        Language language = this.myParent.getLanguage();
        JSType typeFromFramework = JSFrameworkSpecificHandlersFactory.EP_NAME.allForLanguage(language).stream().map(factory -> this.myParent instanceof JSExpression ? factory.findExpectedType((JSExpression)this.myParent, this.myExpectedTypeKind) : factory.findExpectedType(this.myParent, this.myExpectedTypeKind)).filter(Objects::nonNull).findFirst().orElse(null);
        if (typeFromFramework != null) {
            return typeFromFramework;
        }
        this.myGrandParent.accept((PsiElementVisitor)this);
        JSType result2 = this.getResult();
        return this.convertToContextual(result2);
    }

    @Nullable
    private JSType convertToContextual(@Nullable JSType type) {
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
        if (this.myExpectedTypeKind == JSExpectedTypeKind.CONTEXTUAL) {
            if (expanded instanceof JSUnionType) {
                return JSCompositeTypeFactory.createContextualUnionType(((JSUnionType)expanded).getTypes(), JSTypeSourceFactory.createTypeSource(this.myParent, true));
            }
            return expanded;
        }
        if ((this.myExpectedTypeKind == JSExpectedTypeKind.WIDENING || this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) && expanded instanceof TypeScriptConditionalTypeJSTypeImpl && JSTypeUtils.hasForeignGenericParameter(((TypeScriptConditionalTypeJSTypeImpl)expanded).getCheckedType())) {
            ArrayList<JSType> allTypes = new ArrayList<JSType>();
            JSTypeUtils.addAllUnionParts(((TypeScriptConditionalTypeJSTypeImpl)expanded).getTypeIfTrue(), allTypes);
            JSTypeUtils.addAllUnionParts(((TypeScriptConditionalTypeJSTypeImpl)expanded).getTypeIfFalse(), allTypes);
            return JSCompositeTypeFactory.createContextualUnionType(allTypes, JSTypeSourceFactory.createTypeSource(this.myParent, true));
        }
        return expanded;
    }

    public void visitJSFunctionExpression(JSFunctionExpression node) {
        if (node.isShorthandArrowFunction()) {
            JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)node);
            if (returnExpression != null) {
                this.appendExpectedReturnType(returnExpression, (PsiElement)returnExpression, (JSFunction)node);
            }
            return;
        }
        super.visitJSFunctionExpression(node);
    }

    public void visitJSSpreadExpression(JSSpreadExpression spreadExpression) {
        JSType spreadExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)spreadExpression, this.myExpectedTypeKind);
        if (spreadExpectedType != null) {
            this.setResult(new JSArrayTypeImpl(spreadExpectedType, JSTypeSourceFactory.createTypeSource((PsiElement)spreadExpression, true)));
        }
        super.visitJSSpreadExpression(spreadExpression);
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)this.myGrandParent, (Class[])new Class[]{JSFunction.class});
        if (fun == null) {
            return;
        }
        if (!(fun instanceof JSExpression) && this.myExpectedTypeKind.isContextual() && fun.getReturnTypeElement() == null) {
            return;
        }
        this.appendExpectedReturnType(node.getExpression(), (PsiElement)node, fun);
    }

    private void appendExpectedReturnType(@Nullable JSExpression expression, PsiElement sourceNode, JSFunction fun) {
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
            this.appendReturnResultForExpected(expression, sourceNode, fun);
        }
        if (this.myExpectedTypeKind.isContextual()) {
            this.appendReturnResultForContextual(sourceNode, fun);
        }
    }

    private void appendReturnResultForContextual(PsiElement sourceNode, JSFunction fun) {
        JSType returnType = ExpectedTypeEvaluator.getReturnTypeUnwrappingAsync(fun);
        if (returnType != null && !ExpectedTypeEvaluator.isInferredReturnType(returnType)) {
            JSTypeSource typeSource = returnType.getSource();
            if (typeSource.isStrict()) {
                this.setResult(returnType);
            }
        } else {
            this.addTypeFromFunctionExpression(sourceNode, fun);
        }
    }

    @Nullable
    private static JSType getReturnTypeUnwrappingAsync(JSFunction fun) {
        JSType type = fun.getReturnType();
        if (fun.isAsync()) {
            JSType promiseComponentType;
            JSType jSType = promiseComponentType = type == null ? null : JSTypeUtils.getPromiseComponentTypeOrNull(type);
            if (promiseComponentType != null) {
                return promiseComponentType;
            }
        }
        return type;
    }

    private static boolean isInferredReturnType(@Nullable JSType returnType) {
        return returnType instanceof JSCodeBasedType || returnType instanceof JSUnionType && ((JSUnionType)returnType).getTypes().stream().anyMatch(ExpectedTypeEvaluator::isInferredReturnType);
    }

    private void appendReturnResultForExpected(JSExpression expression, PsiElement sourceNode, JSFunction fun) {
        JSTypeSource typeSource;
        JSType returnType = ExpectedTypeEvaluator.getReturnTypeUnwrappingAsync(fun);
        JSTypeSource jSTypeSource = typeSource = returnType != null ? returnType.getSource() : null;
        if (returnType != null && typeSource.isStrict()) {
            if (returnType instanceof JSUnionType) {
                List filtered = ContainerUtil.filter(((JSUnionType)returnType).getTypes(), t -> !ExpectedTypeEvaluator.isSelfInducedType(expression, fun, t, t.getSourceElement()));
                if (ContainerUtil.filter((Collection)filtered, t -> !JSTypeUtils.isNullOrUndefinedType(t)).isEmpty()) {
                    return;
                }
                returnType = JSCompositeTypeFactory.createUnionType(typeSource, filtered);
            } else if (ExpectedTypeEvaluator.isSelfInducedType(expression, fun, returnType, typeSource.getSourceElement())) {
                this.addTypeFromFunctionExpression(sourceNode, fun);
                return;
            }
            this.setResult(returnType);
        }
    }

    private static boolean isSelfInducedType(JSExpression expression, JSFunction fun, JSType returnType, PsiElement sourceElement) {
        if (sourceElement == null) {
            return false;
        }
        if (returnType instanceof JSReturnedExpressionType) {
            returnType = returnType.substitute();
            sourceElement = returnType.getSourceElement();
        }
        return sourceElement == JSUtils.unparenthesize(expression);
    }

    private void addTypeFromFunctionExpression(@NotNull PsiElement node, @Nullable JSFunction fun) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (fun instanceof JSFunctionExpression) {
            JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)((JSFunctionExpression)fun), this.myExpectedTypeKind);
            if (parentExpectedType instanceof JSFunctionTypeImpl) {
                this.setResult(((JSFunctionTypeImpl)parentExpectedType).getReturnType());
            } else {
                ArrayList types2 = new ArrayList();
                JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
                    if (t instanceof JSFunctionTypeImpl) {
                        types2.add(((JSFunctionTypeImpl)t).getReturnType());
                    }
                    return true;
                }), parentExpectedType);
                if (!types2.isEmpty()) {
                    this.setResult(JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource(node, true)));
                }
            }
        }
    }

    public void visitJSIfStatement(JSIfStatement node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myParent) {
            this.setResult(this.createNamedType("Boolean", this.myGrandParent));
        }
    }

    public void visitJSLoopStatement(JSLoopStatement node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCondition() == this.myParent) {
            this.setResult(this.createNamedType("Boolean", this.myGrandParent));
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (ES6PsiUtil.isAwaitExpression((PsiElement)node)) {
            JSType jsType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
            if (jsType != null) {
                this.setResult(JSTypeUtils.wrapInPromiseType(jsType, JSTypeSourceFactory.createTypeSource((PsiElement)node, true)));
            }
            return;
        }
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (!(JSTokenTypes.EXCL != node.getOperationSign() || node.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)node.getParent()).getOperationSign())) {
            this.setResult(this.createNamedType("Boolean", this.myGrandParent));
        }
    }

    public void visitJSThrowStatement(JSThrowStatement node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        this.evaluateThrowType();
    }

    public void visitJSThrowExpression(JSThrowExpression node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        this.evaluateThrowType();
    }

    private void evaluateThrowType() {
        PsiComment docComment;
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSFunction.class);
        if (fun != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)fun)) != null) {
            final Ref throwsTypeFromCommentRef = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return false;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (line == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (patternMatched == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.THROWS && matchValue != null) {
                        throwsTypeFromCommentRef.set((Object)matchValue);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "line";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "patternMatched";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCommentLine";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onPatternMatch";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            String throwsTypeFromComment = (String)throwsTypeFromCommentRef.get();
            if (throwsTypeFromComment != null) {
                this.setResult(JSTypeUtils.createType(throwsTypeFromComment, JSTypeSourceFactory.createTypeSource(this.myGrandParent, true)));
                return;
            }
        }
        this.setResult(this.createNamedType("Error", this.myGrandParent));
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getCondition() == this.myParent) {
            this.setResult(this.createNamedType("Boolean", this.myGrandParent));
        } else {
            JSType parentType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node, this.myExpectedTypeKind);
            if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED) {
                JSExpression otherExpr;
                JSExpression then = JSUtils.unparenthesize(node.getThen());
                JSExpression elze = JSUtils.unparenthesize(node.getElse());
                Object object = then == this.myParent ? elze : (otherExpr = elze == this.myParent ? then : null);
                if (otherExpr != null) {
                    JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
                    this.assignFromParentOrOtherSide(parentType, leftType, null);
                }
            }
            if (this.getResult() == null) {
                this.setResult(parentType);
            }
        }
    }

    public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getIndexExpression() == this.myParent) {
            this.evaluateIndexedAccessType(node);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        this.setResult(this.createNamedType("number", this.myGrandParent));
    }

    public void visitJSYieldExpression(JSYieldExpression statement) {
        JSFunction function2 = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)statement, (Class[])new Class[]{JSFunction.class});
        if (function2 == null || !function2.isGenerator()) {
            return;
        }
        if (function2.getReturnTypeElement() == null && this.myExpectedTypeKind.isContextual()) {
            return;
        }
        JSType returnType = function2.getReturnType();
        if (returnType == null) {
            return;
        }
        JSType type = JSTypeUtils.getIterableComponentType(returnType);
        if (type != null) {
            this.setResult(type);
        }
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        IElementType opType = node.getOperationSign();
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && node.getROperand() == this.myParent) {
            if (JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType) {
                this.setResult(this.createNamedType("Boolean", this.myGrandParent));
            } else {
                JSExpression lOperand = node.getLOperand();
                if (lOperand != null) {
                    JSType type = this.getQualifiedExpressionType(lOperand);
                    if (type instanceof JSLiteralType && (JSTokenTypes.ARITHMETIC_OPERATIONS.contains(opType) || JSTokenTypes.EQUALITY_OPERATIONS.contains(opType) && lOperand instanceof JSLiteralExpression)) {
                        type = ((JSLiteralType)type).asPrimitiveType();
                    }
                    this.setResult(type);
                }
            }
        }
        Object parentType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED && parentType != null) {
            if (this.myExpectedTypeKind.isContextual() && node.getROperand() == this.myParent) {
                if (parentType instanceof JSCodeBasedType) {
                    PsiElement sourceElement = parentType.getSource().getSourceElement();
                    parentType = sourceElement != null ? null : parentType.substitute();
                }
                this.setResult(this.fixResultForOrOrRightOp((JSType)parentType, node.getLOperand()));
            } else {
                this.setResult((JSType)parentType);
            }
            return;
        }
        JSExpression otherExpr = null;
        if (JSTokenTypes.OROR == opType && node.getROperand() == this.myParent) {
            otherExpr = node.getLOperand();
        }
        if (JSTokenTypes.OROR == opType && node.getLOperand() == this.myParent) {
            otherExpr = node.getROperand();
        }
        if (otherExpr != null) {
            JSType leftType = JSResolveUtil.getExpressionJSType(otherExpr);
            this.assignFromParentOrOtherSide((JSType)parentType, leftType, null);
        }
    }

    protected JSType getQualifiedExpressionType(JSExpression qualifier) {
        return JSResolveUtil.getExpressionJSType(qualifier);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type, @Nullable JSExpression operand) {
        return type;
    }

    private void assignFromParentOrOtherSide(JSType parentType, JSType leftType, Collection<JSType> miscTypes) {
        if (parentType == null && miscTypes == null) {
            if (leftType != null) {
                this.setResult(leftType);
            }
        } else if (leftType == null && miscTypes == null) {
            this.setResult(parentType);
        } else {
            int count;
            int n = count = miscTypes != null ? miscTypes.size() : 0;
            if (parentType != null) {
                ++count;
            }
            if (leftType != null) {
                ++count;
            }
            ArrayList<JSType> typeList = new ArrayList<JSType>(count);
            if (parentType != null) {
                typeList.add(parentType);
            }
            if (leftType != null) {
                typeList.add(leftType);
            }
            if (miscTypes != null) {
                typeList.addAll(miscTypes);
            }
            this.setResult(JSCompositeTypeFactory.createContextualUnionType(typeList, JSTypeSourceFactory.createTypeSource(this.myParent, false)));
        }
    }

    public void visitJSCaseClause(JSCaseClause node) {
        JSExpression switchExpression;
        JSSwitchStatement switchStatement;
        if (this.myExpectedTypeKind != JSExpectedTypeKind.EXPECTED) {
            return;
        }
        if (node.getCaseExpression() == this.myParent && (switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSSwitchStatement.class)) != null && (switchExpression = switchStatement.getSwitchExpression()) != null) {
            this.setResult(this.getQualifiedExpressionType(switchExpression));
        }
    }

    public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
        if (!(this.myParent instanceof JSProperty)) {
            return;
        }
        JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
        if (parentExpectedType == null) {
            return;
        }
        this.forProperty((JSProperty)this.myParent, node, parentExpectedType);
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement parent = node.getParent();
        if (!(parent instanceof JSObjectLiteralExpression)) {
            return;
        }
        JSType parentExpectedType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)((JSObjectLiteralExpression)parent), this.myExpectedTypeKind);
        if (parentExpectedType == null) {
            return;
        }
        this.forProperty(node, (JSObjectLiteralExpression)parent, parentExpectedType);
    }

    protected void forProperty(@NotNull JSProperty propertyForExpectedType, @NotNull JSObjectLiteralExpression literal, @NotNull JSType parentExpectedType) {
        if (propertyForExpectedType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (literal == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (parentExpectedType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (ExpectedTypeEvaluator.hasElementInSource((PsiElement)literal, parentExpectedType)) {
            return;
        }
        if (parentExpectedType instanceof JSUnionOrIntersectionType && ((JSUnionOrIntersectionType)parentExpectedType).getTypes().stream().anyMatch(el -> ExpectedTypeEvaluator.hasElementInSource((PsiElement)literal, el))) {
            return;
        }
        String name = propertyForExpectedType.getName();
        if (propertyForExpectedType instanceof JSComputedPropertyNameOwner && StringUtil.isEmpty((String)name)) {
            name = TypeScriptTypeMemberParser.tryGetComputedName((JSComputedPropertyNameOwner)propertyForExpectedType);
        }
        if (!StringUtil.isEmpty((String)name)) {
            ArrayList allTypes = new ArrayList();
            String finalName = name;
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type -> !ExpectedTypeEvaluator.addExpectedObjectPropertyType(type, finalName, allTypes)), parentExpectedType);
            List<JSType> types2 = JSCompositeTypeBaseImpl.flattenTypes(allTypes.stream(), JSUnionType.class);
            if (!types2.isEmpty()) {
                this.setResult(JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)propertyForExpectedType, true)));
            }
        }
    }

    private static boolean hasElementInSource(@NotNull PsiElement parent, @NotNull JSType currentType) {
        PsiElement sourceElement;
        if (parent == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (currentType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (currentType instanceof JSWidenType) {
            currentType = ((JSWidenType)currentType).getOriginalType();
        }
        return currentType instanceof JSCodeBasedType && (parent == (sourceElement = currentType.getSourceElement()) || sourceElement instanceof JSVariable && ((JSVariable)sourceElement).getInitializer() == parent);
    }

    private static boolean addExpectedObjectPropertyType(@Nullable JSType parentExpectedType, @NotNull String name, @NotNull List<JSType> allTypes) {
        if (name == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (allTypes == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(11);
        }
        return parentExpectedType != null && ExpectedTypeEvaluator.addFromRecordType(name, allTypes, parentExpectedType);
    }

    private static boolean addFromRecordType(@NotNull String name, @NotNull List<JSType> allTypes, @NotNull JSType jsType) {
        JSRecordType recordType;
        JSRecordType.PropertySignature propertySignature;
        if (name == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (allTypes == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(13);
        }
        if (jsType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(14);
        }
        if ((propertySignature = (recordType = jsType.asRecordType()).findPropertySignature(name)) != null) {
            ContainerUtil.addIfNotNull(allTypes, (Object)propertySignature.getJSType());
            return true;
        }
        JSRecordType.IndexSignature indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        if (indexer != null) {
            ContainerUtil.addIfNotNull(allTypes, (Object)indexer.getMemberType());
            return true;
        }
        return false;
    }

    public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
        long index;
        JSType result2;
        if (!(this.myParent instanceof JSExpression)) {
            return;
        }
        JSType arrayType = ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind);
        if (arrayType != null && (result2 = ExpectedTypeEvaluator.getArrayElementTypeForIndex(arrayType, index = (long)node.indexOf((JSExpression)this.myParent), JSTypeSourceFactory.createTypeSource((PsiElement)node, true))) != null) {
            this.setResult(result2);
        }
        if (this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED && !TypeScriptTypeRelations.isTypeOrUnionOf(arrayType, JSTupleType.class)) {
            ArrayList<JSType> allItemTypes = new ArrayList<JSType>();
            boolean found = false;
            for (JSExpression expr : StreamEx.of((Stream)node.getExpressionStream())) {
                if (expr == null) continue;
                if (expr == this.myParent) {
                    found = true;
                    continue;
                }
                JSType expressionType = JSResolveUtil.getExpressionJSType(expr);
                if (expressionType == null) continue;
                allItemTypes.add(expressionType);
            }
            if (!found) {
                return;
            }
            this.assignFromParentOrOtherSide(this.getResult(), null, allItemTypes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static JSType getArrayElementTypeForIndex(@NotNull JSType arrayType, long index, @NotNull JSTypeSource jSTypeSource) {
        if (arrayType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (jSTypeSource == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (JSTypeUtils.isSingleTypeAlias(arrayType)) {
            arrayType = arrayType.substitute();
        }
        if (arrayType instanceof JSUnionOrIntersectionType) {
            List<JSType> components = ((JSUnionOrIntersectionType)arrayType).getTypes();
            ArrayList<JSType> arrayTypes = new ArrayList<JSType>(components.size());
            for (JSType type : components) {
                JSType partType = ExpectedTypeEvaluator.assignFromArray(type, index);
                if (partType == null) continue;
                arrayTypes.add(partType instanceof JSSpreadType ? ((JSSpreadType)partType).getComponentType() : partType);
            }
            if (!arrayTypes.isEmpty()) {
                void typeSource;
                return JSCompositeTypeFactory.createUnionType((JSTypeSource)typeSource, arrayTypes);
            }
            return null;
        }
        return ExpectedTypeEvaluator.assignFromArray(arrayType, index);
    }

    @Nullable
    private static JSType assignFromArray(@NotNull JSType arrayType, long index) {
        if (arrayType == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (arrayType instanceof JSGenericTypeImpl) {
            arrayType = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(arrayType);
        }
        if (index >= 0L && arrayType.isTypeScript() && !(arrayType instanceof JSUtilType)) {
            JSRecordType type = arrayType.asRecordType();
            JSRecordType.PropertySignature propertySignature = type.findPropertySignature(String.valueOf(index));
            if (propertySignature != null) {
                return propertySignature.getJSType();
            }
            if (arrayType instanceof JSTupleType) {
                return null;
            }
            JSRecordType.IndexSignature indexer = type.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (indexer != null) {
                return indexer.getMemberType();
            }
        }
        return JSTypeUtils.getIterableComponentType(arrayType);
    }

    public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
        this.setResult(ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind));
    }

    public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
        TypeScriptType type = node.getType();
        if (type != null) {
            if (!node.isConstCast()) {
                this.setResult(type.getJSType());
            } else {
                this.setResult(ExpectedTypeEvaluator.findExpectedTypeWithNewEvaluator((JSExpression)node, this.myExpectedTypeKind));
            }
        }
    }

    public void visitJSStringTemplateExpression(JSStringTemplateExpression node) {
        int argumentIndex = ArrayUtil.find((Object[])node.getArguments(), (Object)this.myParent);
        if (argumentIndex < 0) {
            return;
        }
        ES6TaggedTemplateExpression taggedTemplateExpression = (ES6TaggedTemplateExpression)ObjectUtils.tryCast((Object)node.getParent(), ES6TaggedTemplateExpression.class);
        if (taggedTemplateExpression == null) {
            return;
        }
        this.handleFunctionCall((JSCallLikeExpression)taggedTemplateExpression, argumentIndex + node.getFirstArgumentIndex());
    }

    public void visitJSArgumentList(@NotNull JSArgumentList node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(18);
        }
        int paramIndex = ExpectedTypeEvaluator.getParameterIndexInArgumentList(node, this.myParent);
        PsiElement firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        this.handleFunctionCall((JSCallLikeExpression)originalElement, paramIndex);
    }

    public static int getParameterIndexInArgumentList(@Nullable JSArgumentList node, PsiElement expression) {
        if (node == null) {
            return 0;
        }
        int _paramIndex = 0;
        for (JSExpression expr : node.getArguments()) {
            if (expr == expression) break;
            ++_paramIndex;
        }
        return _paramIndex;
    }

    private void handleFunctionCall(@NotNull JSCallLikeExpression callLikeExpression, int paramIndex) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(19);
        }
        this.setResult(new JSFunctionParameterExpectedTypeImpl(callLikeExpression, paramIndex, this.myExpectedTypeKind));
    }

    public static JSType handleFunctionCallType(@NotNull JSCallLikeExpression callLikeExpression, int paramIndex, JSExpectedTypeKind expectedTypeKind) {
        JSExpression methodExpression;
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(20);
        }
        if (!((methodExpression = callLikeExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return ExpectedTypeEvaluator.evaluateParamFromExpressionType(JSResolveUtil.getExpressionJSType(methodExpression), paramIndex, (PsiElement)methodExpression);
        }
        ResolveResult[] results = ExpectedTypeEvaluator.resolveFunctionCall(callLikeExpression, (JSReferenceExpression)methodExpression, expectedTypeKind);
        results = TypeScriptImplicitOverloadedAliasElement.unwrapElements(results);
        ArrayList<JSTypeWithSignature> possibleResults = new ArrayList<JSTypeWithSignature>();
        for (ResolveResult r : results) {
            PsiElement element = r.getElement();
            if (element == null || !element.isValid()) continue;
            if (element instanceof JSParameter) {
                JSType index;
                JSType definedParameterType = ((JSParameter)element).getJSType();
                JSEvaluateContext context = new JSEvaluateContext(null);
                JSType type = definedParameterType != null ? definedParameterType : JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)element), context, expectedTypeKind);
                type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
                if (!context.isJSElementsToApplyEmpty() || !(type instanceof JSFunctionTypeImpl) || (index = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type, paramIndex)) == null) continue;
                possibleResults.add(new JSTypeWithSignature(index));
                continue;
            }
            List<JSFunctionWithSubstitutor> functionsWithSubstitutor = ExpectedTypeEvaluator.calcFunctions(callLikeExpression, methodExpression, element, expectedTypeKind);
            if (functionsWithSubstitutor.size() == 0) continue;
            for (JSFunctionWithSubstitutor functionWithSubstitutor : functionsWithSubstitutor) {
                JSType methodType;
                JSFunctionType functionType;
                JSType type;
                JSFunctionItem matchedFunction = functionWithSubstitutor.myFunctionItem;
                JSTypeSubstitutor typeSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
                if (typeSubstitutor.isEmpty()) {
                    ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, possibleResults);
                    continue;
                }
                if (!(matchedFunction instanceof JSFunction) || !((type = JSTypeUtils.applyGenericArguments((JSType)(functionType = TypeScriptTypeParser.buildFunctionType(matchedFunction)), typeSubstitutor)) instanceof JSFunctionTypeImpl)) continue;
                boolean addedNonGenericTypes = false;
                if (JSTypeUtils.hasForeignGenericParameter(type) && (methodType = JSResolveUtil.getExpressionJSType(callLikeExpression.getMethodExpression())) != null) {
                    JSRecordType recordType = methodType.asRecordType();
                    for (JSRecordType.CallSignature signature : recordType.getCallSignatures()) {
                        addedNonGenericTypes = true;
                        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (JSFunctionTypeImpl)signature.getFunctionType(), possibleResults);
                    }
                }
                if (addedNonGenericTypes) continue;
                ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, (JSFunctionTypeImpl)type, possibleResults);
            }
        }
        if (!possibleResults.isEmpty()) {
            if (possibleResults.size() == 1) {
                JSType type;
                JSParameterItem lastParam;
                JSParameterItem[] parameters;
                JSTypeWithSignature signature = (JSTypeWithSignature)possibleResults.get(0);
                JSType result2 = signature.evaluateGenerics((JSCallItem)callLikeExpression, paramIndex, expectedTypeKind);
                if (!ExpectedTypeEvaluator.hasStrictQualifierType(methodExpression)) {
                    result2 = JSTypeUtils.copyWithStrict(result2, false);
                }
                JSFunctionItem function2 = signature.getFunction();
                if (expectedTypeKind == JSExpectedTypeKind.EXPECTED && function2 != null && paramIndex == (parameters = function2.getParameters()).length - 1 && (lastParam = parameters[paramIndex]).isRest() && (type = JSTypeUtils.getIterableComponentType(result2)) != null) {
                    result2 = JSCompositeTypeFactory.createContextualUnionType(Arrays.asList(result2, type), JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true));
                }
                return result2;
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)callLikeExpression, true);
            TypeScriptOverloadContextualType contextualType = new TypeScriptOverloadContextualType(source, possibleResults, paramIndex, (JSCallItem)callLikeExpression);
            return expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS || expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER ? contextualType : contextualType.asCompositeWithAppliedGenerics(expectedTypeKind);
        }
        ArrayList<JSType> types2 = new ArrayList<JSType>(results.length);
        for (ResolveResult result3 : results) {
            JSType paramType = ExpectedTypeEvaluator.evaluateParamFromExpressionType(JSTypeUtils.getTypeOfElement(result3.getElement()), paramIndex, (PsiElement)methodExpression);
            if (paramType == null) continue;
            types2.add(paramType);
        }
        return JSCompositeTypeFactory.createContextualUnionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)methodExpression, ExpectedTypeEvaluator.hasStrictQualifierType(methodExpression)));
    }

    private static ResolveResult @NotNull [] resolveFunctionCall(@NotNull JSCallLikeExpression callLikeExpression, @NotNull JSReferenceExpression methodExpression, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(21);
        }
        if (methodExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(22);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (DialectDetector.isActionScript((PsiElement)callLikeExpression)) {
            ResolveResult[] resolveResultArray = methodExpression.multiResolve(false);
            if (resolveResultArray == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(24);
            }
            return resolveResultArray;
        }
        if (expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER) {
            ResolveResult[] results = methodExpression.multiResolve(true);
            if (results.length <= 1 || !JSResolveUtil.isResolveStrict((PsiReference)methodExpression, results)) {
                if (results == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(25);
                }
                return results;
            }
            ResolveResult[] resolveResultArray = new JSTypeSignatureChooser((JSCallItem)callLikeExpression).chooseOverload(results, OverloadStrictness.NO_INFERRED_RETURN_TYPE_CHECK);
            if (resolveResultArray == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(26);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = methodExpression.multiResolve(expectedTypeKind == JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS || expectedTypeKind.isInferenceDepthExceeded());
        if (resolveResultArray == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(27);
        }
        return resolveResultArray;
    }

    @Nullable
    private static JSType evaluateParamFromExpressionType(@Nullable JSType type, int paramIndex, @Nullable PsiElement expression) {
        Stream<JSType> functionTypes = JSTypeUtils.getFunctionType(type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type), expression instanceof JSSuperExpression || expression != null && expression.getParent() instanceof JSNewExpression, expression);
        List list2 = functionTypes.collect(Collectors.toList());
        if (list2.size() != 1) {
            return null;
        }
        type = (JSType)ContainerUtil.getFirstItem(list2);
        if (!(type instanceof JSFunctionType)) {
            return null;
        }
        List parameters = ((JSFunctionType)type).getParameters();
        if (paramIndex >= 0 && paramIndex < parameters.size()) {
            JSParameterTypeDecorator matchingParam = (JSParameterTypeDecorator)parameters.get(paramIndex);
            return matchingParam.getSimpleType();
        }
        return null;
    }

    public void visitJSVariable(JSVariable node) {
        JSType type = ExpectedTypeEvaluator.getExplicitlyDeclaredType(node);
        if (type != null) {
            this.setResult(type);
        }
    }

    @Nullable
    private static JSType getExplicitlyDeclaredType(@NotNull JSVariable node) {
        if (node == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(28);
        }
        if (node.getTypeElement() != null) {
            return node.getJSType();
        }
        if (DialectDetector.isTypeScript((PsiElement)node)) {
            return null;
        }
        JSType type = node.getJSType();
        if (type == null) {
            return null;
        }
        return node instanceof JSVariableBaseImpl ? ((JSVariableBaseImpl)node).doGetExplicitlyDeclaredType() : type;
    }

    public void visitJSDestructuringElement(JSDestructuringElement node) {
        if (!DialectDetector.isTypeScript((PsiElement)node) || node.getTypeElement() != null) {
            this.setResult(node.getJSType());
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand != null) {
            JSType expressionType;
            if ((lOperand = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)lOperand)) instanceof JSDefinitionExpression) {
                PsiElement resolve;
                JSType type;
                if (!DialectDetector.isTypeScript((PsiElement)node) && (type = ((JSDefinitionExpression)lOperand).getTypeFromComment()) != null) {
                    this.setResult(type);
                    return;
                }
                JSExpression expression = ((JSDefinitionExpression)lOperand).getExpression();
                if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve)) {
                    return;
                }
            }
            if ((expressionType = JSResolveUtil.getExpressionJSType(lOperand)) instanceof JSLiteralType && JSTokenTypes.ASSIGNMENT_MODIFYING_OPERATIONS.contains(node.getOperationSign())) {
                expressionType = ((JSLiteralType)expressionType).asPrimitiveType();
            }
            this.setResult(expressionType);
        }
    }

    protected void findRestParameterExpectedType(JSParameterItem param) {
        this.setResult(this.createNamedType("Object", this.myParent));
    }

    protected JSType createNamedType(String name, PsiElement context) {
        return JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSContext.INSTANCE);
    }

    private static boolean hasStrictQualifierType(JSExpression methodExpr) {
        JSType expressionType;
        JSExpression qualifier;
        if (methodExpr instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)methodExpr) && (qualifier = ((JSReferenceExpression)methodExpr).getQualifier()) != null && (expressionType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            return TypeScriptUtil.isStrictType(expressionType);
        }
        return true;
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(29);
        }
        if (matchedFunction == null) {
            return;
        }
        JSParameterItem[] params = matchedFunction.getParameters();
        if (params.length == 0) {
            return;
        }
        ArrayList<JSType> parameterTypes = new ArrayList<JSType>(params.length);
        for (JSParameterItem item : params) {
            parameterTypes.add(item.getSimpleType());
        }
        boolean isLastRest = params[params.length - 1].isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @Nullable JSFunctionTypeImpl matchedFunctionType, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(30);
        }
        if (matchedFunctionType == null) {
            return;
        }
        List<JSParameterTypeDecorator> parameters = matchedFunctionType.getParameters();
        if (parameters.isEmpty()) {
            return;
        }
        List parameterTypes = ContainerUtil.map(parameters, JSParameterItem::getSimpleType);
        boolean isLastRest = parameters.get(parameters.size() - 1).isRest();
        ExpectedTypeEvaluator.addPossibleTypes(paramIndex, matchedFunction, parameterTypes, isLastRest, possibleResults);
    }

    private static void addPossibleTypes(int paramIndex, @Nullable JSFunctionItem matchedFunction, @NotNull List<JSType> params, boolean isLastRest, @NotNull List<JSTypeWithSignature> possibleResults) {
        if (params == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(31);
        }
        if (possibleResults == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(32);
        }
        JSType param = null;
        if (paramIndex < params.size()) {
            param = params.get(paramIndex);
        } else if (params.size() > 0 && isLastRest) {
            param = (JSType)ContainerUtil.getLastItem(params);
        }
        if (param != null) {
            possibleResults.add(new JSTypeWithSignature(param, matchedFunction));
        }
    }

    @NotNull
    protected static List<JSFunctionWithSubstitutor> calcFunctions(@NotNull JSCallLikeExpression callLikeExpression, @NotNull JSExpression methodExpression, @NotNull PsiElement resolvedElement, @NotNull JSExpectedTypeKind expectedTypeKind) {
        Collection<JSFunctionWithSubstitutor> functions;
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(33);
        }
        if (methodExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(34);
        }
        if (resolvedElement == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((functions = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(resolvedElement, (PsiElement)methodExpression, !DialectDetector.isTypeScript(resolvedElement))).size() == 0) {
            List<JSFunctionWithSubstitutor> list2 = Collections.emptyList();
            if (list2 == null) {
                ExpectedTypeEvaluator.$$$reportNull$$$0(37);
            }
            return list2;
        }
        if (expectedTypeKind == JSExpectedTypeKind.EXPECTED && functions.size() == 1) {
            JSFunctionItem functionItem;
            JSFunctionWithSubstitutor overload = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functions);
            JSFunctionItem jSFunctionItem = functionItem = overload == null ? null : overload.myFunctionItem;
            if (functionItem instanceof TypeScriptFunction) {
                ArrayList<JSFunctionWithSubstitutor> overloads = new ArrayList<JSFunctionWithSubstitutor>();
                for (JSFunctionItem jSFunctionItem2 : TypeScriptPsiUtil.getAllOverloadSignatures(functionItem)) {
                    overloads.add(new JSFunctionWithSubstitutor(jSFunctionItem2, overload.myTypeSubstitutor));
                }
                ArrayList<JSFunctionWithSubstitutor> arrayList = overloads;
                if (arrayList == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(38);
                }
                return arrayList;
            }
        }
        if (functions.size() == 1) {
            return new SmartList(functions);
        }
        return ExpectedTypeEvaluator.chooseOverload(callLikeExpression, functions, expectedTypeKind);
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> chooseOverload(@NotNull JSCallLikeExpression callLikeExpression, @NotNull Collection<JSFunctionWithSubstitutor> functions, @NotNull JSExpectedTypeKind expectedTypeKind) {
        if (callLikeExpression == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (functions == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(40);
        }
        if (expectedTypeKind == null) {
            ExpectedTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (expectedTypeKind.isContextual()) {
            List collect = ContainerUtil.map(functions, el -> el.myFunctionItem);
            if (expectedTypeKind != JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS && expectedTypeKind != JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER) {
                JSFunctionItem item = TypeScriptSignatureChooser.resolveOverloads(callLikeExpression, collect);
                if (item != null) {
                    List list2 = ContainerUtil.filter(functions, el -> item.equals(el.myFunctionItem));
                    if (list2 == null) {
                        ExpectedTypeEvaluator.$$$reportNull$$$0(42);
                    }
                    return list2;
                }
            } else {
                List<JSFunctionItem> items = new JSTypeSignatureChooser((JSCallItem)callLikeExpression).chooseOverloadFunctions(collect, OverloadStrictness.NO_RESOLVE);
                HashMap<JSFunctionItem, JSFunctionWithSubstitutor> map = new HashMap<JSFunctionItem, JSFunctionWithSubstitutor>(functions.size());
                for (JSFunctionWithSubstitutor function2 : functions) {
                    map.put(function2.myFunctionItem, function2);
                }
                List list3 = ContainerUtil.mapNotNull(items, map::get);
                if (list3 == null) {
                    ExpectedTypeEvaluator.$$$reportNull$$$0(43);
                }
                return list3;
            }
        }
        return new SmartList(functions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 23: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyForExpectedType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExpectedType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctionCall";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFunctions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseOverload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExpectedTypeWithNewEvaluator";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromFunctionExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasElementInSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedObjectPropertyType";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFromRecordType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeForIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "assignFromArray";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitJSArgumentList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleFunctionCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handleFunctionCallType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionCall";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlyDeclaredType";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleTypes";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calcFunctions";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 38: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

