/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class JSResolveReferencesCommandBase
extends AbstractCommand {
    @NotNull
    protected final Project myProject;

    public JSResolveReferencesCommandBase(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        VirtualFile root;
        if (context == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(2);
        }
        if ((root = ProjectUtil.guessProjectDir((Project)this.myProject)) == null) {
            return Promises.rejectedPromise((String)"Can't find project root");
        }
        List futures = (List)ReadAction.compute(() -> {
            final int numberOfTasks = Math.max(1, JobSchedulerImpl.getJobPoolParallelism());
            final List filesToProcess = Stream.generate(ArrayList::new).limit(numberOfTasks).collect(Collectors.toList());
            final AtomicInteger taskIndex = new AtomicInteger(0);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2.equals(root)) {
                        return true;
                    }
                    if (!ProjectFileIndex.getInstance((Project)JSResolveReferencesCommandBase.this.myProject).isInContent(file2) || ProjectFileIndex.getInstance((Project)JSResolveReferencesCommandBase.this.myProject).isInLibrary(file2)) {
                        return false;
                    }
                    if (JavaScriptIndex.isAcceptableFile(file2)) {
                        ((List)filesToProcess.get(taskIndex.getAndUpdate(i -> (i + 1) % numberOfTasks))).add(file2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase$1", "visitFile"));
                }
            });
            return ContainerUtil.map(filesToProcess, files -> ApplicationManager.getApplication().executeOnPooledThread((Runnable)new JSResolveReferencesTask((List)files, root, context)));
        });
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                return Promises.rejectedPromise((Throwable)e);
            }
        }
        return Promises.resolvedPromise();
    }

    protected abstract ResolveResult @NotNull [] getResolveResults(@NotNull JSReferenceExpression var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "_execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class JSResolveReferencesTask
    implements Runnable {
        @NotNull
        private final List<VirtualFile> myFiles;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final PlaybackContext myContext;

        private JSResolveReferencesTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, PlaybackContext context) {
            if (files == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(1);
            }
            if (context == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(2);
            }
            this.myFiles = files;
            this.myRoot = root;
            this.myContext = context;
        }

        @Override
        public void run() {
            ReadAction.run(() -> {
                for (VirtualFile file2 : this.myFiles) {
                    Document document2;
                    PsiFile psiFile;
                    final String path = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myRoot, (char)'/');
                    if (path == null || (psiFile = PsiManager.getInstance((Project)JSResolveReferencesCommandBase.this.myProject).findFile(file2)) == null || (document2 = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
                    new JSRecursiveWalkingElementVisitor(){

                        public void visitJSReferenceExpression(JSReferenceExpression node) {
                            if (!this.isAcceptableReference(node)) {
                                super.visitJSReferenceExpression(node);
                                return;
                            }
                            ResolveResult[] results = JSResolveReferencesCommandBase.this.getResolveResults(node);
                            int offset = node.getTextRange().getStartOffset() + node.getRangeInElement().getStartOffset();
                            int lineNumber = document2.getLineNumber(offset);
                            int offsetInLine = offset - document2.getLineStartOffset(lineNumber);
                            String result2 = JSResolveResult.isTooManyCandidatesResult(results) ? "too many candidates" : (Arrays.stream(results).noneMatch(ResolveResult::isValidResult) ? "unresolved" : (results.length > 1 ? "several results (" + results.length + ")" : JSResolveReferencesTask.this.formatUniqueValidResult(results[0].getElement())));
                            String message = String.format("jsref: %s:%d:%d %s -> %s", path, lineNumber, offsetInLine, node.getReferenceName(), result2);
                            JSResolveReferencesTask.this.myContext.message(message, -1);
                            super.visitJSReferenceExpression(node);
                        }

                        private boolean isAcceptableReference(JSReferenceExpression node) {
                            return node.getClass().equals(JSReferenceExpressionImpl.class) && !JSResolveUtil.isSelfReference((PsiElement)node);
                        }
                    }.visitElement((PsiElement)psiFile);
                }
            });
        }

        private String formatUniqueValidResult(PsiElement element) {
            if (element == null) {
                return "null";
            }
            VirtualFile resolveFile = element.getContainingFile().getVirtualFile();
            if (resolveFile == null) {
                return "null";
            }
            Document resolveDocument = FileDocumentManager.getInstance().getDocument(resolveFile);
            if (resolveDocument == null) {
                return "null";
            }
            int offset = element.getTextOffset();
            int lineNumber = resolveDocument.getLineNumber(offset);
            int offsetInLine = offset - resolveDocument.getLineStartOffset(lineNumber);
            return String.format("%s:%d:%d", VfsUtilCore.getRelativePath((VirtualFile)resolveFile, (VirtualFile)this.myRoot, (char)'/'), lineNumber, offsetInLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase$JSResolveReferencesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

