/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.node;

import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportNodeJsModuleFix
extends ImportCommonJSModuleFix {
    @NotNull
    private final NotNullLazyValue<String> myText;

    public ImportNodeJsModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, @Nullable JSPlaceTail tail, @NotNull String quoteString) {
        if (node == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(1);
        }
        if (quoteString == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(2);
        }
        super(node, descriptor2, tail, quoteString);
        this.myText = NotNullLazyValue.createValue(() -> {
            PsiElement element = this.getStartElement();
            if (element == null || !element.isValid()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            String wholeImportWrapQuote = "'".equals(this.myQuotes) ? "\"" : "'";
            builder.append("Insert ").append(wholeImportWrapQuote).append(this.getStatementRequireCallText()).append(wholeImportWrapQuote);
            return builder.toString();
        });
    }

    @Override
    protected void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(3);
        }
        if (created == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(4);
        }
        ES6ImportPsiUtil.findPlaceAndInsertRequire(scope, created, editor);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = (String)this.myText.getValue();
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"node.js.modules.dependencies.missing.family.name", (Object[])new Object[0]);
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private String getPostfix() {
        String postfix = "";
        if (this.myFixDescriptor.getExportedName() != null) {
            postfix = "." + this.myFixDescriptor.getExportedName();
        }
        if (this.myTail != null) {
            postfix = postfix + "." + StringUtil.join((String[])this.myTail.getStrings(), (String)".");
        }
        String string = postfix;
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean isFileImport() {
        return this.myTail == null && !this.myFixDescriptor.isModuleElementIsMissing() && (this.myFixDescriptor.getExportedName() == null || this.myFixDescriptor.getExportedName().equals(this.myFixDescriptor.getImportedName()));
    }

    @Override
    protected PsiElement createRequire(@NotNull PsiElement context) {
        if (context == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(8);
        }
        String text = this.getStatementRequireCallText();
        PsiFile file2 = ImportNodeJsModuleFix.createDummyFile(context.getProject(), text);
        return file2.getFirstChild();
    }

    @NotNull
    private String getStatementRequireCallText() {
        String semicolon;
        String varName = this.myTail != null ? this.myTail.getLast() : this.myFixDescriptor.getImportedName();
        PsiElement element = this.getStartElement();
        boolean isES6 = element != null && ES6CoolRefactoring.isEs6Compatible(element);
        boolean isFileImport = this.isFileImport();
        String firstWord = this.myFixDescriptor.getExportedName();
        boolean isDestructuring = isES6 && !isFileImport && this.myTail == null && firstWord != null;
        String prefix = isES6 ? "const " : "var ";
        String call = "require(" + this.myQuotes + this.getPath() + this.myQuotes + ")";
        String string = semicolon = element != null ? JSCodeStyleSettings.getSemicolon(element) : ";";
        if (isDestructuring) {
            String spaces = JSCodeStyleSettings.getSettings((PsiElement)element).SPACES_WITHIN_OBJECT_LITERAL_BRACES ? " " : "";
            String string2 = prefix + "{" + spaces + varName + spaces + "} = " + call + semicolon;
            if (string2 == null) {
                ImportNodeJsModuleFix.$$$reportNull$$$0(9);
            }
            return string2;
        }
        String postfix = isFileImport ? "" : this.getPostfix();
        String string3 = prefix + varName + " = " + call + postfix + semicolon;
        if (string3 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(10);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostfix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementRequireCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertCreatedElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRequire";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

