/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayVariableMacro
extends Macro {
    public String getName() {
        return "jsArrayVariable";
    }

    public String getPresentableName() {
        return JavaScriptBundle.message((String)"macro.js.array.variable", (Object[])new Object[0]);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        String property;
        if (params == null) {
            JSArrayVariableMacro.$$$reportNull$$$0(0);
        }
        if ((property = (String)context.getProperty(ExpressionContext.SELECTION)) != null) {
            return null;
        }
        PsiNamedElement[] vars = JSArrayVariableMacro.getVariables(params, context);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        for (PsiNamedElement element : vars) {
            JSType type;
            LookupElementBuilder lookupElement = LookupElementBuilder.create((PsiNamedElement)element).withIcon(element.getIcon(1));
            if (element instanceof JSVariable && !((type = ((JSVariable)element).getJSType()) instanceof JSCodeBasedType) && type != null) {
                lookupElement = lookupElement.withTypeText(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            }
            set.add(lookupElement);
        }
        return set.toArray(LookupElement.EMPTY_ARRAY);
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        String property;
        if (params == null) {
            JSArrayVariableMacro.$$$reportNull$$$0(1);
        }
        if ((property = (String)context.getProperty(ExpressionContext.SELECTION)) != null) {
            return new TextResult(property);
        }
        PsiNamedElement[] vars = JSArrayVariableMacro.getVariables(params, context);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new PsiElementResult((PsiElement)vars[0]){

            @Nullable
            public String toString() {
                PsiElement element = this.getElement();
                if (element instanceof JSNamedElement) {
                    return ((JSNamedElement)element).getName();
                }
                return super.toString();
            }
        };
    }

    private static PsiNamedElement @Nullable [] getVariables(Expression[] params, ExpressionContext context) {
        if (params.length != 0) {
            return null;
        }
        ArrayList<JSNamedElement> vars = new ArrayList<JSNamedElement>();
        JSNamedElement[] allVars = JSMacroUtil.getNamedElementsVisibleAt(context);
        Project project = context.getProject();
        for (JSNamedElement var : allVars) {
            String name;
            JSType type;
            if (!(var instanceof JSVariable) && (!(var instanceof JSFunction) || ((JSFunction)var).getKind() != JSFunction.FunctionKind.GETTER)) continue;
            JSType jSType = type = var instanceof JSVariable ? ((JSVariable)var).getJSType() : ((JSFunction)var).getReturnType();
            if (type instanceof JSNumberType || type instanceof JSIntType || type instanceof JSUintType || type instanceof JSBooleanType || (name = var.getName()) == null || !JSRefactoringUtil.isValidIdentifier(name, project)) continue;
            vars.add(var);
        }
        return (PsiNamedElement[])vars.toArray(new JSNamedElement[0]);
    }

    @Nullable
    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context) {
        String property;
        if (params == null) {
            JSArrayVariableMacro.$$$reportNull$$$0(2);
        }
        if ((property = (String)context.getProperty(ExpressionContext.SELECTION)) != null) {
            return new TextResult(property);
        }
        return super.calculateQuickResult(params, context);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return JSMacroUtil.isJSLikeContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/lang/javascript/macro/JSArrayVariableMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

