/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LinterSaveActionsManager
implements FileDocumentManagerListener {
    private static final ExtensionPointName<LinterSaveAction> EP_NAME = ExtensionPointName.create((String)"JavaScript.linterSaveAction");
    private final Set<Document> myDocumentsToProcess = new THashSet();

    public void beforeAllDocumentsSaving() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (LinterSaveAction saveAction : EP_NAME.getExtensionList()) {
                if (!saveAction.isEnabledForProject(project)) continue;
                this.scheduleDocumentsProcessing(FileDocumentManager.getInstance().getUnsavedDocuments());
                return;
            }
        }
    }

    private void scheduleDocumentsProcessing(Document[] documents) {
        boolean processingAlreadyScheduled = !this.myDocumentsToProcess.isEmpty();
        this.myDocumentsToProcess.addAll(Arrays.asList(documents));
        if (!processingAlreadyScheduled) {
            ApplicationManager.getApplication().invokeLater(() -> this.processSavedDocuments(), ModalityState.NON_MODAL);
        }
    }

    private void processSavedDocuments() {
        Document[] documents = this.myDocumentsToProcess.toArray(Document.EMPTY_ARRAY);
        this.myDocumentsToProcess.clear();
        if (ModalityState.current() != ModalityState.NON_MODAL) {
            return;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (LinterSaveAction saveAction : EP_NAME.getExtensionList()) {
                if (!saveAction.isEnabledForProject(project)) continue;
                saveAction.processDocuments(project, documents);
            }
        }
        FileDocumentManager manager2 = FileDocumentManager.getInstance();
        for (Document document2 : documents) {
            manager2.saveDocument(document2);
        }
    }

    public static abstract class LinterSaveAction {
        public boolean isEnabledForProject(@NotNull Project project) {
            if (project == null) {
                LinterSaveAction.$$$reportNull$$$0(0);
            }
            return false;
        }

        public void processDocuments(@NotNull Project project, @NotNull @NotNull Document @NotNull [] documents) {
            if (project == null) {
                LinterSaveAction.$$$reportNull$$$0(1);
            }
            if (documents == null) {
                LinterSaveAction.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documents";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/LinterSaveActionsManager$LinterSaveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForProject";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDocuments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

