/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSLinterEditorNotificationPanel {
    @NotNull
    private final Project myProject;
    private final Class<? extends JSLinterInspection> myInspectionClass;

    JSLinterEditorNotificationPanel(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> inspectionClass) {
        if (project == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(0);
        }
        if (inspectionClass == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myInspectionClass = inspectionClass;
    }

    @Nullable
    EditorNotificationPanel createNotificationPanel(@NotNull JSLinterFileLevelAnnotation annotation) {
        List<IntentionAction> fixes;
        if (annotation == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(2);
        }
        if (!JSLinterInspection.isToolEnabled(this.myProject, this.myInspectionClass, null)) {
            return null;
        }
        String message = annotation.getShortMessage();
        if (message == null) {
            List strings = Arrays.stream(StringUtil.splitByLines((String)annotation.getMessage())).filter(s -> !StringUtil.isEmptyOrSpaces((String)s)).collect(Collectors.toList());
            message = strings.isEmpty() ? annotation.getMessage() : (String)strings.get(0);
        }
        message = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
        String tooltip = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)annotation.getMessage()).replace("\n", "<br/>"));
        Color backgroundColor = HighlightSeverity.ERROR.equals((Object)annotation.getSeverity()) ? LightColors.RED : LightColors.YELLOW;
        EditorNotificationPanel panel2 = new EditorNotificationPanel(backgroundColor);
        panel2.setText(message);
        Icon icon = annotation.getIcon();
        if (icon != null) {
            panel2.icon(icon);
        }
        if ((fixes = annotation.getFixes().getOtherFixes()) != null) {
            for (IntentionAction fix : fixes) {
                if (!fix.isAvailable(this.myProject, null, null)) continue;
                panel2.createActionLabel(fix.getText(), () -> {
                    if (fix.isAvailable(this.myProject, null, null)) {
                        fix.invoke(this.myProject, null, null);
                    }
                });
            }
        }
        panel2.setToolTipText(tooltip);
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterEditorNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNotificationPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

