/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSConstructorReturnsPrimitiveInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSConstructorReturnsPrimitiveInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSConstructorReturnsPrimitiveInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction function2) {
                if (this.shouldSkip(function2)) {
                    return;
                }
                this.validateReturns(function2);
            }

            public void visitJSFunctionExpression(JSFunctionExpression function2) {
                if (function2.isArrowFunction() || this.shouldSkip((JSFunction)function2)) {
                    return;
                }
                this.validateReturns((JSFunction)function2);
            }

            private void validateReturns(JSFunction function2) {
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function2).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSReturnStatement.class).forEach(node -> {
                    JSExpression expression = node.getExpression();
                    JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getElementJSType((PsiElement)expression, false));
                    if (type instanceof JSPrimitiveType && ((JSPrimitiveType)type).isPrimitive() || type instanceof JSNullType || type instanceof JSUndefinedType) {
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.constructor.returns.primitive.inspection.problem", (Object[])new Object[0]), new LocalQuickFix[]{new SetJSDocReturnTypeFix(type.getTypeText(JSType.TypeTextFormat.CODE))});
                    }
                });
            }

            private boolean shouldSkip(JSFunction function2) {
                DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)function2);
                if (dialect != null && !dialect.isJavaScript()) {
                    return true;
                }
                if (JSClassUtils.isClassMember((PsiElement)function2) && !function2.isConstructor()) {
                    return true;
                }
                if (function2.isGetProperty()) {
                    return true;
                }
                String name = function2.getName();
                if (!JSSymbolUtil.isDefinitelyConstructor((PsiElement)function2) && !JSSymbolUtil.isConstructorName(name)) {
                    return true;
                }
                return function2.hasExplicitlyDeclaredReturnType();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SetJSDocReturnTypeFix
    implements LocalQuickFix {
        private final String myType;

        private SetJSDocReturnTypeFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.constructor.returns.primitive.inspection.quickfix", (Object[])new Object[]{this.myType});
            if (string == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            JSFunction function2;
            if (project == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                SetJSDocReturnTypeFix.$$$reportNull$$$0(2);
            }
            if ((function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), JSFunction.class)) != null) {
                List<String> tagsToCreate = Collections.singletonList("return {" + this.myType + "}");
                JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)function2, tagsToCreate, null, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConstructorReturnsPrimitiveInspection$SetJSDocReturnTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

