/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.TypeScriptIndexerNode;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import icons.JavaScriptPsiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenerateMemberChooser
extends MemberChooser<JSChooserElementNode> {
    private final boolean myAllowEmptySelection;
    @Nullable
    private final JComponent myOptionsComponent;
    @NotNull
    private final Map<MemberKind, Boolean> myMembersShown;
    @NotNull
    private final Collection<? extends JSChooserElementNode> myOriginalCandidates;

    public JSGenerateMemberChooser(@NotNull Collection<? extends JSChooserElementNode> candidates, boolean allowEmptySelection, boolean allowMultipleSelection, @NotNull Project project, @Nullable JComponent optionsComponent) {
        if (candidates == null) {
            JSGenerateMemberChooser.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JSGenerateMemberChooser.$$$reportNull$$$0(1);
        }
        super((ClassMember[])candidates.toArray(JSChooserElementNode.EMPTY_ARRAY), allowEmptySelection, allowMultipleSelection, project, false);
        this.myOriginalCandidates = candidates;
        this.myAllowEmptySelection = allowEmptySelection;
        this.myOptionsComponent = optionsComponent;
        this.myMembersShown = new HashMap<MemberKind, Boolean>();
        this.myMembersShown.put(MemberKind.Field, true);
        this.myMembersShown.put(MemberKind.Method, true);
        this.myMembersShown.put(MemberKind.Indexer, true);
        if (!this.myAllowEmptySelection) {
            this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    JSGenerateMemberChooser.this.setOKActionEnabled(JSGenerateMemberChooser.this.myTree.getSelectionCount() > 0);
                }
            });
        } else {
            this.setOKActionEnabled(true);
        }
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        boolean hasAtLeastTwo;
        super.fillToolbarActions(group);
        boolean hasIndexers = false;
        boolean hasMethods = false;
        boolean hasFields = false;
        for (JSChooserElementNode node : (JSChooserElementNode[])this.myElements) {
            if (node instanceof TypeScriptIndexerNode) {
                hasIndexers = true;
                continue;
            }
            if (!(node instanceof JSNamedElementNode)) continue;
            if (node.getPsiElement() instanceof JSFunctionItem) {
                hasMethods = true;
                continue;
            }
            hasFields = true;
        }
        boolean bl = hasAtLeastTwo = hasMethods && hasFields || hasMethods && hasIndexers || hasFields && hasIndexers;
        if (!hasAtLeastTwo) {
            return;
        }
        group.addSeparator();
        if (hasMethods) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Method));
        }
        if (hasFields) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Field));
        }
        if (hasIndexers) {
            group.add((AnAction)new FilterMembersAction(MemberKind.Indexer));
        }
    }

    protected JComponent createCenterPanel() {
        JComponent superComponent = super.createCenterPanel();
        JComponent optionsComponent = this.myOptionsComponent;
        if (optionsComponent == null) {
            return superComponent;
        }
        if (superComponent == null) {
            return optionsComponent;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)superComponent, "Center");
        panel2.add((Component)optionsComponent, "South");
        return panel2;
    }

    private JSChooserElementNode[] recomputeElements() {
        ArrayList<JSChooserElementNode> items = new ArrayList<JSChooserElementNode>(this.myOriginalCandidates.size());
        for (JSChooserElementNode jSChooserElementNode : this.myOriginalCandidates) {
            if (jSChooserElementNode instanceof TypeScriptIndexerNode) {
                if (!this.myMembersShown.get((Object)MemberKind.Indexer).booleanValue()) continue;
                items.add(jSChooserElementNode);
                continue;
            }
            if (!(jSChooserElementNode instanceof JSNamedElementNode)) continue;
            if (jSChooserElementNode.getPsiElement() instanceof JSFunctionItem) {
                if (!this.myMembersShown.get((Object)MemberKind.Method).booleanValue()) continue;
                items.add(jSChooserElementNode);
                continue;
            }
            if (!this.myMembersShown.get((Object)MemberKind.Field).booleanValue()) continue;
            items.add(jSChooserElementNode);
        }
        return items.toArray(JSChooserElementNode.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "candidates";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/generation/JSGenerateMemberChooser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FilterMembersAction
    extends ToggleAction {
        @NotNull
        private final MemberKind myKind;

        FilterMembersAction(MemberKind kind) {
            if (kind == null) {
                FilterMembersAction.$$$reportNull$$$0(0);
            }
            super(JavaScriptBundle.message((String)"generate.filter.button.tooltip", (Object[])new Object[]{kind.toString()}), JavaScriptBundle.message((String)"generate.filter.button.description", (Object[])new Object[]{kind.toString()}), kind.getIcon());
            this.myKind = kind;
            this.registerCustomShortcutSet(KeyEvent.getExtendedKeyCodeForChar(kind.toString().charAt(0)), 8, (JComponent)JSGenerateMemberChooser.this.myTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterMembersAction.$$$reportNull$$$0(1);
            }
            return (Boolean)JSGenerateMemberChooser.this.myMembersShown.get((Object)this.myKind);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FilterMembersAction.$$$reportNull$$$0(2);
            }
            JSGenerateMemberChooser.this.myMembersShown.put(this.myKind, state);
            JSGenerateMemberChooser.this.resetElements(JSGenerateMemberChooser.this.recomputeElements());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/generation/JSGenerateMemberChooser$FilterMembersAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum MemberKind {
        Indexer,
        Method,
        Field;


        public String toString() {
            switch (this) {
                case Indexer: {
                    return JavaScriptBundle.message((String)"generate.filter.indexers", (Object[])new Object[0]);
                }
                case Method: {
                    return JavaScriptBundle.message((String)"generate.filter.methods", (Object[])new Object[0]);
                }
                case Field: {
                    return JavaScriptBundle.message((String)"generate.filter.fields", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            switch (this) {
                case Indexer: {
                    return JavaScriptPsiIcons.Members.TypeScript_index_signature;
                }
                case Method: {
                    return PlatformIcons.METHOD_ICON;
                }
                case Field: {
                    int w = PlatformIcons.FIELD_ICON.getIconWidth();
                    LayeredIcon icon = new LayeredIcon(2);
                    icon.setIcon(PlatformIcons.PROPERTY_ICON, 0, w / 3, 0);
                    icon.setIcon(PlatformIcons.FIELD_ICON, 1, -w / 3, 0);
                    return icon;
                }
            }
            return null;
        }
    }
}

