/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.codeInsight.hints.presentation.SpacePresentation;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J.\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J0\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0002J\u001e\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J.\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J.\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\u000e\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011J\u000e\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsPresentationFactory;", "", "myFactory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "myFoldingLevel", "", "(Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;I)V", "arrayTypeHint", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "type", "Lcom/intellij/lang/javascript/psi/types/JSArrayType;", "level", "depth", "length", "Lcom/intellij/openapi/util/Ref;", "classTypeHint", "classType", "Lcom/intellij/lang/javascript/psi/JSType;", "compositeTypeHint", "Lcom/intellij/lang/javascript/psi/types/JSUnionOrIntersectionType;", "emptyPresentation", "Lcom/intellij/codeInsight/hints/presentation/SpacePresentation;", "getTypeText", "hint", "originalType", "inlayHintPresentation", "join", "presentations", "", "text", "", "parametersHint", "Lcom/intellij/lang/javascript/psi/types/JSGenericTypeImpl;", "recordTypeHint", "recordType", "Lcom/intellij/lang/javascript/psi/types/JSRecordTypeImpl;", "tupleTypeHint", "Lcom/intellij/lang/javascript/psi/types/JSTupleType;", "typeHint", "typeHintWithColon", "Companion", "intellij.javascript.impl"})
public final class JSTypeHintsPresentationFactory {
    private final PresentationFactory myFactory;
    private final int myFoldingLevel;
    private static final String PLACEHOLDER_MARK = "...";
    private static final int MAX_DEPTH = 10;
    private static final int MAX_LENGTH = 30;
    private static final int MAX_TYPES_IN_COMPOSITE = 2;
    private static final int MAX_PROPERTIES = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final InlayPresentation typeHint(@NotNull JSType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.myFactory.roundWithBackground(this.inlayHintPresentation(type));
    }

    @NotNull
    public final InlayPresentation typeHintWithColon(@NotNull JSType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.myFactory.roundWithBackground(this.myFactory.seq(new InlayPresentation[]{this.myFactory.smallText(": "), this.inlayHintPresentation(type)}));
    }

    private final InlayPresentation inlayHintPresentation(JSType type) {
        Ref length;
        Ref ref = length = Ref.create((Object)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"length");
        InlayPresentation hint = this.hint(type, 0, 0, (Ref<Integer>)ref);
        if (Intrinsics.compare((int)((Number)length.get()).intValue(), (int)30) > 0) {
            return this.myFactory.collapsible((InlayPresentation)this.emptyPresentation(), this.myFactory.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(hint){
                final /* synthetic */ InlayPresentation $hint;

                @NotNull
                public final InlayPresentation invoke() {
                    return this.$hint;
                }
                {
                    this.$hint = inlayPresentation;
                    super(0);
                }
            }, (InlayPresentation)this.emptyPresentation(), true);
        }
        return hint;
    }

    private final InlayPresentation hint(JSType originalType, int level, int depth, Ref<Integer> length) {
        if (depth > 10) {
            return this.myFactory.smallText(PLACEHOLDER_MARK);
        }
        JSType type = originalType instanceof JSEvaluableType ? TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(originalType) : originalType;
        JSType jSType = type = JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE);
        return jSType instanceof JSArrayType ? this.arrayTypeHint((JSArrayType)type, level, depth, length) : (jSType instanceof JSUnionOrIntersectionType ? this.compositeTypeHint((JSUnionOrIntersectionType)type, level, depth, length) : (jSType instanceof JSLiteralType ? (((JSLiteralType)type).allowWidening() && !JSWidenType.isConstContext(((JSLiteralType)type).getSourceElement()) ? this.getTypeText(((JSLiteralType)type).widen(true), length) : this.getTypeText(type, length)) : (jSType instanceof JSTupleType ? this.tupleTypeHint((JSTupleType)type, level, depth, length) : (jSType instanceof JSNamedType ? this.classTypeHint(type, level, depth, length) : (jSType instanceof JSGenericTypeImpl ? this.classTypeHint(type, level, depth, length) : (jSType instanceof JSRecordTypeImpl ? this.recordTypeHint((JSRecordTypeImpl)type, level, depth, length) : this.getTypeText(type, length)))))));
    }

    private final InlayPresentation arrayTypeHint(JSArrayType type, int level, int depth, Ref<Integer> length) {
        String prefixText = "";
        if (type.isReadonly()) {
            prefixText = "readonly ";
        }
        if (type.getType() instanceof JSType.CompositeStructure) {
            prefixText = prefixText + "(";
        }
        CharSequence charSequence = prefixText;
        boolean bl = false;
        InlayPresentation prefix = charSequence.length() > 0 ? this.myFactory.smallText(prefixText) : (InlayPresentation)this.emptyPresentation();
        String postfixText = type.getType() instanceof JSType.CompositeStructure ? ")[]" : "[]";
        InlayPresentation postfix = this.myFactory.smallText(postfixText);
        length.set((Object)(((Number)length.get()).intValue() + prefixText.length() + postfixText.length()));
        return this.myFactory.collapsible(prefix, this.myFactory.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(this, type, level, depth, length){
            final /* synthetic */ JSTypeHintsPresentationFactory this$0;
            final /* synthetic */ JSArrayType $type;
            final /* synthetic */ int $level;
            final /* synthetic */ int $depth;
            final /* synthetic */ Ref $length;

            @NotNull
            public final InlayPresentation invoke() {
                return JSTypeHintsPresentationFactory.access$hint(this.this$0, this.$type.getType(), this.$level, this.$depth + 1, this.$length);
            }
            {
                this.this$0 = jSTypeHintsPresentationFactory;
                this.$type = jSArrayType;
                this.$level = n;
                this.$depth = n2;
                this.$length = ref;
                super(0);
            }
        }, postfix, level > this.myFoldingLevel);
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation tupleTypeHint(JSTupleType type, int level, int depth, Ref<Integer> length) {
        String prefixText = type.isReadonly() ? "readonly [" : "[";
        String suffixText = "]";
        length.set((Object)(((Number)length.get()).intValue() + prefixText.length() + suffixText.length()));
        if (type.getTypes().size() > 1) {
            boolean areAllIdentical = true;
            JSType firstType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type.getTypes().get(0));
            ProcessingContext context = new ProcessingContext();
            boolean bl = false;
            List list2 = type.getTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"type.types");
            for (JSType jsType : (Iterable)list2) {
                void index;
                if (index != false) {
                    boolean bl2 = areAllIdentical = areAllIdentical && TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jsType).isEquivalentTo(firstType, context, true);
                    if (!areAllIdentical) break;
                }
                ++index;
            }
            if (areAllIdentical) {
                bl = true;
                Function0 function0 = (Function0)new Function0<InlayPresentation>(this, type, level, depth, length){
                    final /* synthetic */ JSTypeHintsPresentationFactory this$0;
                    final /* synthetic */ JSTupleType $type;
                    final /* synthetic */ int $level;
                    final /* synthetic */ int $depth;
                    final /* synthetic */ Ref $length;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final InlayPresentation invoke() {
                        Collection<InlayPresentation> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        List list2 = this.$type.getTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"type.types");
                        Iterable iterable = list2;
                        JSTypeHintsPresentationFactory jSTypeHintsPresentationFactory = this.this$0;
                        boolean $i$f$map = false;
                        void var3_4 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JSType jSType = (JSType)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            InlayPresentation inlayPresentation = JSTypeHintsPresentationFactory.access$hint(this.this$0, (JSType)it, this.$level, this.$depth + 1, this.$length);
                            collection.add(inlayPresentation);
                        }
                        collection = (List)destination$iv$iv;
                        return JSTypeHintsPresentationFactory.access$join(jSTypeHintsPresentationFactory, collection, ", ");
                    }
                    {
                        this.this$0 = jSTypeHintsPresentationFactory;
                        this.$type = jSTupleType;
                        this.$level = n;
                        this.$depth = n2;
                        this.$length = ref;
                        super(0);
                    }
                };
                InlayPresentation inlayPresentation = this.myFactory.seq(new InlayPresentation[]{this.hint(firstType, level, depth + 1, length), this.myFactory.smallText(" x" + type.getTypes().size())});
                InlayPresentation inlayPresentation2 = this.myFactory.smallText(suffixText);
                return this.myFactory.collapsible(this.myFactory.smallText(prefixText), inlayPresentation, function0, inlayPresentation2, bl);
            }
        }
        boolean bl = level > this.myFoldingLevel || type.getTypes().size() > 2;
        Function0 function0 = (Function0)new Function0<InlayPresentation>(this, type, level, depth, length){
            final /* synthetic */ JSTypeHintsPresentationFactory this$0;
            final /* synthetic */ JSTupleType $type;
            final /* synthetic */ int $level;
            final /* synthetic */ int $depth;
            final /* synthetic */ Ref $length;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InlayPresentation invoke() {
                Collection<InlayPresentation> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = this.$type.getTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"type.types");
                Iterable iterable = list2;
                JSTypeHintsPresentationFactory jSTypeHintsPresentationFactory = this.this$0;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSType jSType = (JSType)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    InlayPresentation inlayPresentation = JSTypeHintsPresentationFactory.access$hint(this.this$0, (JSType)it, this.$level, this.$depth + 1, this.$length);
                    collection.add(inlayPresentation);
                }
                collection = (List)destination$iv$iv;
                return JSTypeHintsPresentationFactory.access$join(jSTypeHintsPresentationFactory, collection, ", ");
            }
            {
                this.this$0 = jSTypeHintsPresentationFactory;
                this.$type = jSTupleType;
                this.$level = n;
                this.$depth = n2;
                this.$length = ref;
                super(0);
            }
        };
        InlayPresentation inlayPresentation = this.myFactory.smallText(PLACEHOLDER_MARK);
        InlayPresentation inlayPresentation3 = this.myFactory.smallText(suffixText);
        return this.myFactory.collapsible(this.myFactory.smallText(prefixText), inlayPresentation, function0, inlayPresentation3, bl);
    }

    private final InlayPresentation compositeTypeHint(JSUnionOrIntersectionType type, int level, int depth, Ref<Integer> length) {
        List<JSType> list2 = type instanceof JSCompositeTypeBaseImpl ? ((JSCompositeTypeBaseImpl)((Object)type)).getPresentableTypes(JSType.TypeTextFormat.PRESENTABLE) : type.getTypes();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"if (type is JSCompositeT\u2026SENTABLE) else type.types");
        List<Object> types2 = list2;
        if (type instanceof JSContextualUnionType) {
            List list3 = JSCompositeTypeFactory.collapseTypesForUnion((Collection<? extends JSType>)types2, ((JSContextualUnionType)type).isJavaScript()).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"JSCompositeTypeFactory.c\u2026lect(Collectors.toList())");
            types2 = list3;
            if (types2.size() == 1) {
                return this.hint((JSType)types2.get(0), level, depth + 1, length);
            }
        }
        Iterable $this$distinctBy$iv = types2;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JSType it = (JSType)e$iv;
            boolean bl = false;
            String key$iv = it instanceof JSLiteralType && ((JSLiteralType)it).allowWidening() && !JSWidenType.isConstContext(((JSLiteralType)it).getSourceElement()) ? ((JSLiteralType)it).widen(true).getTypeText(JSType.TypeTextFormat.PRESENTABLE) : it.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctBy = list$iv;
        if (distinctBy.size() == 1) {
            return this.hint((JSType)distinctBy.get(0), level, depth + 1, length);
        }
        String separator = type.isUnionType() || type instanceof JSContextualUnionType ? " | " : " & ";
        length.set((Object)(((Number)length.get()).intValue() + separator.length()));
        boolean bl = level > this.myFoldingLevel || distinctBy.size() > 2;
        Function0 function0 = (Function0)new Function0<InlayPresentation>(this, distinctBy, level, depth, length, separator){
            final /* synthetic */ JSTypeHintsPresentationFactory this$0;
            final /* synthetic */ List $distinctBy;
            final /* synthetic */ int $level;
            final /* synthetic */ int $depth;
            final /* synthetic */ Ref $length;
            final /* synthetic */ String $separator;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InlayPresentation invoke() {
                Collection<InlayPresentation> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$distinctBy;
                JSTypeHintsPresentationFactory jSTypeHintsPresentationFactory = this.this$0;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSType jSType = (JSType)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    InlayPresentation inlayPresentation = JSTypeHintsPresentationFactory.access$hint(this.this$0, (JSType)it, this.$level, this.$depth + 1, this.$length);
                    collection.add(inlayPresentation);
                }
                collection = (List)destination$iv$iv;
                return JSTypeHintsPresentationFactory.access$join(jSTypeHintsPresentationFactory, collection, this.$separator);
            }
            {
                this.this$0 = jSTypeHintsPresentationFactory;
                this.$distinctBy = list2;
                this.$level = n;
                this.$depth = n2;
                this.$length = ref;
                this.$separator = string;
                super(0);
            }
        };
        InlayPresentation inlayPresentation = this.myFactory.seq(new InlayPresentation[]{this.hint((JSType)distinctBy.get(0), level, depth + 1, length), this.myFactory.smallText(separator + " ...")});
        InlayPresentation inlayPresentation2 = (InlayPresentation)this.emptyPresentation();
        return this.myFactory.collapsible((InlayPresentation)this.emptyPresentation(), inlayPresentation, function0, inlayPresentation2, bl);
    }

    private final SpacePresentation emptyPresentation() {
        return new SpacePresentation(0, 0);
    }

    private final InlayPresentation getTypeText(JSType type, Ref<Integer> length) {
        JSType jSType = type;
        if (jSType == null) {
            JSAnyType jSAnyType = JSAnyType.get(null, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)jSAnyType, (String)"JSAnyType.get(null, true)");
            jSType = jSAnyType;
        }
        String string = jSType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(type ?: JSAnyType.get(n\u2026peTextFormat.PRESENTABLE)");
        String typeText = string;
        length.set((Object)(((Number)length.get()).intValue() + typeText.length()));
        return this.myFactory.smallText(typeText);
    }

    private final InlayPresentation join(Iterable<? extends InlayPresentation> presentations, String text) {
        InlayPresentation[] inlayPresentationArray;
        boolean bl = false;
        List seq = new ArrayList();
        boolean first = true;
        for (InlayPresentation inlayPresentation : presentations) {
            if (!first) {
                seq.add(this.myFactory.smallText(text));
            }
            seq.add(inlayPresentation);
            first = false;
        }
        Collection collection = seq;
        PresentationFactory presentationFactory = this.myFactory;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = collection;
        InlayPresentation[] inlayPresentationArray2 = thisCollection$iv.toArray(new InlayPresentation[0]);
        if (inlayPresentationArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        InlayPresentation[] inlayPresentationArray3 = inlayPresentationArray = inlayPresentationArray2;
        return presentationFactory.seq(Arrays.copyOf(inlayPresentationArray3, inlayPresentationArray3.length));
    }

    private final InlayPresentation recordTypeHint(JSRecordTypeImpl recordType, int level, int depth, Ref<Integer> length) {
        if (depth > 10) {
            return this.myFactory.smallText("{...}");
        }
        List<JSRecordType.TypeMember> list2 = recordType.getTypeMembers();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"recordType.typeMembers");
        List<JSRecordType.TypeMember> typeMembers = list2;
        length.set((Object)(((Number)length.get()).intValue() + 2));
        return this.myFactory.collapsible(this.myFactory.smallText("{"), this.myFactory.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(this, typeMembers, level, depth, length){
            final /* synthetic */ JSTypeHintsPresentationFactory this$0;
            final /* synthetic */ List $typeMembers;
            final /* synthetic */ int $level;
            final /* synthetic */ int $depth;
            final /* synthetic */ Ref $length;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InlayPresentation invoke() {
                void $this$toTypedArray$iv;
                Object object;
                Object object2;
                boolean bl = false;
                List presentations = new ArrayList<E>();
                bl = false;
                Iterable $this$sortedBy$iv = this.$typeMembers;
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl2 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        String string;
                        String string2;
                        boolean bl = false;
                        JSRecordType.TypeMember it = (JSRecordType.TypeMember)a;
                        boolean bl2 = false;
                        JSRecordType.TypeMember typeMember = it;
                        if (typeMember instanceof JSRecordType.IndexSignature) {
                            string2 = "$";
                        } else if (typeMember instanceof JSRecordType.CallSignature) {
                            string2 = "~";
                        } else if (typeMember instanceof JSRecordType.PropertySignature) {
                            String string3 = ((JSRecordType.PropertySignature)it).getMemberName();
                            string2 = string3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.memberName");
                        } else {
                            string2 = "~~";
                        }
                        it = (JSRecordType.TypeMember)b;
                        Comparable comparable = (Comparable)((Object)string2);
                        bl2 = false;
                        typeMember = it;
                        if (typeMember instanceof JSRecordType.IndexSignature) {
                            string = "$";
                        } else if (typeMember instanceof JSRecordType.CallSignature) {
                            string = "~";
                        } else if (typeMember instanceof JSRecordType.PropertySignature) {
                            String string4 = ((JSRecordType.PropertySignature)it).getMemberName();
                            string = string4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.memberName");
                        } else {
                            string = "~~";
                        }
                        String string5 = string;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string5)));
                    }
                };
                for (JSRecordType.TypeMember typeMember : (Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)) {
                    JSRecordType.TypeMember typeMember2;
                    void index;
                    if (index != false) {
                        presentations.add(JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText(", "));
                    }
                    if ((typeMember2 = typeMember) instanceof JSRecordType.CallSignature) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        List list2 = ((JSRecordType.CallSignature)typeMember).getParameterTypeDecorators();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"typeMember.parameterTypeDecorators");
                        iterable = list2;
                        object2 = this.this$0;
                        boolean $i$f$map = false;
                        comparator = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void p;
                            JSParameterTypeDecorator jSParameterTypeDecorator = (JSParameterTypeDecorator)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl3 = false;
                            PresentationFactory presentationFactory = JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0);
                            InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
                            PresentationFactory presentationFactory2 = JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0);
                            StringBuilder stringBuilder = new StringBuilder();
                            void v5 = p;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"p");
                            inlayPresentationArray[0] = presentationFactory2.smallText(stringBuilder.append(v5.isRest() ? "..." : "").append(p.getName()).append(p.isOptional() ? "?" : "").append(": ").toString());
                            inlayPresentationArray[1] = JSTypeHintsPresentationFactory.access$hint(this.this$0, p.getInferredType(), this.$level, this.$depth + 1, this.$length);
                            InlayPresentation inlayPresentation = presentationFactory.seq(inlayPresentationArray);
                            object.add(inlayPresentation);
                        }
                        object = (List)destination$iv$iv;
                        InlayPresentation element = JSTypeHintsPresentationFactory.access$join((JSTypeHintsPresentationFactory)object2, (Iterable)object, ", ");
                        presentations.add(JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).seq(new InlayPresentation[]{JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText(((JSRecordType.CallSignature)typeMember).hasNew() ? "new (" : "("), element, JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText(")")}));
                    } else if (typeMember2 instanceof JSRecordType.IndexSignature) {
                        presentations.add(JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).seq(new InlayPresentation[]{JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText("[p: "), JSTypeHintsPresentationFactory.access$hint(this.this$0, ((JSRecordType.IndexSignature)typeMember).getMemberParameterType(), this.$level, this.$depth + 1, this.$length), JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText("]: "), JSTypeHintsPresentationFactory.access$hint(this.this$0, ((JSRecordType.IndexSignature)typeMember).getMemberType(), this.$level, this.$depth + 1, this.$length)}));
                    } else if (typeMember2 instanceof JSRecordType.PropertySignature) {
                        presentations.add(JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).seq(new InlayPresentation[]{JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0).smallText((((JSRecordType.PropertySignature)typeMember).isConst() ? "readonly " : "") + ((JSRecordType.PropertySignature)typeMember).getMemberName() + (((JSRecordType.PropertySignature)typeMember).isOptional() ? "?: " : ": ")), JSTypeHintsPresentationFactory.access$hint(this.this$0, ((JSRecordType.PropertySignature)typeMember).getJSType(), this.$level, this.$depth + 1, this.$length)}));
                    }
                    ++index;
                }
                Collection index = presentations;
                object2 = JSTypeHintsPresentationFactory.access$getMyFactory$p(this.this$0);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                InlayPresentation[] inlayPresentationArray = thisCollection$iv.toArray(new InlayPresentation[0]);
                if (inlayPresentationArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object = inlayPresentationArray;
                InlayPresentation[] inlayPresentationArray2 = object;
                return object2.seq(Arrays.copyOf(inlayPresentationArray2, inlayPresentationArray2.length));
            }
            {
                this.this$0 = jSTypeHintsPresentationFactory;
                this.$typeMembers = list2;
                this.$level = n;
                this.$depth = n2;
                this.$length = ref;
                super(0);
            }
        }, this.myFactory.smallText("}"), level > this.myFoldingLevel || typeMembers.size() > 2);
    }

    private final InlayPresentation classTypeHint(JSType classType, int level, int depth, Ref<Integer> length) {
        if (classType instanceof JSGenericTypeImpl && JSArrayType.isGenericArray((JSGenericTypeImpl)classType)) {
            return this.hint(JSArrayType.GenericArrayBuilder.asArrayIfGenericType(classType), level, depth, length);
        }
        JSType jSType = classType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)classType).getType() : classType;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSType, (String)"if (classType is JSGener\u2026sType.type else classType");
        JSType finalType = jSType;
        if (!(finalType instanceof JSResolvableType)) {
            return this.getTypeText(classType, length);
        }
        JSResolvedTypeInfo jSResolvedTypeInfo = ((JSResolvableType)finalType).resolveType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jSResolvedTypeInfo, (String)"finalType.resolveType()");
        PsiElement aClass = (PsiElement)ContainerUtil.getFirstItem(jSResolvedTypeInfo.getDeclarations());
        if (!(aClass instanceof JSQualifiedNamedElement) || ((JSQualifiedNamedElement)aClass).getName() == null) {
            return this.getTypeText(classType, length);
        }
        String string = ((JSQualifiedNamedElement)aClass).getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aClass.name!!");
        String classNameText = string;
        length.set((Object)(((Number)length.get()).intValue() + classNameText.length()));
        InlayPresentation className2 = this.myFactory.psiSingleReference(this.myFactory.smallText(classNameText), (Function0)new Function0<PsiElement>(finalType){
            final /* synthetic */ JSType $finalType;

            public final PsiElement invoke() {
                JSResolvedTypeInfo jSResolvedTypeInfo = ((JSResolvableType)this.$finalType).resolveType();
                Intrinsics.checkExpressionValueIsNotNull((Object)jSResolvedTypeInfo, (String)"finalType.resolveType()");
                return (PsiElement)ContainerUtil.getFirstItem(jSResolvedTypeInfo.getDeclarations());
            }
            {
                this.$finalType = jSType;
                super(0);
            }
        });
        if (!(classType instanceof JSGenericTypeImpl)) {
            return className2;
        }
        length.set((Object)(((Number)length.get()).intValue() + 2));
        List presentations = CollectionsKt.mutableListOf((Object[])new InlayPresentation[]{className2});
        InlayPresentation collapsible2 = this.myFactory.collapsible(this.myFactory.smallText("<"), this.myFactory.smallText(PLACEHOLDER_MARK), (Function0)new Function0<InlayPresentation>(this, classType, level, depth, length){
            final /* synthetic */ JSTypeHintsPresentationFactory this$0;
            final /* synthetic */ JSType $classType;
            final /* synthetic */ int $level;
            final /* synthetic */ int $depth;
            final /* synthetic */ Ref $length;

            @NotNull
            public final InlayPresentation invoke() {
                return JSTypeHintsPresentationFactory.access$parametersHint(this.this$0, (JSGenericTypeImpl)this.$classType, this.$level, this.$depth, this.$length);
            }
            {
                this.this$0 = jSTypeHintsPresentationFactory;
                this.$classType = jSType;
                this.$level = n;
                this.$depth = n2;
                this.$length = ref;
                super(0);
            }
        }, this.myFactory.smallText(">"), level > this.myFoldingLevel);
        presentations.add(collapsible2);
        return (InlayPresentation)new SequencePresentation(presentations);
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation parametersHint(JSGenericTypeImpl classType, int level, int depth, Ref<Integer> length) {
        Collection<InlayPresentation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        length.set((Object)(((Number)length.get()).intValue() + classType.getArguments().size() * ", ".length()));
        List<JSType> list2 = classType.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classType.arguments");
        Iterable iterable = list2;
        JSTypeHintsPresentationFactory jSTypeHintsPresentationFactory = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JSType jSType = (JSType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            InlayPresentation inlayPresentation = this.hint((JSType)it, level + 1, depth + 1, length);
            collection.add(inlayPresentation);
        }
        collection = (List)destination$iv$iv;
        return jSTypeHintsPresentationFactory.join((Iterable<? extends InlayPresentation>)collection, ", ");
    }

    public JSTypeHintsPresentationFactory(@NotNull PresentationFactory myFactory, int myFoldingLevel) {
        Intrinsics.checkParameterIsNotNull((Object)myFactory, (String)"myFactory");
        this.myFactory = myFactory;
        this.myFoldingLevel = myFoldingLevel;
    }

    public static final /* synthetic */ InlayPresentation access$hint(JSTypeHintsPresentationFactory $this, JSType originalType, int level, int depth, Ref length) {
        return $this.hint(originalType, level, depth, (Ref<Integer>)length);
    }

    public static final /* synthetic */ InlayPresentation access$join(JSTypeHintsPresentationFactory $this, Iterable presentations, String text) {
        return $this.join(presentations, text);
    }

    public static final /* synthetic */ PresentationFactory access$getMyFactory$p(JSTypeHintsPresentationFactory $this) {
        return $this.myFactory;
    }

    public static final /* synthetic */ InlayPresentation access$parametersHint(JSTypeHintsPresentationFactory $this, JSGenericTypeImpl classType, int level, int depth, Ref length) {
        return $this.parametersHint(classType, level, depth, (Ref<Integer>)length);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsPresentationFactory$Companion;", "", "()V", "MAX_DEPTH", "", "MAX_LENGTH", "MAX_PROPERTIES", "MAX_TYPES_IN_COMPOSITE", "PLACEHOLDER_MARK", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

