/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportPathBuilder
extends TypeScriptInES6ImportPathBuilder {
    @Nullable
    private final TypeScriptConfig myConfigFile;

    public TypeScriptImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myConfigFile = configuration.getTsConfig();
    }

    @Override
    protected boolean useNodeResolution() {
        if (!super.useNodeResolution()) {
            return false;
        }
        if (this.myConfigFile == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = this.myConfigFile.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == this.myConfigFile.getModule();
    }

    @Override
    public void processModuleNamesWithoutExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        JSModuleNameInfo mapping;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        if (this.myConfigFile != null && (mapping = this.getModuleNameUsingPathMappings()) != null && !processor.process((Object)mapping)) {
            return;
        }
        super.processModuleNamesWithoutExistingImports(processor);
    }

    @Nullable
    private JSModuleNameInfo getModuleNameUsingPathMappings() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        Collection<JSModulePathSubstitution> mappings = this.myConfigFile.getPaths();
        return this.resolveMappingsForBaseUrl(baseUrl, mappings);
    }

    @Nullable
    private VirtualFile getRootFromConfig() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        return baseUrl != null ? baseUrl : this.myConfigFile.getConfigDirectory();
    }

    @Override
    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        VirtualFile rootFile;
        if (moduleFileOrDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (resolvedModuleFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
        }
        if ((rootFile = this.getRootFromConfig()) != null) {
            return this.getPathForRoot(moduleFileOrDirectory, resolvedModuleFile, rootFile);
        }
        return super.processRootPaths(moduleFileOrDirectory, resolvedModuleFile);
    }

    @Override
    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (TypeScriptUtil.isDefinitionFile(this.myFileToImport)) {
            return super.getLinkedProject(importRoot, nodeModules, packageName);
        }
        VirtualFile linkedPackage = TypeScriptImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName);
        if (linkedPackage == null) {
            return null;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, this.myFileToImport);
        if (config2 == null) {
            return null;
        }
        VirtualFile configDirectory = config2.getConfigDirectory();
        if (!VfsUtilCore.isAncestor((VirtualFile)configDirectory, (VirtualFile)this.myFileToImport, (boolean)true)) {
            return null;
        }
        VirtualFile sourceRoot = TypeScriptImportPathBuilder.getSourceRoot(config2, this.myFileToImport);
        if (sourceRoot == null) {
            return null;
        }
        String outDirPath = config2.getOutDirectory();
        VirtualFile outDirectory = (VirtualFile)ObjectUtils.coalesce((Object)(outDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(outDirPath)), (Object)configDirectory);
        if (outDirectory.equals(sourceRoot)) {
            return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, importRoot, importRoot, packageName);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)importRoot, (VirtualFile)outDirectory, (boolean)false)) {
            return null;
        }
        return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, sourceRoot, outDirectory, packageName);
    }

    @Nullable
    private static VirtualFile getSourceRoot(@NotNull TypeScriptConfig importFileConfig, @NotNull VirtualFile fileToImport) {
        VirtualFile rootDir;
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
        }
        if (fileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
        }
        if ((rootDir = importFileConfig.getRootDirFile()) == null) {
            return importFileConfig.getConfigDirectory();
        }
        return VfsUtilCore.isAncestor((VirtualFile)rootDir, (VirtualFile)fileToImport, (boolean)true) ? rootDir : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importFileConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processRootPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLinkedProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

