/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSNodeModulesHandlerScope
extends DelegatingGlobalSearchScope {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<String> myModules;

    public JSNodeModulesHandlerScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope) {
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(2);
        }
        super(baseScope);
        this.myProject = project;
        this.myModules = JSNodeModulesHandlerScope.getAcceptableModules(project, contextFile);
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(3);
        }
        if (!super.contains(file2)) {
            return false;
        }
        Pair<VirtualFile, VirtualFile> pair = ES6CreateImportUtil.findParentLibraryDirectory(this.myProject, file2, NodeModuleUtil.NODE_MODULES_ARRAY);
        return pair == null ? this.isAcceptableProjectFile(file2) : this.isAcceptableNodeModulesFile(file2, (VirtualFile)pair.first, (VirtualFile)pair.second);
    }

    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull VirtualFile module, @NotNull VirtualFile nodeModules) {
        String name;
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(6);
        }
        if (nodeModules == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(7);
        }
        if (this.myModules.isEmpty()) {
            return false;
        }
        VirtualFile parent = module.getParent();
        String originalModuleName = name = module.getName();
        if (!nodeModules.equals(parent)) {
            CharSequence sequence = parent.getNameSequence();
            if (StringUtil.equals((CharSequence)sequence, (CharSequence)"types")) {
                originalModuleName = ES6CreateImportUtil.convertScopedTypesName(name);
            }
            name = parent.getName() + "/" + name;
        }
        return this.myModules.contains(name) || this.myModules.contains(originalModuleName);
    }

    private static Set<String> getAcceptableModules(@NotNull Project project, @NotNull VirtualFile contextFile) {
        PackageJsonFileManager manager2;
        Set<VirtualFile> files;
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(8);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(9);
        }
        if ((files = (manager2 = PackageJsonFileManager.getInstance(project)).getValidPackageJsonFiles()).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> moduleNames = new HashSet<String>();
        for (VirtualFile file2 : files) {
            VirtualFile directory = file2.getParent();
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)contextFile, (boolean)true)) continue;
            PackageJsonData data = PackageJsonData.getOrCreate(file2);
            moduleNames.addAll(data.getAllDependencies());
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String name : moduleNames) {
            if (!name.startsWith("@types/")) continue;
            String realName = ES6CreateImportUtil.convertScopedTypesName(name.substring("@types/".length()));
            toRemove.add(realName);
        }
        moduleNames.removeAll(toRemove);
        return moduleNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSNodeModulesHandlerScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableProjectFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getAcceptableModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

