/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocUtil;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.documentation.PackageJsonEntries;
import com.intellij.javascript.nodejs.packageJson.documentation.PackageJsonEntry;
import com.intellij.javascript.nodejs.packageJson.documentation.VersionRangeDocBuilder;
import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private static final String URL_PREFIX = "https://www.npmjs.com/package/";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return originalElement != null ? PackageJsonDocumentationProvider.doGetQuickNavigateInfo(originalElement) : null;
    }

    @Nullable
    private static String doGetQuickNavigateInfo(@NotNull PsiElement element) {
        JsonProperty property;
        if (element == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((property = PackageJsonUtil.findContainingProperty(element)) != null) {
            PackageJsonEntry entry;
            if (PackageJsonUtil.isTopLevelProperty(property) && (entry = PackageJsonEntries.findEntryByName(property.getName())) != null) {
                return entry.getShortDescription();
            }
            if (PackageJsonUtil.isPackageDependencyProperty(property)) {
                JsonStringLiteral literal = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class, (boolean)false);
                if (property.getNameElement().equals(literal) || literal == null) {
                    return PackageJsonDocumentationProvider.getQuickNavigateInfoForDependencyName(property);
                }
                if (literal.equals(property.getValue())) {
                    String packageName = property.getName();
                    InstalledPackageVersion pkg = PackageJsonDocumentationProvider.findInstalledPackage((PsiElement)property, packageName);
                    return new VersionRangeDocBuilder(packageName, pkg, literal.getValue()).buildQuickNavigateInfo();
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfoForDependencyName(JsonProperty property) {
        String packageName = property.getName();
        VirtualFile packageDir = PackageJsonDocumentationProvider.findInstalledPackageDir((PsiElement)property, packageName);
        if (packageDir != null) {
            NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir, false);
            if (documentation != null) {
                return documentation.getQuickInfoHtml();
            }
        } else {
            NodePackageInfo packageInfo = NodePackageUtil.loadCachedPackageInfo(packageName);
            if (packageInfo != null) {
                return new NodeJsPackageDocumentation(packageName, packageInfo.getDescription(), null, null).getQuickInfoHtml();
            }
            return "Not installed package";
        }
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (originalElement != null) {
            return PackageJsonDocumentationProvider.doGetUrlFor(originalElement);
        }
        if (element != null) {
            return PackageJsonDocumentationProvider.doGetUrlFor(element);
        }
        return null;
    }

    @Nullable
    private static List<String> doGetUrlFor(@NotNull PsiElement element) {
        VirtualFile dir;
        if (element == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiDirectory && PackageJsonUtil.findChildPackageJsonFile(dir = ((PsiDirectory)element).getVirtualFile()) != null) {
            return Collections.singletonList(URL_PREFIX + dir.getName());
        }
        JsonProperty property = PackageJsonUtil.findContainingProperty(element);
        if (property != null && PackageJsonUtil.isPackageDependencyProperty(property)) {
            return Collections.singletonList(URL_PREFIX + property.getName());
        }
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return originalElement != null ? this.doGenerateDoc(originalElement) : null;
    }

    @Nullable
    public String doGenerateDoc(@NotNull PsiElement element) {
        PackageJsonEntry entry;
        JsonProperty property;
        if (element == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(2);
        }
        if ((property = PackageJsonUtil.findContainingProperty(element)) != null && PackageJsonUtil.isTopLevelProperty(property) && (entry = PackageJsonEntries.findEntryByName(property.getName())) != null) {
            return HintUtil.prepareHintText((String)entry.getHtmlFullDescription(), (HintHint)new HintHint());
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof PackageJsonEntry) {
            Project project;
            PackageJsonEntry entry = (PackageJsonEntry)object;
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (project != null) {
                return PackageJsonDocumentationProvider.generateElement(project, entry);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement generateElement(@NotNull Project project, @NotNull PackageJsonEntry entry) {
        if (project == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (entry == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(4);
        }
        String jsonText = "{" + StringUtil.wrapWithDoubleQuote((String)entry.getName()) + ":\"\"}";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("package.json", (Language)JsonLanguage.INSTANCE, (CharSequence)jsonText);
        PsiElement[] topLevelChildren = psiFile.getChildren();
        JsonObject object = null;
        for (PsiElement child : topLevelChildren) {
            if (!(child instanceof JsonObject)) continue;
            object = (JsonObject)child;
            break;
        }
        if (object == null) {
            return null;
        }
        List properties = object.getPropertyList();
        for (JsonProperty property : properties) {
            if (!entry.getName().equals(property.getName())) continue;
            return property.getNameElement();
        }
        return null;
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        NodePackageInfo packageInfo;
        String packageName = PackageJsonDocumentationProvider.toPackageName(docUrls);
        if (packageName == null) {
            return null;
        }
        VirtualFile packageDir = (VirtualFile)ReadAction.compute(() -> {
            if (element instanceof PsiDirectory) {
                return ((PsiDirectory)element).getVirtualFile();
            }
            PsiElement elementAtCaret = PackageJsonDocumentationProvider.getElementAtCaret(element);
            return PackageJsonDocumentationProvider.findInstalledPackageDir(elementAtCaret, packageName);
        });
        if (packageDir != null) {
            NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir, true);
            if (documentation != null) {
                return documentation.getFullDocHtml();
            }
        } else if (project != null && (packageInfo = PackageJsonDocumentationProvider.loadPackageInfo(project, packageName)) != null) {
            return new NodeJsPackageDocumentation(packageName, packageInfo.getDescription(), null, null).setContextElement(element).getFullDocHtml();
        }
        return null;
    }

    @Nullable
    private static String toPackageName(@Nullable List<String> docUrls) {
        String url = (String)ContainerUtil.getFirstItem(docUrls);
        if (url != null && url.startsWith(URL_PREFIX)) {
            return url.substring(URL_PREFIX.length());
        }
        return null;
    }

    @Nullable
    private static PsiElement getElementAtCaret(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return element;
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        return pointer != null ? pointer.getElement() : null;
    }

    @Nullable
    private static NodePackageInfo loadPackageInfo(@NotNull Project project, @NotNull String packageName) {
        NodePackageInfo packageInfo;
        if (project == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(6);
        }
        if ((packageInfo = NodePackageUtil.loadCachedPackageInfo(packageName)) != null) {
            return packageInfo;
        }
        NodeJsLocalInterpreter localInterpreter = PackageJsonDocumentationProvider.getLocalInterpreter(project);
        if (localInterpreter != null) {
            try {
                return NodePackageUtil.loadPackageInfo(project, localInterpreter, packageName, true, ProgressManager.getInstance().getProgressIndicator());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static NodeJsLocalInterpreter getLocalInterpreter(@NotNull Project project) {
        if (project == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(7);
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        try {
            return NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile findInstalledPackageDir(@Nullable PsiElement element, @NotNull String packageName) {
        InstalledPackageVersion pkg;
        if (packageName == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(8);
        }
        return (pkg = PackageJsonDocumentationProvider.findInstalledPackage(element, packageName)) != null ? pkg.getPackageDir() : null;
    }

    @Nullable
    private static InstalledPackageVersion findInstalledPackage(@Nullable PsiElement element, @NotNull String packageName) {
        VirtualFile file2;
        if (packageName == null) {
            PackageJsonDocumentationProvider.$$$reportNull$$$0(9);
        }
        JsonFile psiFile = element != null ? PackageJsonUtil.getContainingPackageJsonFile(element) : null;
        VirtualFile virtualFile = file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file2 != null) {
            NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(element.getProject(), file2);
            return finder.findInstalledPackage(packageName);
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        JsonProperty property = originalElement != null ? PackageJsonUtil.findContainingProperty(originalElement) : null;
        return property != null && PackageJsonUtil.isPackageDependencyProperty(property);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/documentation/PackageJsonDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetQuickNavigateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetUrlFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateDoc";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackageInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalInterpreter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstalledPackageDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstalledPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

