/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class NpmRegistryServiceImpl
extends NpmRegistryService {
    private static final String USER_AGENT = "JetBrains IDE";
    private static final Logger LOG = Logger.getInstance(NpmRegistryServiceImpl.class);
    private static final Map<String, String> ourTestUrlMappings = ApplicationManager.getApplication().isUnitTestMode() ? ContainerUtil.newConcurrentMap() : null;
    private final ConcurrentMap<String, TimestampedVersions> myVersionsCache = ContainerUtil.createConcurrentSoftMap();
    private final ConcurrentMap<String, Future<AvailablePackageVersions>> myRunningFutures = ContainerUtil.newConcurrentMap();
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Npm Registry Pool", (int)2);

    @Override
    public void findPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        int MAX_DUP_COUNT = 50;
        int limitMargin = 1 + limit / 100;
        int queryLimit = searchQuery.getMaxQueryBatchSize();
        HashSet<String> all = new HashSet<String>();
        int found = 0;
        int skip = 0;
        int dupCount = 0;
        while (found < limit) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int localLimit = Math.min(queryLimit, limit - found + limitMargin);
            List<NodePackageBasicInfo> results = NpmRegistryServiceImpl.findPackagesOrWaitForIt(indicator, searchQuery, skip, localLimit);
            skip += results.size();
            for (NodePackageBasicInfo info : results) {
                if (all.add(info.getName())) {
                    if (!filter.value((Object)info)) continue;
                    consumer.consume((Object)info);
                    if (++found < limit) continue;
                    break;
                }
                ++dupCount;
            }
            if (results.size() < localLimit) break;
            if (dupCount <= 50) continue;
            LOG.warn("Found over 50 duplicated packages with query: " + searchQuery + ". Stopping to preserve infinite loop.");
            break;
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> findPackagesOrWaitForIt(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List list2;
            try {
                list2 = (List)ApplicationUtil.runWithCheckCanceled(() -> NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (list2 == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        return NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit);
    }

    @NotNull
    private static List<NodePackageBasicInfo> doFetchPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        List<NodePackageBasicInfo> list2;
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(5);
        }
        String url = searchQuery.getQueryUrl(skip, limit);
        try {
            long startNano = System.nanoTime();
            String content = NpmRegistryServiceImpl.fetchUrl(url, null, indicator);
            List<NodePackageBasicInfo> infos = searchQuery.parseContent(content);
            long exactPrefixes = infos.stream().filter(info -> info.getName().startsWith(searchQuery.myText)).count();
            LOG.info("Found " + infos.size() + " packages (" + exactPrefixes + " with '" + searchQuery.myText + "' prefix) in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list2 = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for " + searchQuery + ": " + e.getMessage(), e);
        }
        if (list2 == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @Nullable
    public JsonObject fetchPackageJson(@NotNull String packageName, @NotNull String versionOrRange, @Nullable ProgressIndicator indicator) {
        String packagePath;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(7);
        }
        if (versionOrRange == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(8);
        }
        if (versionOrRange.isEmpty()) {
            versionOrRange = "*";
        }
        SemVer version = SemVer.parseFromText((String)versionOrRange);
        Requirement req = null;
        if (version == null) {
            try {
                req = Requirement.buildNPM((String)versionOrRange);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean distTag = false;
        String versionSuffix = null;
        if (packageName.startsWith("@")) {
            if (version != null) {
                versionSuffix = "=" + versionOrRange;
            } else if (!"latest".equals(versionOrRange) && req != null) {
                versionSuffix = versionOrRange;
            } else {
                distTag = true;
            }
            packagePath = "@" + URLUtil.encodeURIComponent((String)packageName.substring(1));
        } else {
            if (version != null) {
                versionSuffix = versionOrRange;
            } else if ("latest".equals(versionOrRange) || req == null) {
                versionSuffix = versionOrRange;
            }
            packagePath = URLUtil.encodeURIComponent((String)packageName);
        }
        boolean fetchList = versionSuffix == null;
        String url = "https://registry.npmjs.org/" + packagePath + (!fetchList ? "/" + versionSuffix : "");
        long startNano = System.nanoTime();
        try {
            JsonObject result2;
            String content = NpmRegistryServiceImpl.fetchUrl(url, null, null);
            if (fetchList) {
                version = distTag ? NpmRegistryServiceImpl.findDistTag(content, versionOrRange) : NpmRegistryServiceImpl.findHighestPackageVersion(content, versionOrRange);
                if (version == null) {
                    return null;
                }
                try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                    result2 = NpmRegistryServiceImpl.loadPackageJson(reader, version.getRawVersion());
                }
            } else {
                result2 = (JsonObject)new JsonParser().parse(content);
            }
            LOG.info("Loaded package.json for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return result2;
        }
        catch (Exception e) {
            LOG.info("Failed to fetch package.json from " + url, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static SemVer findDistTag(@NotNull String content, @NotNull String distTag) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(9);
        }
        if (distTag == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            AvailablePackageVersions versions = AvailablePackageVersions.parseFromPackageMetadata(reader);
            SemVer semVer = versions.findVersionByDistTag(distTag);
            return semVer;
        }
    }

    @Nullable
    private static SemVer findHighestPackageVersion(@NotNull String content, @NotNull String range) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(11);
        }
        if (range == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        Requirement req = Requirement.buildNPM((String)range);
        Semver highest = null;
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("versions")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        try {
                            Semver v = new Semver(reader.nextName(), Semver.SemverType.NPM);
                            if (req.isSatisfiedBy(v) && (highest == null || v.isGreaterThan(highest))) {
                                highest = v;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        reader.skipValue();
                    }
                    break;
                }
                reader.skipValue();
            }
        }
        if (highest == null) {
            return null;
        }
        return SemVer.parseFromText((String)highest.getOriginalValue());
    }

    @Nullable
    private static JsonObject loadPackageJson(@NotNull JsonReader reader, @NotNull String version) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        if (version == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(14);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("versions")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String v = reader.nextName();
                    if (version.equals(v)) {
                        return (JsonObject)new JsonParser().parse(reader);
                    }
                    reader.skipValue();
                }
                break;
            }
            reader.skipValue();
        }
        return null;
    }

    @Override
    @Nullable
    public AvailablePackageVersions getCachedPackageVersions(@NotNull String packageName) {
        TimestampedVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        if ((cache = (TimestampedVersions)this.myVersionsCache.get(packageName)) != null && cache.getCreateTimeNano() + TimeUnit.MINUTES.toNanos(10L) > System.nanoTime()) {
            return cache.getVersions();
        }
        return null;
    }

    @Override
    @NotNull
    public Promise<AvailablePackageVersions> asyncUpdateAndGetPackageVersions(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Future<AvailablePackageVersions> future = this.getOrCreateVersionsFetchFuture(packageName);
            try {
                promise.setResult((Object)future.get());
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(17);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public AvailablePackageVersions getCachedOrFetchPackageVersions(@Nullable ProgressIndicator indicator, @NotNull String packageName) {
        AvailablePackageVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(18);
        }
        if ((cache = this.getCachedPackageVersions(packageName)) != null) {
            AvailablePackageVersions availablePackageVersions = cache;
            if (availablePackageVersions == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(19);
            }
            return availablePackageVersions;
        }
        Future<AvailablePackageVersions> future = this.getOrCreateVersionsFetchFuture(packageName);
        AvailablePackageVersions versions = null;
        if (indicator == null) {
            try {
                versions = future.get();
            }
            catch (Exception exception) {}
        } else {
            while (true) {
                try {
                    versions = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!indicator.isCanceled()) continue;
                    AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.createEmpty();
                    if (availablePackageVersions == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(20);
                    }
                    return availablePackageVersions;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
        }
        AvailablePackageVersions availablePackageVersions = versions != null ? versions : AvailablePackageVersions.createEmpty();
        if (availablePackageVersions == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(21);
        }
        return availablePackageVersions;
    }

    @Override
    @NotNull
    public Future<AvailablePackageVersions> getCachedOrFetchPackageVersionsFuture(@NotNull String packageName) {
        AvailablePackageVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(22);
        }
        return (cache = this.getCachedPackageVersions(packageName)) != null ? CompletableFuture.completedFuture(cache) : this.getOrCreateVersionsFetchFuture(packageName);
    }

    public static void addTestUrlMapping(@NotNull String url, @NotNull String localFile, @NotNull Disposable parentDisposable) {
        if (url == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(23);
        }
        if (localFile == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(24);
        }
        if (parentDisposable == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(25);
        }
        if (ourTestUrlMappings.put(url, localFile) != null) {
            throw new IllegalStateException("Existent mapping for " + url);
        }
        Disposer.register((Disposable)parentDisposable, () -> ourTestUrlMappings.remove(url));
    }

    public static void addTestUrlMappings(@NotNull Map<String, String> mappings, @NotNull Disposable parentDisposable) {
        if (mappings == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(26);
        }
        if (parentDisposable == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(27);
        }
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            NpmRegistryServiceImpl.addTestUrlMapping(entry.getKey(), entry.getValue(), parentDisposable);
        }
    }

    @NotNull
    private Future<AvailablePackageVersions> getOrCreateVersionsFetchFuture(@NotNull String packageName) {
        FutureTask<AvailablePackageVersions> newFuture;
        Future running;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(28);
        }
        if ((running = (Future)this.myRunningFutures.putIfAbsent(packageName, newFuture = new FutureTask<AvailablePackageVersions>(() -> {
            AvailablePackageVersions versions = NpmRegistryServiceImpl.fetchPackageVersions(packageName);
            this.myVersionsCache.put(packageName, new TimestampedVersions(versions));
            this.myRunningFutures.remove(packageName);
            return versions;
        }))) != null) {
            Future future = running;
            if (future == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(29);
            }
            return future;
        }
        this.myExecutorService.execute(newFuture);
        FutureTask<AvailablePackageVersions> futureTask = newFuture;
        if (futureTask == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(30);
        }
        return futureTask;
    }

    @Nullable
    private static AvailablePackageVersions fetchPackageVersions(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(31);
        }
        String packagePath = packageName.startsWith("@") ? "@" + URLUtil.encodeURIComponent((String)packageName.substring(1)) : URLUtil.encodeURIComponent((String)packageName);
        String url = "http://registry.npmjs.org/" + packagePath;
        long startNano = System.nanoTime();
        try {
            String content = NpmRegistryServiceImpl.fetchUrl(url, "application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*", null);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            AvailablePackageVersions versions = AvailablePackageVersions.parseFromPackageMetadata(reader);
            reader.close();
            List<Pair<String, SemVer>> distTags = versions.getDistTags();
            LOG.info("Found " + distTags.size() + " dist-tags, " + versions.getVersions().size() + " versions for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return versions;
        }
        catch (Exception e) {
            String message = "Failed to fetch '" + packageName + "' package versions from " + url;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message, (Throwable)e);
            } else {
                LOG.info(message, (Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    private static String fetchUrl(@NotNull String url, @Nullable String mimeType, @Nullable ProgressIndicator indicator) throws IOException {
        if (url == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(32);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String mappedUrl = ourTestUrlMappings.computeIfAbsent(url, u -> {
                throw new IllegalStateException("URL " + u + " is not mapped to local resource.");
            });
            String string = FileUtil.loadFile((File)new File(mappedUrl), (Charset)StandardCharsets.UTF_8);
            if (string == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = HttpRequests.request((String)url).userAgent(USER_AGENT).accept(mimeType).gzip(true).readString(indicator);
        if (string == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    public static NodePackageBasicInfo readPackageInfo(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(35);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        String description = null;
        while (reader.hasNext()) {
            String propName = reader.nextName();
            if (propName.equals("name")) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if (propName.equals("description")) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name != null ? new NodePackageBasicInfo(name, description) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl";
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOrRange";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagesOrWaitForIt";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchPackages";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncUpdateAndGetPackageVersions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrFetchPackageVersions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVersionsFetchFuture";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesOrWaitForIt";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doFetchPackages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageJson";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDistTag";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findHighestPackageVersion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPackageJson";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPackageVersions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateAndGetPackageVersions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageVersions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageVersionsFuture";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addTestUrlMapping";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTestUrlMappings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateVersionsFetchFuture";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageVersions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fetchUrl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readPackageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TimestampedVersions {
        private final long myCreateTimeNano;
        private final AvailablePackageVersions myVersions;

        private TimestampedVersions(@Nullable AvailablePackageVersions versions) {
            this.myVersions = versions;
            this.myCreateTimeNano = System.nanoTime();
        }

        public long getCreateTimeNano() {
            return this.myCreateTimeNano;
        }

        @Nullable
        public AvailablePackageVersions getVersions() {
            return this.myVersions;
        }
    }
}

