/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpResolvedDependencyTree;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class YarnPnpDependencyTree {
    private final ImmutableMap<String, YarnPnpDependency> myDeps;
    private final boolean myVirtualResolved;
    private final AtomicNotNullLazyValue<YarnPnpResolvedDependencyTree> myResolvedDependencyTreeValue;

    private YarnPnpDependencyTree(@NotNull Map<String, YarnPnpDependency> deps, boolean virtualResolved) {
        if (deps == null) {
            YarnPnpDependencyTree.$$$reportNull$$$0(0);
        }
        this.myResolvedDependencyTreeValue = AtomicNotNullLazyValue.createValue(() -> (YarnPnpResolvedDependencyTree)ReadAction.compute(() -> YarnPnpResolvedDependencyTree.create(this)));
        this.myDeps = ImmutableMap.copyOf(deps);
        this.myVirtualResolved = virtualResolved;
    }

    @NotNull
    ImmutableMap<String, YarnPnpDependency> getDeps() {
        ImmutableMap<String, YarnPnpDependency> immutableMap = this.myDeps;
        if (immutableMap == null) {
            YarnPnpDependencyTree.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    boolean isVirtualResolved() {
        return this.myVirtualResolved;
    }

    @NotNull
    public YarnPnpResolvedDependencyTree getResolvedDependencyTree() {
        YarnPnpResolvedDependencyTree yarnPnpResolvedDependencyTree = (YarnPnpResolvedDependencyTree)this.myResolvedDependencyTreeValue.getValue();
        if (yarnPnpResolvedDependencyTree == null) {
            YarnPnpDependencyTree.$$$reportNull$$$0(2);
        }
        return yarnPnpResolvedDependencyTree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YarnPnpDependencyTree tree = (YarnPnpDependencyTree)o;
        return this.myVirtualResolved == tree.myVirtualResolved && this.myDeps.equals(tree.myDeps);
    }

    public int hashCode() {
        return Objects.hash(this.myDeps, this.myVirtualResolved);
    }

    public String toString() {
        return "deps=" + this.myDeps.values() + ", virtualResolved=" + this.myVirtualResolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpDependencyTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpDependencyTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeps";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedDependencyTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final LinkedHashMap<String, YarnPnpDependency> myDeps = new LinkedHashMap();
        private boolean myVirtualResolved = false;

        public void addDependency(@NotNull String name, @NotNull String requireableLocation, @Nullable String requireableLocationWithVirtualResolved) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (requireableLocation == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myDeps.put(name, new YarnPnpDependency(name, requireableLocation, requireableLocationWithVirtualResolved));
        }

        public void setVirtualResolved(boolean virtualResolved) {
            this.myVirtualResolved = virtualResolved;
        }

        @NotNull
        public YarnPnpDependencyTree build() {
            return new YarnPnpDependencyTree(this.myDeps, this.myVirtualResolved);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requireableLocation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpDependencyTree$Builder";
            objectArray[2] = "addDependency";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

