/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesFetchSession;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloader;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeCoreLibraryConfigurator {
    static final Logger LOG = Logger.getInstance(NodeCoreLibraryConfigurator.class);
    private static final String NODE_CORE_LIBRARY_CONFIGURED_VERSION = "javascript.nodejs.core.library.configured.version";
    private final Project myProject;
    private final NodeCoreLibraryManager myCoreLibraryManager;
    volatile List<VirtualFile> myTestCoreModuleFiles;

    public NodeCoreLibraryConfigurator(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCoreLibraryManager = NodeCoreLibraryManager.getInstance(project);
    }

    @NotNull
    public static NodeCoreLibraryConfigurator getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(1);
        }
        NodeCoreLibraryConfigurator nodeCoreLibraryConfigurator = (NodeCoreLibraryConfigurator)ServiceManager.getService((Project)project, NodeCoreLibraryConfigurator.class);
        if (nodeCoreLibraryConfigurator == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(2);
        }
        return nodeCoreLibraryConfigurator;
    }

    @Nullable
    public SemVer getConfiguredCoreLibraryVersion() {
        String value = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        return SemVer.parseFromText((String)value);
    }

    @NotNull
    public static String getConfiguredCoreLibraryVersionStr(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(3);
        }
        String value = PropertiesComponent.getInstance((Project)project).getValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
        String string = StringUtil.notNullize((String)value);
        if (string == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getConfiguredCoreLibraryVersionStr() {
        return NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersionStr(this.myProject);
    }

    private void setCoreLibraryConfigured(@NotNull String version) {
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION, version, null);
    }

    public boolean isAvailable(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(6);
        }
        try {
            NodeCommandLineConfigurator.find(interpreter);
            return true;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private void configure(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(7);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(8);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(9);
        }
        try {
            String versionStr = version.getRawVersion();
            File nodeVersionDir = NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr);
            FileUtil.delete((File)nodeVersionDir);
            File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir(versionStr);
            FileUtil.createDirectory((File)coreModulesSrcDir);
            File typingsDir = NodeCoreLibraryConfigurator.getTypingsDir(versionStr);
            FileUtil.createDirectory((File)typingsDir);
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            NodeTypingsDownloader downloader = new NodeTypingsDownloader(interpreter, this.getNpmPackage(interpreter), typingsDir);
            Future<Object> typingsInfoFuture = downloader.download(indicator);
            NodeCoreSourcesFetchSession session = new NodeCoreSourcesFetchSession(this.myProject, interpreter, coreModulesSrcDir);
            session.fetchSourcesSync();
            try {
                typingsInfoFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.warn("Cannot download @types/node", (Throwable)e);
            }
            this.setCoreLibraryConfigured(versionStr);
            NodeCoreLibraryConfigurator.refresh(nodeVersionDir, () -> {
                ReadAction.run(() -> {
                    NodeCoreSourcesSnapshot snapshot = NodeCoreLibraryConfigurator.getSnapshot(coreModulesSrcDir);
                    this.myCoreLibraryManager.setSnapshot(snapshot);
                });
                this.scheduleLibrariesUpdate(true, rootsToAssociateWith, onDone);
            });
        }
        catch (ExecutionException | IOException e) {
            NotificationGroup group = new NotificationGroup("Node.js coding assistance", NotificationDisplayType.BALLOON, true);
            group.createNotification("Cannot enable Node.js coding assistance", StringUtil.notNullize((String)ExceptionUtil.getMessage((Throwable)e)), NotificationType.ERROR, null).notify(this.myProject);
            LOG.warn("Cannot configure Node.js Core library", e);
            this.scheduleLibrariesUpdate(false, rootsToAssociateWith, onDone);
        }
    }

    @Nullable
    static NodeCoreSourcesSnapshot getSnapshot(@NotNull File coreModulesSrcDir) {
        VirtualFile coreModulesSrcVirtualDir;
        if (coreModulesSrcDir == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(10);
        }
        if ((coreModulesSrcVirtualDir = LocalFileSystem.getInstance().findFileByIoFile(coreModulesSrcDir)) != null) {
            return new NodeCoreSourcesSnapshot(coreModulesSrcVirtualDir);
        }
        return null;
    }

    @Nullable
    private NodePackage getNpmPackage(@NotNull NodeJsInterpreter interpreter) {
        NodePackage pkg;
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(11);
        }
        if ((pkg = NpmManager.getInstance(this.myProject).getPackage(interpreter)) == null) {
            return NpmUtil.resolveRef(NodePackageRef.create("npm"), this.myProject, interpreter);
        }
        return pkg;
    }

    private static void refresh(@NotNull File nodeVersionDir, @NotNull Runnable finishRunnable) {
        if (nodeVersionDir == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(12);
        }
        if (finishRunnable == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(13);
        }
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            WriteAction.run(() -> {
                VirtualFile nodeVersionVirtualDir = VfsUtil.findFileByIoFile((File)nodeVersionDir, (boolean)true);
                if (nodeVersionVirtualDir == null) {
                    LOG.warn("Cannot find " + nodeVersionDir.getAbsolutePath() + ", refresh skipped");
                } else {
                    LOG.debug("Refreshing " + nodeVersionVirtualDir.getPath());
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{nodeVersionVirtualDir});
                }
            });
            finishRunnable.run();
        });
    }

    private void scheduleLibrariesUpdate(boolean success, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(14);
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            WriteAction.run(() -> {
                if (success) {
                    JSLibraryManager.getInstance(this.myProject).commitChanges();
                }
            });
            if (success) {
                this.associateWith(rootsToAssociateWith);
                WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
            }
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void associateWith(@NotNull List<VirtualFile> rootsToAssociateWith) {
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(15);
        }
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
        for (VirtualFile root : rootsToAssociateWith) {
            libraryMappings.associate(root, "Node.js Core", true);
            LOG.info("Library 'Node.js Core' have been associated with " + (root == null ? "project" : root.getPath()));
        }
    }

    @NotNull
    static File getNodeVersionDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(16);
        }
        return new File(JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "nodejs" + File.separatorChar + versionStr);
    }

    @NotNull
    public static File getCoreModulesSrcDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(17);
        }
        return new File(NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr), "core-modules");
    }

    @NotNull
    public static File getTypingsDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(18);
        }
        return new File(NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr), "node-typings");
    }

    public void setCoreModulesForTests(VirtualFile ... testCoreModuleFiles) {
        if (testCoreModuleFiles == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(19);
        }
        this.myTestCoreModuleFiles = Arrays.asList(testCoreModuleFiles);
        if (this.myTestCoreModuleFiles.isEmpty()) {
            this.myCoreLibraryManager.setSnapshot(null);
        } else {
            VirtualFile parentDir = ((VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(this.myTestCoreModuleFiles))).getParent();
            this.myCoreLibraryManager.setSnapshot(new NodeCoreSourcesSnapshot(parentDir));
        }
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void removeAllCoreModulesForTests() {
        this.myTestCoreModuleFiles = null;
        this.myCoreLibraryManager.setSnapshot(null);
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void configureAndAssociateWithProject(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(20);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(21);
        }
        this.configureAndAssociateWith(interpreter, version, Collections.singletonList(null), onDone);
    }

    public void configureAndAssociateWith(final @NotNull NodeJsInterpreter interpreter, final @NotNull SemVer version, final @NotNull List<VirtualFile> rootsToAssociateWith, final @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(22);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(23);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        new Task.Backgroundable(this.myProject, "Configuring Node.js Coding Assistance...", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                NodeCoreLibraryConfigurator.this.configure(interpreter, version, rootsToAssociateWith, onDone);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$1", "run"));
            }
        }.queue();
    }

    public void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String version = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isNotEmpty((String)version)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PropertiesComponent.getInstance((Project)this.myProject).unsetValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
                JSLibraryManager.getInstance(this.myProject).commitChanges();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 5: 
            case 8: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModulesSrcDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersionDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishRunnable";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCoreModuleFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredCoreLibraryVersionStr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredCoreLibraryVersionStr";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCoreLibraryConfigured";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNpmPackage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLibrariesUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "associateWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersionDir";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCoreModulesSrcDir";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypingsDir";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setCoreModulesForTests";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWithProject";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

