/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.env;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.javascript.nodejs.env.DotEnvFileManager;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeEnvironmentVariablesProvider {
    private final Project myProject;
    private final DotEnvFileManager myDotEnvManager;
    private volatile Map<String, String> myEnvironment;

    public NodeEnvironmentVariablesProvider(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDotEnvManager = DotEnvFileManager.getInstance(project);
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onRunConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(1);
        }
        if (NodeEnvironmentVariablesProvider.getEnvironment(settings.getConfiguration()) != null) {
            this.myEnvironment = this.collectCommonEnvironment();
        }
    }

    @NotNull
    public Map<String, String> getEnvironment(@Nullable VirtualFile contextFile) {
        List<DotEnvFileManager.EnvFileData> envFileDataList = this.myDotEnvManager.findEnvs(contextFile);
        Map<String, String> staticEnvs = this.getEnvironment();
        if (envFileDataList.isEmpty()) {
            Map<String, String> map = staticEnvs;
            if (map == null) {
                NodeEnvironmentVariablesProvider.$$$reportNull$$$0(2);
            }
            return map;
        }
        EnvMerger envMerger = new EnvMerger();
        for (DotEnvFileManager.EnvFileData envFileData : envFileDataList) {
            envMerger.addEnvsIfAbsent(envFileData.getEnvs());
        }
        envMerger.addEnvsIfAbsent(staticEnvs);
        LinkedHashMap linkedHashMap = envMerger.myOrderedEnvs;
        if (linkedHashMap == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    @NotNull
    private Map<String, String> getEnvironment() {
        Map<String, String> envs = this.myEnvironment;
        if (envs == null) {
            this.myEnvironment = envs = this.collectCommonEnvironment();
        }
        Map<String, String> map = envs;
        if (map == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    private Map<String, String> collectCommonEnvironment() {
        EnvMerger envMerger = new EnvMerger();
        for (RunConfiguration configuration : RunManager.getInstance((Project)this.myProject).getAllConfigurationsList()) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            if (environment == null) continue;
            envMerger.addEnvsIfAbsent(environment);
        }
        envMerger.addEnvsIfAbsent(EnvironmentUtil.getEnvironmentMap());
        LinkedHashMap linkedHashMap = envMerger.myOrderedEnvs;
        if (linkedHashMap == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(6);
        }
        return contextFile != null ? this.myDotEnvManager.getNavigatable(envVarName, contextFile) : null;
    }

    public boolean navigate(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(7);
        }
        if (contextFile != null) {
            Navigatable navigatable = this.getNavigatable(envVarName, contextFile);
            if (navigatable != null) {
                navigatable.navigate(true);
            }
            return true;
        }
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            RunnerAndConfigurationSettings settings = runManager.findSettings(configuration);
            if (environment == null || !environment.containsKey(envVarName) || settings == null || !RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)("Edit Run/Debug Configuration: '" + settings.getName() + "'"))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Map<String, String> getEnvironment(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(8);
        }
        if (configuration instanceof CommonProgramRunConfigurationParameters) {
            return ((CommonProgramRunConfigurationParameters)configuration).getEnvs();
        }
        if (configuration instanceof NpmRunConfiguration) {
            return ((NpmRunConfiguration)configuration).getRunSettings().getEnvData().getEnvs();
        }
        return null;
    }

    @NotNull
    public static NodeEnvironmentVariablesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(9);
        }
        NodeEnvironmentVariablesProvider nodeEnvironmentVariablesProvider = (NodeEnvironmentVariablesProvider)ServiceManager.getService((Project)project, NodeEnvironmentVariablesProvider.class);
        if (nodeEnvironmentVariablesProvider == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(10);
        }
        return nodeEnvironmentVariablesProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommonEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onRunConfigurationChanged";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnvMerger {
        private final Set<String> myEnvNames;
        private final LinkedHashMap<String, String> myOrderedEnvs = new LinkedHashMap();

        private EnvMerger() {
            this.myEnvNames = new THashSet((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        private void addEnvsIfAbsent(@NotNull Map<String, String> envs) {
            if (envs == null) {
                EnvMerger.$$$reportNull$$$0(0);
            }
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                if (!this.myEnvNames.add(entry.getKey())) continue;
                this.myOrderedEnvs.put(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$EnvMerger", "addEnvsIfAbsent"));
        }
    }
}

