/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.javascript.nodejs.codeInsight.NodeFrameworkIndexingHandler;
import com.intellij.javascript.nodejs.env.NodeEnvironmentVariablesProvider;
import com.intellij.lang.javascript.documentation.JavaScriptDocumentationProvider;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeProcessEnvDocumentationProvider
extends JavaScriptDocumentationProvider {
    @Override
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return NodeProcessEnvDocumentationProvider.generateInfoByReferenceElement(originalElement);
    }

    @Override
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof MyFakeCompletionElement) {
            VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
            return NodeProcessEnvDocumentationProvider.generateInfo(element.getProject(), ((MyFakeCompletionElement)element).myEnvName, contextFile);
        }
        return NodeProcessEnvDocumentationProvider.generateInfoByReferenceElement(originalElement);
    }

    @Override
    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (NodeProcessEnvDocumentationProvider.getEnvName(element) != null) {
            String envName;
            if (object instanceof SmartPsiElementPointer) {
                object = ((SmartPsiElementPointer)object).getElement();
            }
            if (object instanceof JSImplicitElement && (envName = ((JSImplicitElement)object).getName()) != null) {
                return new MyFakeCompletionElement(element, envName);
            }
        }
        return null;
    }

    @Nullable
    private static String getEnvName(@Nullable PsiElement element) {
        JSReferenceExpression env;
        if (element == null) {
            return null;
        }
        if (element instanceof LeafPsiElement) {
            element = element.getParent();
        }
        if ((env = (JSReferenceExpression)ObjectUtils.tryCast((Object)element, JSReferenceExpression.class)) != null && NodeFrameworkIndexingHandler.isProcessEnv((JSReferenceExpression)ObjectUtils.tryCast((Object)env.getQualifier(), JSReferenceExpression.class))) {
            return env.getReferenceName();
        }
        return null;
    }

    @Nullable
    private static String generateInfoByReferenceElement(@Nullable PsiElement originalElement) {
        String envName = NodeProcessEnvDocumentationProvider.getEnvName(originalElement);
        if (originalElement != null && envName != null) {
            return NodeProcessEnvDocumentationProvider.generateInfo(originalElement.getProject(), envName, PsiUtilCore.getVirtualFile((PsiElement)originalElement));
        }
        return null;
    }

    @Nullable
    private static String generateInfo(@NotNull Project project, @NotNull String envName, @Nullable VirtualFile contextFile) {
        if (project == null) {
            NodeProcessEnvDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (envName == null) {
            NodeProcessEnvDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)envName)) {
            return null;
        }
        NodeEnvironmentVariablesProvider envProvider = NodeEnvironmentVariablesProvider.getInstance(project);
        Map<String, String> environment = envProvider.getEnvironment(contextFile);
        if (!environment.containsKey(envName)) {
            return envName + " is undefined";
        }
        String envValue = environment.get(envName);
        if (StringUtil.isEmpty((String)envValue)) {
            return envName + " is empty";
        }
        return envName + " = " + envValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "envName";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/nodejs/documentation/NodeProcessEnvDocumentationProvider";
        objectArray[2] = "generateInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFakeCompletionElement
    extends FakePsiElement {
        private final PsiElement myParent;
        private final String myEnvName;

        private MyFakeCompletionElement(@NotNull PsiElement parent, @NotNull String envName) {
            if (parent == null) {
                MyFakeCompletionElement.$$$reportNull$$$0(0);
            }
            if (envName == null) {
                MyFakeCompletionElement.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myEnvName = envName;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/documentation/NodeProcessEnvDocumentationProvider$MyFakeCompletionElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

