/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;

public final class NodeCommandLineUtil {
    public static final String INSPECT = "--inspect";
    public static final String INSPECT_BRK = "--inspect-brk";
    public static final String INSPECT_EQ = "--inspect=";
    public static final String INSPECT_BRK_EQ = "--inspect-brk=";
    public static final String DEBUG = "--debug";
    public static final String DEBUG_BRK = "--debug-brk";
    public static final String DEBUG_EQ = "--debug=";
    public static final String DEBUG_BRK_EQ = "--debug-brk=";
    public static final String EXPOSE_DEBUG_AS_V8DEBUG = "--expose_debug_as=v8debug";
    private static final Key<Boolean> USE_WIP_CONNECTION = Key.create((String)"USE_WIP_CONNECTION");
    private static final Key<Boolean> USE_TERMINAL_CONSOLE = Key.create((String)"USE_TERMINAL_CONSOLE");
    private static final Pattern DEBUG_PORT_PATTERN = Pattern.compile("(?:" + StringUtil.join((Collection)ContainerUtil.newArrayList((Object[])new String[]{"--inspect=", "--inspect-brk=", "--debug=", "--debug-brk="}), (String)"|") + ")(?:\\S+:)?(\\d+)");
    private static final String PATH = "PATH";

    private NodeCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(0);
        }
        return NodeCommandLineUtil.execute(commandLine, null, timeoutMillis);
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator indicator, long timeoutMillis) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(1);
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        KillableColoredProcessHandler processHandler = NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, false);
        processHandler.setShouldDestroyProcessRecursively(true);
        processHandler.setShouldKillProcessSoftly(true);
        ProcessOutputCatcher outputCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        ProcessOutput processOutput = outputCatcher.run(indicator, timeoutMillis);
        if (processOutput == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    @NotNull
    public static KillableColoredProcessHandler createKillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(3);
        }
        return NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, withSoftKillOnWindows, UnaryOperator.identity());
    }

    @NotNull
    private static KillableColoredProcessHandler createKillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows, final @NotNull UnaryOperator<String> messagesFilter) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(4);
        }
        if (messagesFilter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(5);
        }
        final boolean wsl = WslCommandLineConfigurator.isWslConfigured(commandLine);
        KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine, false){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = (String)messagesFilter.apply(text)) != null) {
                    super.coloredTextAvailable(text, attributes);
                }
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = wsl ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.forMostlySilentProcess();
                if (options == null) {
                    1.$$$reportNull$$$0(2);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributes";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/NodeCommandLineUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readerOptions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "coloredTextAvailable";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        handler.setShouldKillProcessSoftlyWithWinP(withSoftKillOnWindows && !wsl);
        if (wsl) {
            WSLUtil.addInputCloseListener((ProcessHandler)handler);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = handler;
        if (killableColoredProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(6);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public static CapturingProcessHandler createCapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(7);
        }
        final boolean wsl = WslCommandLineConfigurator.isWslConfigured(commandLine);
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = wsl ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.forMostlySilentProcess();
                if (options == null) {
                    2.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil$2", "readerOptions"));
            }
        };
        if (wsl) {
            WSLUtil.addInputCloseListener((ProcessHandler)handler);
        }
        CapturingProcessHandler capturingProcessHandler = handler;
        if (capturingProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(8);
        }
        return capturingProcessHandler;
    }

    public static void configureUsefulEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(9);
        }
        if (!(commandLine instanceof PtyCommandLine)) {
            Map env = commandLine.getEnvironment();
            env.putIfAbsent("DEBUG_COLORS", "true");
            env.putIfAbsent("COLORTERM", "true");
            env.putIfAbsent("FORCE_COLOR", "true");
            env.putIfAbsent("npm_config_color", "always");
            env.putIfAbsent("MOCHA_COLORS", "1");
        }
    }

    @Deprecated
    public static void addDebugParameters(@NotNull GeneralCommandLine commandLine, int debugPort) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(10);
        }
        if (debugPort > 0) {
            commandLine.addParameter(DEBUG_BRK_EQ + debugPort);
            commandLine.addParameter(EXPOSE_DEBUG_AS_V8DEBUG);
        }
    }

    @Deprecated
    public static void addNodeOptions(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(11);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(13);
        }
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptions, debugPort, true, interpreter, preferWipProtocol);
    }

    public static void addNodeOptionsForDebugging(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) throws com.intellij.execution.ExecutionException {
        List<String> transformedOptions;
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(14);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(15);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(16);
        }
        NodeCommandLineUtil.useInspectorProtocol(commandLine, NodeCommandLineUtil.indexOfInspectOption(transformedOptions = NodeCommandLineUtil.transformNodeOptionsForDebugging(nodeOptions, debugPort, breakAtStartOfUserScript, interpreter, preferWipProtocol)) != -1);
        commandLine.addParameters(transformedOptions);
    }

    public static int indexOfInspectOption(@NotNull List<String> options) {
        if (options == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(17);
        }
        return ContainerUtil.indexOf(options, NodeCommandLineUtil::isInspectOption);
    }

    public static boolean shouldUseInspectorProtocol(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(18);
        }
        return Boolean.TRUE.equals(commandLine.getUserData(USE_WIP_CONNECTION));
    }

    public static void useInspectorProtocol(@NotNull GeneralCommandLine commandLine, boolean useInspectorProtocol) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(19);
        }
        commandLine.putUserData(USE_WIP_CONNECTION, (Object)useInspectorProtocol);
    }

    @NotNull
    private static List<String> transformNodeOptionsForDebugging(@NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferInspectorProtocol) throws com.intellij.execution.ExecutionException {
        boolean useInspectorProtocol;
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(20);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(21);
        }
        if (debugPort == -1) {
            List<String> list2 = nodeOptions;
            if (list2 == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(22);
            }
            return list2;
        }
        boolean hasInspectOption = false;
        boolean hasV8DebugOption = false;
        ArrayList<String> resultOptions = new ArrayList<String>();
        for (String option : nodeOptions) {
            boolean isInspectOption = NodeCommandLineUtil.isInspectOption(option);
            hasInspectOption |= isInspectOption;
            boolean isV8DebugOption = NodeCommandLineUtil.isV8DebugOption(option);
            hasV8DebugOption |= isV8DebugOption;
            if (option == null || isInspectOption || isV8DebugOption) continue;
            resultOptions.add(option);
        }
        SemVer version = null;
        if (hasInspectOption) {
            useInspectorProtocol = true;
        } else if (hasV8DebugOption) {
            useInspectorProtocol = false;
        } else {
            if (NodeCommandLineUtil.shouldUseInspectorProtocolRegardlessOfVersion(interpreter)) {
                version = interpreter instanceof NodeJsRemoteInterpreter ? new SemVer("7.0.0", 7, 0, 0) : new SemVer("8.0.0", 8, 0, 0);
            } else {
                Promise<SemVer> versionPromise = interpreter.provideCachedVersionOrFetch();
                try {
                    version = (SemVer)versionPromise.blockingGet(1500, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new com.intellij.execution.ExecutionException(e.getCause());
                }
                catch (TimeoutException e) {
                    throw new com.intellij.execution.ExecutionException((Throwable)e);
                }
            }
            boolean bl = version == null ? preferInspectorProtocol : (useInspectorProtocol = version.getMajor() >= 8 || version.getMajor() >= 7 && preferInspectorProtocol);
        }
        if (useInspectorProtocol) {
            if (breakAtStartOfUserScript) {
                if (version == null || version.isGreaterOrEqualThan(7, 6, 0)) {
                    resultOptions.add(INSPECT_BRK_EQ + debugPort);
                } else {
                    resultOptions.add(INSPECT_EQ + debugPort);
                    resultOptions.add(DEBUG_BRK);
                }
            } else {
                resultOptions.add(INSPECT_EQ + debugPort);
            }
        } else {
            resultOptions.add((breakAtStartOfUserScript ? DEBUG_BRK_EQ : DEBUG_EQ) + debugPort);
            resultOptions.add(EXPOSE_DEBUG_AS_V8DEBUG);
        }
        ArrayList<String> arrayList = resultOptions;
        if (arrayList == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    public static Vm initRemoteVmConnectionSync(@NotNull RemoteVmConnection<?> connection, int debugPort) throws com.intellij.execution.ExecutionException {
        Vm vm;
        if (connection == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(24);
        }
        InetAddress addr = NodeCommandLineUtil.getNodeLoopbackAddress();
        InetSocketAddress address = new InetSocketAddress(addr, debugPort);
        try {
            Promise vmPromise = connection.open(address);
            vm = (Vm)Objects.requireNonNull(vmPromise.blockingGet(30, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new com.intellij.execution.ExecutionException("Cannot connect to VM " + address, (Throwable)e);
        }
        if (vm == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(25);
        }
        return vm;
    }

    @NotNull
    public static InetAddress getNodeLoopbackAddress() throws com.intellij.execution.ExecutionException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new com.intellij.execution.ExecutionException("Cannot get 127.0.0.1 IPv4", (Throwable)e);
        }
        if (inetAddress == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(26);
        }
        return inetAddress;
    }

    private static boolean shouldUseInspectorProtocolRegardlessOfVersion(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(27);
        }
        return interpreter instanceof NodeJsRemoteInterpreter || interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron();
    }

    private static boolean isInspectOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(INSPECT) || option.equals(INSPECT_BRK) || option.startsWith(INSPECT_EQ) || option.startsWith(INSPECT_BRK_EQ);
    }

    private static boolean isV8DebugOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(DEBUG) || option.equals(DEBUG_BRK) || option.startsWith(DEBUG_EQ) || option.startsWith(DEBUG_BRK_EQ);
    }

    @NotNull
    public static OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(28);
        }
        return NodeCommandLineUtil.createProcessHandler(commandLine, withSoftKillOnWindows, null);
    }

    @NotNull
    public static OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows, @Nullable CommandLineDebugConfigurator configurator) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(29);
        }
        UnaryOperator<String> messagesFilter = configurator != null ? configurator.createMessagesFilter() : UnaryOperator.identity();
        Object handler = NodeCommandLineUtil.isTerminalCommandLine(commandLine) ? NodeCommandLineUtil.createTerminalProcessHandler(commandLine, messagesFilter) : NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, withSoftKillOnWindows, messagesFilter);
        NodeCommandLineUtil.transferUseInspectorProtocol(commandLine, (ProcessHandler)handler);
        OSProcessHandler oSProcessHandler = handler;
        if (oSProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(30);
        }
        return oSProcessHandler;
    }

    public static void transferUseInspectorProtocol(@NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler createdProcessHandler) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(31);
        }
        if (createdProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(32);
        }
        createdProcessHandler.putUserData(USE_WIP_CONNECTION, (Object)NodeCommandLineUtil.shouldUseInspectorProtocol(commandLine));
    }

    @NotNull
    private static OSProcessHandler createTerminalProcessHandler(@NotNull GeneralCommandLine commandLine, final @NotNull UnaryOperator<String> messagesFilter) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(33);
        }
        if (messagesFilter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(34);
        }
        KillableProcessHandler processHandler = new KillableProcessHandler(commandLine){

            public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                String filteredText;
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((filteredText = (String)messagesFilter.apply(text)) != null) {
                    super.notifyTextAvailable(filteredText, outputType);
                }
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil$3";
                objectArray[2] = "notifyTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.setShouldKillProcessSoftlyWithWinP(true);
        processHandler.putUserData(USE_TERMINAL_CONSOLE, (Object)true);
        KillableProcessHandler killableProcessHandler = processHandler;
        if (killableProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(35);
        }
        return killableProcessHandler;
    }

    public static boolean shouldUseTerminalConsole(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(36);
        }
        return USE_TERMINAL_CONSOLE.get((UserDataHolder)processHandler) == Boolean.TRUE && TerminalExecutionConsole.isAcceptable((ProcessHandler)processHandler);
    }

    @NotNull
    public static ConsoleView createConsole(@NotNull ProcessHandler processHandler, @NotNull Project project, boolean readOnly) {
        if (processHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(37);
        }
        if (project == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(38);
        }
        if (NodeCommandLineUtil.shouldUseTerminalConsole(processHandler)) {
            return new TerminalExecutionConsole(project, processHandler);
        }
        return new ConsoleViewImpl(project, GlobalSearchScope.allScope((Project)project), readOnly, true);
    }

    public static boolean shouldUseWipConnection(@Nullable ProcessHandler processHandler) {
        return processHandler != null && Boolean.TRUE.equals(processHandler.getUserData(USE_WIP_CONNECTION));
    }

    public static String formatErrorMessage(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(39);
        }
        if (output == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(40);
        }
        StringBuilder buf = new StringBuilder(commandLine.getCommandLineString());
        if (output.getStderr().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard error:\n").append(output.getStderr());
        }
        if (output.getStdout().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard output:\n").append(output.getStdout());
        }
        buf.append("\n\n");
        buf.append(IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{output.getExitCode()}));
        return buf.toString();
    }

    @NotNull
    public static GeneralCommandLine createCommandLine() {
        return NodeCommandLineUtil.createCommandLine(null);
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@Nullable Boolean usePtyWithTerminalConsole) {
        if (usePtyWithTerminalConsole == Boolean.TRUE || usePtyWithTerminalConsole == null && Registry.is((String)"nodejs.console.use.terminal")) {
            PtyCommandLine commandLine = new PtyCommandLine();
            if (!SystemInfo.isWindows) {
                commandLine.getEnvironment().put("TERM", "xterm-256color");
            }
            commandLine.withConsoleMode(false);
            commandLine.withInitialColumns(120);
            commandLine.putUserData(USE_TERMINAL_CONSOLE, (Object)true);
            PtyCommandLine ptyCommandLine = commandLine;
            if (ptyCommandLine == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(41);
            }
            return ptyCommandLine;
        }
        return new GeneralCommandLine();
    }

    public static boolean isTerminalCommandLine(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(42);
        }
        return commandLine instanceof PtyCommandLine && USE_TERMINAL_CONSOLE.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public static void configureCommandLine(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator, @NotNull ThrowableConsumer<? super Boolean, ? extends com.intellij.execution.ExecutionException> commandLineConfigurator) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(43);
        }
        if (commandLineConfigurator == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(44);
        }
        if (configurator != null) {
            configurator.beforeBaseConfiguring(commandLine);
        }
        commandLineConfigurator.consume((Object)(configurator != null ? 1 : 0));
        if (configurator != null) {
            configurator.afterBaseConfiguring(commandLine);
        }
    }

    public static int findDebugPort(@Nullable String nodeOptions) {
        if (StringUtil.isEmpty((String)nodeOptions)) {
            return -1;
        }
        Matcher matcher = DEBUG_PORT_PATTERN.matcher(nodeOptions);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                Logger.getInstance(NodeCommandLineUtil.class).warn("Invalid debug port specified: " + nodeOptions);
            }
        }
        return -1;
    }

    public static void prependNodeDirToPATH(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter) {
        String path;
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(45);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(46);
        }
        if (!SystemInfo.isLinux) {
            return;
        }
        if (commandLine.getEnvironment().containsKey(PATH)) {
            return;
        }
        if (!(interpreter instanceof NodeJsLocalInterpreter)) {
            return;
        }
        String nodePath = ((NodeJsLocalInterpreter)interpreter).getInterpreterSystemIndependentPath();
        if (NodeCommandLineUtil.shouldPrependNodeDirToPATH(nodePath) && (path = EnvironmentUtil.getValue((String)PATH)) != null) {
            String nodeDir = PathUtil.getParentPath((String)nodePath);
            String separator = SystemInfo.isWindows ? ";" : ":";
            commandLine.getEnvironment().put(PATH, nodeDir + separator + StringUtil.trimStart((String)path, (String)separator));
        }
    }

    private static boolean shouldPrependNodeDirToPATH(@NotNull String nodePath) {
        String nodeFileName;
        File nodeFile;
        if (nodePath == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(47);
        }
        File file2 = nodeFile = (nodeFileName = PathUtil.getFileName((String)nodePath)).isEmpty() ? null : PathEnvironmentVariableUtil.findInPath((String)nodeFileName);
        if (nodeFile == null) {
            return true;
        }
        if (FileUtil.toSystemIndependentName((String)nodeFile.getAbsolutePath()).equals(FileUtil.toSystemIndependentName((String)nodePath))) {
            return false;
        }
        try {
            File canonicalFile1 = nodeFile.getCanonicalFile();
            File canonicalFile2 = new File(nodePath).getCanonicalFile();
            return !canonicalFile1.getAbsolutePath().equals(canonicalFile2.getAbsolutePath());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 5: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesFilter";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 13: 
            case 16: 
            case 21: 
            case 27: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdProcessHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineConfigurator";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createKillableColoredProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapturingProcessHandler";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "transformNodeOptionsForDebugging";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "initRemoteVmConnectionSync";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLoopbackAddress";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalProcessHandler";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 41: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createKillableColoredProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCapturingProcessHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureUsefulEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDebugParameters";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptions";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptionsForDebugging";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indexOfInspectOption";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocol";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "useInspectorProtocol";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "transformNodeOptionsForDebugging";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initRemoteVmConnectionSync";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocolRegardlessOfVersion";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "transferUseInspectorProtocol";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalProcessHandler";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseTerminalConsole";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isTerminalCommandLine";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "prependNodeDirToPATH";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "shouldPrependNodeDirToPATH";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 35: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

