/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.P4File;

public final class FStat {
    private static final Logger LOG = Logger.getInstance(FStat.class);
    public Status status = STATUS_UNKNOWN;
    public Local local = LOCAL_NOT_LOCAL;
    public static final Status STATUS_UNKNOWN = Status.UNKNOWN;
    public static final Status STATUS_NOT_IN_CLIENTSPEC = Status.NOT_IN_CLIENTSPEC;
    public static final Status STATUS_NOT_ADDED = Status.NOT_ADDED;
    public static final Status STATUS_ONLY_ON_SERVER = Status.ONLY_ON_SERVER;
    public static final Status STATUS_ON_SERVER_AND_LOCAL = Status.ON_SERVER_AND_LOCAL;
    public static final Status STATUS_ONLY_LOCAL = Status.ONLY_LOCAL;
    public static final Status STATUS_DELETED = Status.DELETED;
    public static final Local LOCAL_NOT_LOCAL = Local.NOT_LOCAL;
    public static final Local LOCAL_CHECKED_IN = Local.CHECKED_IN;
    public static final Local LOCAL_CHECKED_OUT = Local.CHECKED_OUT;
    public static final Local LOCAL_ADDING = Local.ADDING;
    public static final Local LOCAL_BRANCHING = Local.BRANCHING;
    public static final Local LOCAL_DELETING = Local.DELETING;
    public static final Local LOCAL_INTEGRATING = Local.INTEGRATING;
    public static final Local LOCAL_MOVE_ADDING = Local.MOVE_ADDING;
    public static final Local LOCAL_MOVE_DELETING = Local.MOVE_DELETING;
    public long statTime = System.currentTimeMillis();
    @Nullable
    public String movedFile = "";
    @NonNls
    public String clientFile = "";
    @NonNls
    public String depotFile = "";
    @NonNls
    public String headAction = "";
    @NonNls
    public String headChange = "";
    @NonNls
    public String headRev = "";
    @NonNls
    public String headType = "";
    @NonNls
    public String headTime = "";
    @NonNls
    public String haveRev = "";
    @NonNls
    public String action = "";
    @NonNls
    public String actionOwner = "";
    @NonNls
    public String change = "";
    @NonNls
    public String unresolved = null;
    public P4File fromFile = null;
    @NonNls
    static final String MOVED_FILE_STATUS_FIELD = "movedFile";
    @NonNls
    static final String CLIENT_FILE_STATUS_FIELD = "clientFile ";
    @NonNls
    static final String DEPOT_FILE_STATUS_FIELD = "depotFile ";
    @NonNls
    static final String HEAD_ACTION_STATUS_FIELD = "headAction ";
    @NonNls
    static final String HEAD_CHANGE_STATUS_FIELD = "headChange ";
    @NonNls
    static final String HEAD_REV_STATUS_FIELD = "headRev ";
    @NonNls
    static final String HEAD_TYPE_STATUS_FIELD = "headType ";
    @NonNls
    static final String HEAD_TIME_STATUS_FIELD = "headTime ";
    @NonNls
    static final String HAVE_REV_STATUS_FIELD = "haveRev ";
    @NonNls
    static final String ACTION_STATUS_FIELD = "action ";
    @NonNls
    static final String ACTION_OWNER_STATUS_FIELD = "actionOwner ";
    @NonNls
    static final String CHANGE_STATUS_FIELD = "change ";
    @NonNls
    static final String UNRESOLVED_STATUS_FIELD = "unresolved ";

    @NonNls
    public final String toString() {
        return "org.jetbrains.idea.perforce.perforce.FStat{status=" + (Object)((Object)this.status) + ", local=" + (Object)((Object)this.local) + ", statTime=" + this.statTime + ", \nclientFile='" + this.clientFile + "', \ndepotFile='" + this.depotFile + "', \nheadAction='" + this.headAction + "', headChange='" + this.headChange + "', headRev='" + this.headRev + "', headType='" + this.headType + "', headTime='" + this.headTime + "', haveRev='" + this.haveRev + "', \naction='" + this.action + "', actionOwner='" + this.actionOwner + "', change='" + this.change + "', unresolved='" + this.unresolved + "', branchedFrom='" + this.fromFile + "'}";
    }

    private void resolveStatus() throws VcsException {
        if (this.headRev.length() > 0 && this.haveRev.length() == 0) {
            this.local = LOCAL_NOT_LOCAL;
            this.status = this.headAction.equals("delete") ? STATUS_DELETED : STATUS_ONLY_ON_SERVER;
        } else {
            this.status = this.headRev.length() == 0 ? STATUS_ONLY_LOCAL : STATUS_ON_SERVER_AND_LOCAL;
        }
        if (this.action.length() == 0) {
            this.local = LOCAL_CHECKED_IN;
        } else if ("add".equals(this.action)) {
            this.local = LOCAL_ADDING;
        } else if ("edit".equals(this.action)) {
            this.local = LOCAL_CHECKED_OUT;
        } else if ("branch".equals(this.action)) {
            this.local = LOCAL_BRANCHING;
        } else if ("integrate".equals(this.action)) {
            this.local = LOCAL_INTEGRATING;
        } else if ("delete".equals(this.action)) {
            this.local = LOCAL_DELETING;
        } else if ("move/delete".equals(this.action)) {
            this.local = LOCAL_MOVE_DELETING;
        } else if ("move/add".equals(this.action)) {
            this.local = LOCAL_MOVE_ADDING;
        } else {
            throw new VcsException(PerforceBundle.message((String)"exception.text.unknown.action", (Object[])new Object[]{this.action}));
        }
    }

    static FStat parseFStat(BufferedReader rdr) throws VcsException {
        FStat result = null;
        try {
            String s;
            while ((s = rdr.readLine()) != null && s.length() != 0) {
                String line;
                if (s.indexOf("... ") != 0) {
                    throw new VcsException(PerforceBundle.message((String)"exception.text.unexpected.fstat.line.syntax", (Object[])new Object[]{s}));
                }
                if (result == null) {
                    result = new FStat();
                }
                if ((line = s.substring(4)).startsWith(CLIENT_FILE_STATUS_FIELD)) {
                    result.clientFile = line.substring(11);
                    continue;
                }
                if (line.startsWith(DEPOT_FILE_STATUS_FIELD)) {
                    result.depotFile = line.substring(10);
                    continue;
                }
                if (line.startsWith(HEAD_ACTION_STATUS_FIELD)) {
                    result.headAction = line.substring(11);
                    continue;
                }
                if (line.startsWith(HEAD_CHANGE_STATUS_FIELD)) {
                    result.headChange = line.substring(11);
                    continue;
                }
                if (line.startsWith(HEAD_REV_STATUS_FIELD)) {
                    result.headRev = line.substring(8);
                    continue;
                }
                if (line.startsWith(HEAD_TYPE_STATUS_FIELD)) {
                    result.headType = line.substring(9);
                    continue;
                }
                if (line.startsWith(HEAD_TIME_STATUS_FIELD)) {
                    result.headTime = line.substring(9);
                    continue;
                }
                if (line.startsWith(HAVE_REV_STATUS_FIELD)) {
                    result.haveRev = line.substring(8);
                    continue;
                }
                if (line.startsWith(ACTION_STATUS_FIELD)) {
                    result.action = line.substring(7);
                    continue;
                }
                if (line.startsWith(ACTION_OWNER_STATUS_FIELD)) {
                    result.actionOwner = line.substring(12);
                    continue;
                }
                if (line.startsWith(CHANGE_STATUS_FIELD)) {
                    result.change = line.substring(7);
                    continue;
                }
                if (line.startsWith(UNRESOLVED_STATUS_FIELD)) {
                    result.unresolved = line.substring(11);
                    continue;
                }
                if (line.startsWith(MOVED_FILE_STATUS_FIELD)) {
                    result.movedFile = line.substring(10);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unparsed fstat field: \"" + s + "\"");
            }
        }
        catch (IOException ex) {
            throw new VcsException(PerforceBundle.message((String)"exception.text.cannot.parse.fstat.stdout", (Object[])new Object[0]));
        }
        if (result != null) {
            super.resolveStatus();
        }
        return result;
    }

    public static Map<File, String> splitOutputForEachFile(String stdOut) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(stdOut));
        File file = null;
        StringBuffer currentBuffer = new StringBuffer();
        HashMap<File, String> result = new HashMap<File, String>();
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) {
                if (file == null) continue;
                result.put(file, currentBuffer.toString());
                currentBuffer = new StringBuffer();
                file = null;
                continue;
            }
            currentBuffer.append(line);
            if (line.startsWith("... clientFile ")) {
                file = new File(line.substring("... clientFile ".length()).trim());
            }
            currentBuffer.append("\n");
        }
        if (file != null) {
            result.put(file, currentBuffer.toString());
        }
        return result;
    }

    public boolean isOpenedOrAdded() {
        return LOCAL_CHECKED_OUT == this.local || LOCAL_ADDING == this.local || LOCAL_BRANCHING == this.local || LOCAL_INTEGRATING == this.local || LOCAL_MOVE_ADDING == this.local;
    }

    public static enum Local {
        NOT_LOCAL,
        CHECKED_IN,
        CHECKED_OUT,
        ADDING,
        BRANCHING,
        DELETING,
        INTEGRATING,
        MOVE_ADDING,
        MOVE_DELETING;

    }

    public static enum Status {
        UNKNOWN,
        NOT_IN_CLIENTSPEC,
        NOT_ADDED,
        ONLY_ON_SERVER,
        ON_SERVER_AND_LOCAL,
        ONLY_LOCAL,
        DELETED;

    }
}

