/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ResolveAction;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ResolveAllAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ResolveAllAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        AbstractVcs[] allActiveVcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        boolean found = false;
        for (AbstractVcs vcs : allActiveVcss) {
            if (!"Perforce".equals(vcs.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        PerforceSettings settings = PerforceSettings.getSettings(project);
        if (!settings.ENABLED) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        presentation.setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        PerforceSettings settings;
        if (e == null) {
            ResolveAllAction.$$$reportNull$$$0(1);
        }
        if (!ResolveAction.serverSupportsConflictsResolve(settings = PerforceSettings.getSettings(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT)), settings.getAllConnections())) {
            Messages.showErrorDialog((Project)project, (String)PerforceBundle.message((String)"message.server.cant.resolve.conflicts", (Object[])new Object[0]), (String)PerforceBundle.message((String)"message.title.resolve", (Object[])new Object[0]));
            return;
        }
        try {
            final ArrayList<VirtualFile> filesToResolveUnderProject = new ArrayList<VirtualFile>();
            final PerforceVcs vcs = PerforceVcs.getInstance(project);
            final PerforceRunner runner = PerforceRunner.getInstance(project);
            final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

                public void run() throws VcsException {
                    Collection<Pair<P4Connection, Collection<VirtualFile>>> rootsByConnections = vcs.getRootsByConnections();
                    for (Pair<P4Connection, Collection<VirtualFile>> pair : rootsByConnections) {
                        for (VirtualFile root : (Collection)pair.getSecond()) {
                            for (VirtualFile file : runner.getResolvedWithConflicts((P4Connection)pair.getFirst(), root)) {
                                if (vcsManager.getVcsFor(file) != vcs) continue;
                                filesToResolveUnderProject.add(file);
                            }
                        }
                    }
                }
            }, (String)PerforceBundle.message((String)"message.searching.for.files.to.resolve", (Object[])new Object[0]), (boolean)false, (Project)project);
            if (filesToResolveUnderProject.size() == 0) {
                Messages.showInfoMessage((String)PerforceBundle.message((String)"message.text.no.files.to.resolve", (Object[])new Object[0]), (String)PerforceBundle.message((String)"message.title.resolve", (Object[])new Object[0]));
            } else {
                new PerforceMergeProvider(project).showMergeDialog(filesToResolveUnderProject);
            }
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)e1.getLocalizedMessage(), (String)PerforceBundle.message((String)"message.title.resolve", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/perforce/actions/ResolveAllAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

