/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.javascript.debugger.locationResolving.JSLocationResolver;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "", "()V", "dropCache", "", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "getFileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getPreloadedSourceMapList", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Companion", "intellij.javascript.debugger"})
public final class JSLocationResolver {
    private static final Key<CachedValue<PreloadedSourceMapList>> PRELOADED_SOURCE_MAP_LIST_KEY;
    private static final Key<CachedValue<JSFileUrlMappings>> FILE_URL_MAPPINGS_KEY;
    public static final Companion Companion;

    @NotNull
    public final PreloadedSourceMapList getPreloadedSourceMapList(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        RunProfile runProfile = xDebugSession.getRunProfile();
        if (!(runProfile instanceof UserDataHolder)) {
            return new PreloadedSourceMapList();
        }
        XDebugSession xDebugSession2 = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession2, (String)"debugProcess.session");
        Object object = CachedValuesManager.getManager((Project)xDebugSession2.getProject()).getCachedValue((UserDataHolder)runProfile, PRELOADED_SOURCE_MAP_LIST_KEY, (CachedValueProvider)getPreloadedSourceMapList.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getM\u2026TION_COUNT)\n    }, false)");
        return (PreloadedSourceMapList)object;
    }

    @NotNull
    public final JSFileUrlMappings getFileMappings(@NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        RunProfile runProfile = session.getRunProfile();
        if (!(runProfile instanceof UserDataHolder)) {
            return new JSFileUrlMappings();
        }
        Object object = CachedValuesManager.getManager((Project)session.getProject()).getCachedValue((UserDataHolder)runProfile, FILE_URL_MAPPINGS_KEY, (CachedValueProvider)getFileMappings.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getM\u2026TION_COUNT)\n    }, false)");
        return (JSFileUrlMappings)object;
    }

    public final void dropCache(@NotNull RunProfile runProfile) {
        Intrinsics.checkParameterIsNotNull((Object)runProfile, (String)"runProfile");
        if (runProfile instanceof UserDataHolder) {
            ((UserDataHolder)runProfile).putUserData(PRELOADED_SOURCE_MAP_LIST_KEY, null);
            ((UserDataHolder)runProfile).putUserData(FILE_URL_MAPPINGS_KEY, null);
        }
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"js.preloaded.source.map.list");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"js.preloaded.source.map.list\")");
        PRELOADED_SOURCE_MAP_LIST_KEY = key;
        Key key2 = Key.create((String)"js.file.url.mappings");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"js.file.url.mappings\")");
        FILE_URL_MAPPINGS_KEY = key2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver$Companion;", "", "()V", "FILE_URL_MAPPINGS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "PRELOADED_SOURCE_MAP_LIST_KEY", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "instance", "Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "getInstance", "()Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final JSLocationResolver getInstance() {
            Object object = ServiceManager.getService(JSLocationResolver.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026tionResolver::class.java)");
            return (JSLocationResolver)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

