/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.angularjs.AngularJSBundle;
import org.angularjs.codeInsight.AngularJSPluralCategories;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.parser.AngularJSMessageFormatParser;
import org.angularjs.lang.psi.AngularJSMessageFormatExpression;
import org.jetbrains.annotations.NotNull;

public class AngularMessageFormatCompletion {
    public static final Comparator<AngularJSPluralCategories> PLURAL_CATEGORIES_COMPARATOR = Comparator.comparingInt(AngularJSPluralCategories::getCompletionOrder);
    public static final InsertHandler<LookupElement> MESSAGE_FORMAT_KEYWORD_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            context.setAddCompletionChar(false);
            String string = item.getLookupString();
            int offset = context.getEditor().getCaretModel().getCurrentCaret().getOffset();
            String text = context.getDocument().getText(TextRange.create((int)offset, (int)Math.min(offset + 100, context.getDocument().getTextLength()))).trim();
            int idOffset = context.getStartOffset();
            if (idOffset > 0 && idOffset + 1 < context.getDocument().getTextLength() && "==".equals(context.getDocument().getText(TextRange.create((int)(idOffset - 1), (int)(idOffset + 1))))) {
                context.getDocument().deleteString(idOffset, idOffset + 1);
            }
            if (!text.startsWith("{")) {
                int diff = context.getSelectionEndOffset() - idOffset;
                EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" {}", (boolean)false, (int)(string.length() - diff + 2));
            }
            context.commitDocument();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/angularjs/codeInsight/AngularMessageFormatCompletion$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final LookupElementWeigher MESSAGE_FORMAT_KEYWORD_WEIGHER = new LookupElementWeigher("angular.message.format"){

        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (element.getObject() instanceof AngularJSPluralCategories) {
                return Integer.valueOf(((AngularJSPluralCategories)((Object)element.getObject())).getCompletionOrder());
            }
            if (element.getObject() instanceof String && ((String)element.getObject()).startsWith("=")) {
                try {
                    return Integer.valueOf(10 + Integer.parseInt(element.getObject().toString().substring(1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Integer.valueOf(Integer.MAX_VALUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/AngularMessageFormatCompletion$2", "weigh"));
        }
    };

    static boolean messageFormatCompletion(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement sibling;
        PsiElement[] children;
        PsiElement originalPosition = parameters.getOriginalPosition();
        if (originalPosition == null) {
            return false;
        }
        PsiElement parent = originalPosition.getParent();
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCommaExpression && (children = parent.getParent().getChildren()).length >= 2 && children[1] == parent) {
            AngularMessageFormatCompletion.messageFormatExtensions(result);
            return true;
        }
        if (parent instanceof AngularJSMessageFormatExpression) {
            AngularJSMessageFormatExpression amfe = (AngularJSMessageFormatExpression)parent;
            if (originalPosition == amfe.getExtensionTypeElement()) {
                AngularMessageFormatCompletion.messageFormatExtensions(result);
                return true;
            }
            if (originalPosition.getNode().getElementType() == AngularJSElementTypes.MESSAGE_FORMAT_SELECTION_KEYWORD) {
                AngularMessageFormatCompletion.messageFormatSelectionKeywords(((AngularJSMessageFormatExpression)parent).getExtensionType(), result);
                return true;
            }
            if (originalPosition.getNode().getElementType() == JSTokenTypes.WHITE_SPACE && (originalPosition.getNextSibling() != null && originalPosition.getNextSibling().getNode().getElementType() == AngularJSElementTypes.MESSAGE_FORMAT_SELECTION_KEYWORD || originalPosition.getPrevSibling() != null && originalPosition.getPrevSibling().getNode().getElementType() == JSTokenTypes.RBRACE)) {
                AngularMessageFormatCompletion.messageFormatSelectionKeywords(((AngularJSMessageFormatExpression)parent).getExtensionType(), result);
                return true;
            }
        }
        if ((sibling = originalPosition.getPrevSibling()) instanceof AngularJSMessageFormatExpression) {
            AngularMessageFormatCompletion.messageFormatSelectionKeywords(((AngularJSMessageFormatExpression)sibling).getExtensionType(), result);
        } else if (sibling instanceof JSExpressionStatement && sibling.getFirstChild() instanceof AngularJSMessageFormatExpression) {
            AngularMessageFormatCompletion.messageFormatSelectionKeywords(((AngularJSMessageFormatExpression)sibling.getFirstChild()).getExtensionType(), result);
        }
        return false;
    }

    private static void messageFormatSelectionKeywords(AngularJSMessageFormatParser.ExtensionType type, CompletionResultSet result) {
        CompletionResultSet set = result.withRelevanceSorter(CompletionSorter.emptySorter().weigh(MESSAGE_FORMAT_KEYWORD_WEIGHER));
        if (AngularJSMessageFormatParser.ExtensionType.plural.equals((Object)type)) {
            ArrayList<AngularJSPluralCategories> values = new ArrayList<AngularJSPluralCategories>(Arrays.asList(AngularJSPluralCategories.values()));
            Collections.sort(values, PLURAL_CATEGORIES_COMPARATOR);
            for (AngularJSPluralCategories category : values) {
                LookupElementBuilder element = LookupElementBuilder.create((Object)((Object)category)).withInsertHandler(MESSAGE_FORMAT_KEYWORD_INSERT_HANDLER);
                element = AngularJSPluralCategories.other.equals((Object)category) ? element.withTypeText(AngularJSBundle.message("angularjs.completion.type.default.selection.keyword", new Object[0]), true) : element.withTypeText(AngularJSBundle.message("angularjs.completion.type.plural.category", new Object[0]), true);
                set.addElement((LookupElement)element);
            }
            for (int i = 0; i < 4; ++i) {
                LookupElementBuilder element = LookupElementBuilder.create((String)("=" + i)).withInsertHandler(MESSAGE_FORMAT_KEYWORD_INSERT_HANDLER);
                set.addElement((LookupElement)element);
            }
        } else {
            set.addElement((LookupElement)LookupElementBuilder.create((String)"other").withTypeText(AngularJSBundle.message("angularjs.completion.type.default.selection.keyword", new Object[0]), true).withInsertHandler(MESSAGE_FORMAT_KEYWORD_INSERT_HANDLER));
        }
        set.stopHere();
    }

    private static void messageFormatExtensions(CompletionResultSet result) {
        for (AngularJSMessageFormatParser.ExtensionType type : AngularJSMessageFormatParser.ExtensionType.values()) {
            LookupElementBuilder elementBuilder = LookupElementBuilder.create((String)type.name()).withTypeText(AngularJSBundle.message("angularjs.completion.type.message.format.extension", new Object[0]), true);
            result.consume((LookupElement)elementBuilder);
        }
        result.stopHere();
    }
}

