/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Module;
import org.angular2.inspections.Angular2SourceEntityListValidator;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public abstract class AngularModuleConfigurationInspection
extends LocalInspectionTool {
    private final ProblemType myProblemType;

    protected AngularModuleConfigurationInspection(@NotNull ProblemType type) {
        if (type == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(0);
        }
        this.myProblemType = type;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitES6Decorator(ES6Decorator decorator) {
                AngularModuleConfigurationInspection.getValidationResults(decorator).registerProblems(AngularModuleConfigurationInspection.this.myProblemType, holder);
            }
        };
    }

    @NotNull
    public static Angular2SourceEntityListValidator.ValidationResults<ProblemType> getValidationResults(@NotNull ES6Decorator decorator) {
        if (decorator == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(2);
        }
        Angular2SourceEntityListValidator.ValidationResults validationResults = Angular2DecoratorUtil.isAngularEntityDecorator(decorator, "NgModule") ? (Angular2SourceEntityListValidator.ValidationResults)CachedValuesManager.getCachedValue((PsiElement)decorator, () -> CachedValueProvider.Result.create(AngularModuleConfigurationInspection.validate(decorator), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})) : Angular2SourceEntityListValidator.ValidationResults.empty();
        if (validationResults == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(3);
        }
        return validationResults;
    }

    @NotNull
    private static Angular2SourceEntityListValidator.ValidationResults<ProblemType> validate(@NotNull ES6Decorator decorator) {
        Angular2Module module;
        if (decorator == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(4);
        }
        if ((module = Angular2EntitiesProvider.getModule((PsiElement)decorator)) == null) {
            Angular2SourceEntityListValidator.ValidationResults<ProblemType> validationResults = Angular2SourceEntityListValidator.ValidationResults.empty();
            if (validationResults == null) {
                AngularModuleConfigurationInspection.$$$reportNull$$$0(5);
            }
            return validationResults;
        }
        Angular2SourceEntityListValidator.ValidationResults<ProblemType> results = new Angular2SourceEntityListValidator.ValidationResults<ProblemType>();
        Arrays.asList(new ImportsValidator(module), new DeclarationsValidator(), new ExportsValidator(module)).forEach(val -> val.validate(decorator, results));
        Angular2SourceEntityListValidator.ValidationResults<ProblemType> validationResults = results;
        if (validationResults == null) {
            AngularModuleConfigurationInspection.$$$reportNull$$$0(6);
        }
        return validationResults;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/AngularModuleConfigurationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/AngularModuleConfigurationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationResults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValidationResults";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExportsValidator
    extends ImportExportValidator<Angular2Entity> {
        protected ExportsValidator(@NotNull Angular2Module module) {
            if (module == null) {
                ExportsValidator.$$$reportNull$$$0(0);
            }
            super(Angular2Entity.class, "exports", module);
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                ExportsValidator.$$$reportNull$$$0(1);
            }
            this.registerProblem(ProblemType.ENTITY_WITH_MISMATCHED_TYPE, Angular2Bundle.message("angular.inspection.wrong-entity-type.message.not-entity", aClass.getName()), Objects.requireNonNull(this.myModule).isScopeFullyResolved() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }

        @Override
        protected void processEntity(@NotNull Angular2Entity entity) {
            if (entity == null) {
                ExportsValidator.$$$reportNull$$$0(2);
            }
            if (entity instanceof Angular2Module) {
                if (entity.equals(this.myModule)) {
                    this.registerProblem(ProblemType.RECURSIVE_IMPORT_EXPORT, Angular2Bundle.message("angular.inspection.cyclic-module-dependency.message.self-export", entity.getName()), new LocalQuickFix[0]);
                } else {
                    this.checkCyclicDependencies((Angular2Module)entity);
                }
            } else if (entity instanceof Angular2Declaration) {
                if (!Objects.requireNonNull(this.myModule).getDeclarationsInScope().contains(entity)) {
                    this.registerProblem(ProblemType.UNDECLARED_EXPORT, Angular2Bundle.message("angular.inspection.undefined-export.message", ObjectUtils.notNull((Object)ObjectUtils.doIfNotNull((Object)entity.getTypeScriptClass(), JSClass::getName), () -> entity.getName()), this.myModule.getName()), Objects.requireNonNull(this.myModule).isScopeFullyResolved() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            } else {
                throw new IllegalArgumentException(entity.getClass().getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entity";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/inspections/AngularModuleConfigurationInspection$ExportsValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNonEntityClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEntity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImportsValidator
    extends ImportExportValidator<Angular2Module> {
        private ImportsValidator(@NotNull Angular2Module module) {
            if (module == null) {
                ImportsValidator.$$$reportNull$$$0(0);
            }
            super(Angular2Module.class, "imports", module);
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                ImportsValidator.$$$reportNull$$$0(1);
            }
            this.registerProblem(ProblemType.ENTITY_WITH_MISMATCHED_TYPE, Angular2Bundle.message("angular.inspection.wrong-entity-type.message.not-a-module", aClass.getName()), new LocalQuickFix[0]);
        }

        @Override
        protected void processEntity(@NotNull Angular2Module module) {
            if (module == null) {
                ImportsValidator.$$$reportNull$$$0(2);
            }
            if (module.equals(this.myModule)) {
                this.registerProblem(ProblemType.RECURSIVE_IMPORT_EXPORT, Angular2Bundle.message("angular.inspection.cyclic-module-dependency.message.self-import", module.getName()), new LocalQuickFix[0]);
            } else {
                this.checkCyclicDependencies(module);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/inspections/AngularModuleConfigurationInspection$ImportsValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNonEntityClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEntity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ImportExportValidator<T extends Angular2Entity>
    extends Angular2SourceEntityListValidator<T, ProblemType> {
        protected final Angular2Module myModule;

        protected ImportExportValidator(@NotNull Class<T> entityClass, @NotNull String propertyName, @NotNull Angular2Module module) {
            if (entityClass == null) {
                ImportExportValidator.$$$reportNull$$$0(0);
            }
            if (propertyName == null) {
                ImportExportValidator.$$$reportNull$$$0(1);
            }
            if (module == null) {
                ImportExportValidator.$$$reportNull$$$0(2);
            }
            super(entityClass, propertyName);
            this.myModule = module;
        }

        protected void checkCyclicDependencies(@NotNull Angular2Module module) {
            if (module == null) {
                ImportExportValidator.$$$reportNull$$$0(3);
            }
            Stack cycleTrack = new Stack();
            HashSet<Angular2Module> processedModules = new HashSet<Angular2Module>();
            Stack dfsStack = new Stack();
            cycleTrack.push((Object)this.myModule);
            dfsStack.push((Object)ContainerUtil.newArrayList((Object[])new Angular2Module[]{module}));
            while (!dfsStack.isEmpty()) {
                List curNode = (List)dfsStack.peek();
                if (curNode.isEmpty()) {
                    dfsStack.pop();
                    cycleTrack.pop();
                    continue;
                }
                Angular2Module toProcess = (Angular2Module)curNode.remove(curNode.size() - 1);
                if (toProcess == this.myModule) {
                    cycleTrack.push((Object)this.myModule);
                    this.registerProblem(ProblemType.RECURSIVE_IMPORT_EXPORT, Angular2Bundle.message("angular.inspection.cyclic-module-dependency.message.cycle", StringUtil.join((Collection)cycleTrack, Angular2Entity::getName, (String)(" " + Angular2Bundle.message("angular.inspection.cyclic-module-dependency.message.separator", new Object[0]) + " "))), new LocalQuickFix[0]);
                    return;
                }
                if (!processedModules.add(toProcess)) continue;
                cycleTrack.push((Object)toProcess);
                ArrayList<Angular2Module> dependencies = new ArrayList<Angular2Module>();
                for (Angular2Entity child : toProcess.getExports()) {
                    if (!(child instanceof Angular2Module)) continue;
                    dependencies.add((Angular2Module)child);
                }
                dependencies.addAll(toProcess.getImports());
                dfsStack.push(dependencies);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entityClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "org/angular2/inspections/AngularModuleConfigurationInspection$ImportExportValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCyclicDependencies";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeclarationsValidator
    extends Angular2SourceEntityListValidator<Angular2Declaration, ProblemType> {
        protected DeclarationsValidator() {
            super(Angular2Declaration.class, "declarations");
        }

        @Override
        protected void processNonEntityClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                DeclarationsValidator.$$$reportNull$$$0(0);
            }
            this.registerProblem(ProblemType.ENTITY_WITH_MISMATCHED_TYPE, Angular2Bundle.message("angular.inspection.wrong-entity-type.message.not-declarable", aClass.getName()), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/angular2/inspections/AngularModuleConfigurationInspection$DeclarationsValidator", "processNonEntityClass"));
        }
    }

    protected static enum ProblemType {
        ENTITY_WITH_MISMATCHED_TYPE,
        RECURSIVE_IMPORT_EXPORT,
        UNDECLARED_EXPORT;

    }
}

