/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.source;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionCachingVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSFunctionNodesVisitor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.ivy.Angular2IvyUtil;
import org.angular2.entities.metadata.Angular2MetadataUtil;
import org.angular2.entities.metadata.psi.Angular2MetadataFunction;
import org.angular2.entities.metadata.psi.Angular2MetadataModule;
import org.angular2.entities.metadata.psi.Angular2MetadataObject;
import org.angular2.entities.metadata.psi.Angular2MetadataReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Angular2SourceEntityListProcessor<T extends Angular2Entity> {
    private final Class<T> myEntityClass;
    private final boolean myAcceptNgModuleWithProviders;
    private final JSElementVisitor myResultsVisitor;

    public Angular2SourceEntityListProcessor(@NotNull Class<T> entityClass) {
        if (entityClass == null) {
            Angular2SourceEntityListProcessor.$$$reportNull$$$0(0);
        }
        this.myResultsVisitor = new JSElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                Angular2Entity entity = Angular2SourceEntityListProcessor.this.getEntity(aClass);
                if (entity != null) {
                    Angular2SourceEntityListProcessor.this.processEntity(entity);
                } else {
                    Angular2SourceEntityListProcessor.this.processNonEntityClass(aClass);
                }
            }

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                Angular2SourceEntityListProcessor.this.resolveFunctionReturnType(node);
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                Angular2SourceEntityListProcessor.this.resolveFunctionReturnType((JSFunction)node);
            }

            public void visitJSElement(JSElement node) {
                Angular2SourceEntityListProcessor.this.processAnyElement(node);
            }
        };
        this.myEntityClass = entityClass;
        this.myAcceptNgModuleWithProviders = entityClass.isAssignableFrom(Angular2Module.class);
    }

    protected final List<PsiElement> resolve(PsiElement t) {
        SmartList result = new SmartList();
        t.accept((PsiElementVisitor)this.createResolveVisitor((SmartList<PsiElement>)result));
        return result;
    }

    private JSElementVisitor createResolveVisitor(final SmartList<PsiElement> result) {
        return new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                result.addAll(Arrays.asList(node.getExpressions()));
            }

            public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
                if (Angular2SourceEntityListProcessor.this.myAcceptNgModuleWithProviders) {
                    AstLoadingFilter.forceAllowTreeLoading((PsiFile)node.getContainingFile(), () -> ContainerUtil.addIfNotNull((Collection)result, (Object)ObjectUtils.doIfNotNull((Object)node.findProperty("ngModule"), JSProperty::getValue)));
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)node.resolve());
            }

            public void visitJSVariable(JSVariable node) {
                AstLoadingFilter.forceAllowTreeLoading((PsiFile)node.getContainingFile(), () -> ContainerUtil.addIfNotNull((Collection)result, (Object)node.getInitializer()));
            }

            public void visitJSProperty(JSProperty node) {
                AstLoadingFilter.forceAllowTreeLoading((PsiFile)node.getContainingFile(), () -> ContainerUtil.addIfNotNull((Collection)result, (Object)node.getValue()));
            }

            public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)specifierAlias.findAliasedElement());
            }

            public void visitJSSpreadExpression(JSSpreadExpression spreadExpression) {
                AstLoadingFilter.forceAllowTreeLoading((PsiFile)spreadExpression.getContainingFile(), () -> ContainerUtil.addIfNotNull((Collection)result, (Object)spreadExpression.getExpression()));
            }

            public void visitJSConditionalExpression(JSConditionalExpression node) {
                AstLoadingFilter.forceAllowTreeLoading((PsiFile)node.getContainingFile(), () -> {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)node.getThen());
                    ContainerUtil.addIfNotNull((Collection)result, (Object)node.getElse());
                });
            }

            public void visitJSCallExpression(JSCallExpression node) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)node.getStubSafeMethodExpression());
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.collectFunctionReturningArrayItems(node);
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.collectFunctionReturningArrayItems((JSFunction)node);
            }

            private void collectFunctionReturningArrayItems(@NotNull JSFunction function) {
                JSType type;
                if (function == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (JSTypeUtils.isArrayLikeType((JSType)(type = function.getReturnType()))) {
                    AstLoadingFilter.forceAllowTreeLoading((PsiFile)function.getContainingFile(), () -> function.acceptChildren((PsiElementVisitor)new JSElementVisitor(){

                        public void visitJSReturnStatement(JSReturnStatement node) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)node.getExpression());
                        }

                        public void visitJSStatement(JSStatement node) {
                            node.acceptChildren((PsiElementVisitor)this);
                        }
                    }));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/angular2/entities/source/Angular2SourceEntityListProcessor$2", "collectFunctionReturningArrayItems"));
            }
        };
    }

    protected final JSElementVisitor getResultsVisitor() {
        return this.myResultsVisitor;
    }

    protected void processNonEntityClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            Angular2SourceEntityListProcessor.$$$reportNull$$$0(1);
        }
    }

    protected void processEntity(@NotNull T entity) {
        if (entity == null) {
            Angular2SourceEntityListProcessor.$$$reportNull$$$0(2);
        }
    }

    protected void processAnyType() {
    }

    protected void processAnyElement(JSElement node) {
    }

    protected void processCacheDependency(PsiElement element) {
    }

    private void resolveFunctionReturnType(@NotNull JSFunction function) {
        Angular2MetadataFunction metadataFunction;
        Angular2MetadataModule metadataModule;
        if (function == null) {
            Angular2SourceEntityListProcessor.$$$reportNull$$$0(3);
        }
        HashSet<JSResolvedTypeId> visitedTypes = new HashSet<JSResolvedTypeId>();
        boolean lookingForModule = this.myEntityClass.isAssignableFrom(Angular2Module.class);
        JSClass resolvedClazz = null;
        JSType type = function.getReturnType();
        while (type != null && !(type instanceof JSAnyType) && visitedTypes.add(type.getResolvedTypeId())) {
            T entity;
            PsiElement sourceElement;
            NotNullLazyValue recordType = NotNullLazyValue.createValue(() -> ((JSType)type).asRecordType());
            if (type.getSourceElement() != null) {
                this.processCacheDependency(type.getSourceElement());
            }
            if (lookingForModule) {
                JSType argument;
                if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSTypeImpl && "ModuleWithProviders".equals(((JSGenericTypeImpl)type).getType().getTypeText()) && (argument = (JSType)ContainerUtil.getFirstItem((List)((JSGenericTypeImpl)type).getArguments())) != null && !(argument instanceof JSAnyType)) {
                    type = argument;
                    lookingForModule = false;
                    continue;
                }
                JSRecordType.PropertySignature ngModuleSignature = ((JSRecordType)recordType.getValue()).findPropertySignature("ngModule");
                if (ngModuleSignature != null) {
                    type = Angular2SourceEntityListProcessor.evaluateModuleWithProvidersType(ngModuleSignature, type.getSource());
                    lookingForModule = false;
                    continue;
                }
            }
            if ((sourceElement = type.getSourceElement()) instanceof TypeScriptSingleType) {
                T entity2;
                JSReferenceExpression expression = (JSReferenceExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)sourceElement.getContainingFile(), () -> ((TypeScriptSingleType)((TypeScriptSingleType)sourceElement)).getReferenceExpression());
                if (expression != null && (entity2 = this.getEntity(resolvedClazz = (JSClass)ObjectUtils.tryCast((Object)expression.resolve(), JSClass.class))) != null) {
                    this.processCacheDependency((PsiElement)resolvedClazz);
                    this.processEntity(entity2);
                    return;
                }
            } else if (sourceElement instanceof TypeScriptClass && (entity = this.getEntity(resolvedClazz = (JSClass)sourceElement)) != null) {
                this.processCacheDependency((PsiElement)resolvedClazz);
                this.processEntity(entity);
                return;
            }
            JSRecordType.CallSignature constructor = (JSRecordType.CallSignature)ContainerUtil.find((Iterable)((JSRecordType)recordType.getValue()).getCallSignatures(), JSRecordType.CallSignature::hasNew);
            type = (JSType)ObjectUtils.doIfNotNull((Object)constructor, JSRecordType.CallSignature::getReturnType);
        }
        if (this.myEntityClass.isAssignableFrom(Angular2Module.class) && (metadataModule = Angular2SourceEntityListProcessor.resolveFunctionValue(metadataFunction = Angular2MetadataUtil.findMetadataFunction(function))) != null) {
            Angular2Module ivyModule;
            this.processCacheDependency((PsiElement)metadataFunction);
            this.processCacheDependency((PsiElement)metadataModule);
            TypeScriptClass tsClass = metadataModule.getTypeScriptClass();
            if (tsClass != null && (ivyModule = (Angular2Module)ObjectUtils.tryCast(Angular2IvyUtil.getIvyEntity((PsiElement)tsClass), Angular2Module.class)) != null) {
                this.processCacheDependency((PsiElement)tsClass);
                this.processEntity(ivyModule);
                return;
            }
            this.processEntity(metadataModule);
            return;
        }
        if (resolvedClazz != null && !(type instanceof JSAnyType)) {
            this.processNonEntityClass(resolvedClazz);
        } else {
            this.processAnyType();
        }
    }

    private static JSType evaluateModuleWithProvidersType(JSRecordType.PropertySignature ngModuleSignature, JSTypeSource functionTypeSource) {
        JSFunctionBaseImpl function;
        List args;
        JSType result = ngModuleSignature.getJSType();
        if (result instanceof JSGenericTypeImpl && (args = ((JSGenericTypeImpl)result).getArguments()).size() == 1 && args.get(0) instanceof JSAnyType && functionTypeSource.getSourceElement() != null && (function = (JSFunctionBaseImpl)ObjectUtils.tryCast((Object)functionTypeSource.getSourceElement().getContext(), JSFunctionBaseImpl.class)) != null) {
            JSType evaluatedReturnType = (JSType)CachedValuesManager.getCachedValue((PsiElement)function, () -> {
                JSFunctionCachedData cachedData = new JSFunctionCachedData();
                SmartList nestedFuns = new SmartList();
                TypeScriptFunctionCachingVisitor cachedDataEvaluator = new TypeScriptFunctionCachingVisitor(function, cachedData, (List)nestedFuns);
                AstLoadingFilter.forceAllowTreeLoading((PsiFile)function.getContainingFile(), () -> Angular2SourceEntityListProcessor.lambda$null$0((JSFunctionNodesVisitor)cachedDataEvaluator, function));
                return CachedValueProvider.Result.create((Object)cachedDataEvaluator.getReturnTypeFromEvaluated(), (Object[])new Object[]{function});
            });
            ngModuleSignature = (JSRecordType.PropertySignature)ObjectUtils.doIfNotNull((Object)evaluatedReturnType, t -> t.asRecordType().findPropertySignature("ngModule"));
            result = (JSType)ObjectUtils.doIfNotNull((Object)ngModuleSignature, JSTypeInfoOwner::getJSType);
        }
        return result;
    }

    @Nullable
    private static Angular2MetadataModule resolveFunctionValue(@Nullable Angular2MetadataFunction function) {
        return Optional.ofNullable(function).map(f -> (Angular2MetadataObject)((Object)((Object)ObjectUtils.tryCast((Object)((Object)f.getValue()), Angular2MetadataObject.class)))).map(value -> (Angular2MetadataReference)((Object)((Object)ObjectUtils.tryCast((Object)((Object)value.findMember("ngModule")), Angular2MetadataReference.class)))).map(reference -> (Angular2MetadataModule)ObjectUtils.tryCast((Object)((Object)reference.resolve()), Angular2MetadataModule.class)).orElse(null);
    }

    private T getEntity(@Nullable JSClass aClass) {
        return (T)((Angular2Entity)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity((PsiElement)aClass), this.myEntityClass));
    }

    private static /* synthetic */ void lambda$null$0(JSFunctionNodesVisitor cachedDataEvaluator, JSFunctionBaseImpl function) throws RuntimeException {
        cachedDataEvaluator.visitElement(function.getNode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "org/angular2/entities/source/Angular2SourceEntityListProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processNonEntityClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEntity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFunctionReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

