/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import icons.AngularJSIcons;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.angular2.cli.AngularCliFilter;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.AngularJSProjectConfigurator;
import org.angular2.cli.Option;
import org.angular2.cli.SchematicOptionsTextField;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliProjectGenerator
extends NpmPackageProjectGenerator {
    @NonNls
    public static final String NG_EXECUTABLE = "ng";
    private static final Logger LOG = Logger.getInstance(AngularCliProjectGenerator.class);
    private static final Pattern NPX_PACKAGE_PATTERN = Pattern.compile("npx --package @angular/cli(?:@([0-9]+\\.[0-9]+\\.[0-9a-zA-Z-.]+))? ng");
    private static final Pattern VALID_NG_APP_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*(-[a-zA-Z][0-9a-zA-Z]*)*");

    @Nls
    @NotNull
    public String getName() {
        String string = Angular2Bundle.message("angular.action.new-project.name", new Object[0]);
        if (string == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = Angular2Bundle.message("angular.action.new-project.description", new Object[0]);
        if (string == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AngularJSIcons.Angular2;
        if (icon == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(3);
        }
        if (entry != null) {
            AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
        }
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(5);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(6);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(9);
        }
        AngularCLIProjectSettings ngSettings = (AngularCLIProjectSettings)settings;
        ArrayList<String> result = new ArrayList<String>();
        result.add("new");
        result.add(baseDir.getName());
        CommandLineTokenizer tokenizer = new CommandLineTokenizer(ngSettings.myOptions);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        if (AngularCliProjectGenerator.isPackageGreaterOrEqual(settings.myPackage, 7, 0, 0) && ngSettings.myUseDefaults && !ContainerUtil.exists(result, param -> param.equals("--defaults") || param.startsWith("--defaults="))) {
            result.add("--defaults");
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static boolean isPackageGreaterOrEqual(NodePackage pkg, int major, int minor, int patch) {
        SemVer ver = null;
        if (pkg.getName().equals("@angular/cli")) {
            ver = pkg.getVersion();
        } else {
            Matcher m = NPX_PACKAGE_PATTERN.matcher(pkg.getSystemIndependentPath());
            if (m.matches()) {
                ver = SemVer.parseFromText((String)m.group(1));
            }
        }
        return ver == null || ver.isGreaterOrEqualThan(major, minor, patch);
    }

    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(11);
        }
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(12);
        }
        Filter[] filterArray = new Filter[]{new AngularCliFilter(project, baseDir.getParent().getPath())};
        if (filterArray == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(13);
        }
        return filterArray;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(14);
        }
        return AngularCliProjectGenerator.ng(pkg.getSystemDependentPath());
    }

    @NotNull
    public static String ng(String path) {
        String string = path + File.separator + "bin" + File.separator + NG_EXECUTABLE;
        if (string == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    protected String packageName() {
        return "@angular/cli";
    }

    @NotNull
    protected String presentablePackageName() {
        String string = Angular2Bundle.message("angular.action.new-project.presentable-package-name", new Object[0]);
        if (string == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand("@angular/cli", NG_EXECUTABLE));
        if (list == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(17);
        }
        return list;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(18);
        }
        return Optional.ofNullable(AngularCliProjectGenerator.validateFolderName(path, Angular2Bundle.message("angular.action.new-project.label-project-name", new Object[0]))).orElseGet(() -> super.validateProjectPath(path));
    }

    @NotNull
    public ProjectGeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        return new AngularCLIProjectGeneratorPeer();
    }

    @NotNull
    protected File workingDir(NpmPackageProjectGenerator.Settings settings, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(19);
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir).getParentFile();
        if (file == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(21);
        }
        if (baseDir == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(22);
        }
        Runnable runnable = () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            super.postInstall(project, baseDir, workingDir).run();
            AngularCliUtil.createRunConfigurations(project, baseDir);
        });
        if (runnable == null) {
            AngularCliProjectGenerator.$$$reportNull$$$0(23);
        }
        return runnable;
    }

    @Nullable
    private static String validateFolderName(String path, String label) {
        String fileName = PathUtil.getFileName((String)path);
        if (!VALID_NG_APP_NAME.matcher(fileName).matches()) {
            return XmlStringUtil.wrapInHtml((CharSequence)Angular2Bundle.message("angular.action.new-project.wrong-folder-name", label, fileName));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/cli/AngularCliProjectGenerator";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/cli/AngularCliProjectGenerator";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = NG_EXECUTABLE;
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularCLIProjectSettings
    extends NpmPackageProjectGenerator.Settings {
        @NotNull
        public final String myOptions;
        public final boolean myUseDefaults;

        AngularCLIProjectSettings(@NotNull NpmPackageProjectGenerator.Settings settings, boolean useDefaults, @NotNull String options) {
            if (settings == null) {
                AngularCLIProjectSettings.$$$reportNull$$$0(0);
            }
            if (options == null) {
                AngularCLIProjectSettings.$$$reportNull$$$0(1);
            }
            super(settings.myInterpreterRef, settings.myPackage);
            this.myUseDefaults = useDefaults;
            this.myOptions = options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "org/angular2/cli/AngularCliProjectGenerator$AngularCLIProjectSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AngularCLIProjectGeneratorPeer
    extends NpmPackageProjectGenerator.NpmPackageGeneratorPeer {
        private TextAccessor myContentRoot;
        private SchematicOptionsTextField myOptionsTextField;
        private JCheckBox myUseDefaults;

        private AngularCLIProjectGeneratorPeer() {
            super((NpmPackageProjectGenerator)AngularCliProjectGenerator.this);
        }

        protected JPanel createPanel() {
            JPanel panel = super.createPanel();
            this.myOptionsTextField = new SchematicOptionsTextField(ProjectManager.getInstance().getDefaultProject(), Collections.emptyList());
            this.myOptionsTextField.setVariants(Collections.singletonList(new Option("test")));
            LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myOptionsTextField), (String)Angular2Bundle.message("angular.action.new-project.label-additional-parameters", new Object[0]));
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            this.myUseDefaults = new JCheckBox(Angular2Bundle.message("angular.action.new-project.label-defaults", new Object[0]), true);
            panel.add(this.myUseDefaults);
            return panel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            if (settingsStep == null) {
                AngularCLIProjectGeneratorPeer.$$$reportNull$$$0(0);
            }
            super.buildUI(settingsStep);
            final ModuleNameLocationSettings field = settingsStep.getModuleNameLocationSettings();
            if (field != null) {
                this.myContentRoot = new TextAccessor(){

                    public void setText(@NotNull String text) {
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        field.setModuleContentRoot(text);
                    }

                    @NotNull
                    public String getText() {
                        String string = field.getModuleContentRoot();
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/angular2/cli/AngularCliProjectGenerator$AngularCLIProjectGeneratorPeer$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/angular2/cli/AngularCliProjectGenerator$AngularCLIProjectGeneratorPeer$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "setText";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)Angular2Bundle.message("angular.action.new-project.label-additional-parameters", new Object[0])), (JComponent)((Object)this.myOptionsTextField));
            settingsStep.addSettingsComponent((JComponent)this.myUseDefaults);
            this.getPackageField().addSelectionListener(this::nodePackageChanged);
            this.nodePackageChanged(this.getPackageField().getSelected());
        }

        @NotNull
        public NpmPackageProjectGenerator.Settings getSettings() {
            return new AngularCLIProjectSettings(super.getSettings(), this.myUseDefaults.isSelected(), this.myOptionsTextField.getText());
        }

        @Nullable
        public ValidationInfo validate() {
            String message;
            ValidationInfo info = super.validate();
            if (info != null) {
                return info;
            }
            if (this.myContentRoot != null && (message = AngularCliProjectGenerator.validateFolderName(this.myContentRoot.getText(), Angular2Bundle.message("angular.action.new-project.label-content-root-folder", new Object[0]))) != null) {
                return new ValidationInfo(message);
            }
            return null;
        }

        private void nodePackageChanged(NodePackage nodePackage) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile localFile;
                List options = Collections.emptyList();
                if (nodePackage.getSystemIndependentPath().endsWith("/node_modules/@angular/cli") && (localFile = StandardFileSystems.local().findFileByPath(nodePackage.getSystemDependentPath())) != null) {
                    localFile = localFile.getParent().getParent().getParent();
                    try {
                        options = AngularCliSchematicsRegistryService.getInstance().getSchematics(ProjectManager.getInstance().getDefaultProject(), localFile, true, false).stream().filter(s -> "ng-new".equals(s.getName())).findFirst().map(schematic -> {
                            ArrayList<Option> list = new ArrayList<Option>(schematic.getOptions());
                            list.add(this.createOption("verbose", "Boolean", false, "Adds more details to output logging."));
                            list.add(this.createOption("collection", "String", null, "Schematics collection to use"));
                            list.sort(Comparator.comparing(Option::getName));
                            return list;
                        }).orElse(Collections.emptyList());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load schematics", (Throwable)e);
                    }
                }
                this.myOptionsTextField.setVariants(options);
            });
        }

        private Option createOption(String name, String type, Object defaultVal, String description) {
            Option res = new Option(name);
            res.setType(type);
            res.setDefault(defaultVal);
            res.setDescription(description);
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "org/angular2/cli/AngularCliProjectGenerator$AngularCLIProjectGeneratorPeer", "buildUI"));
        }
    }
}

