/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ir;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.channels.SftpChannel;
import com.jetbrains.plugins.webDeployment.ir.SshEnvironment;
import com.jetbrains.plugins.webDeployment.ir.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.webDeployment.ir.SshTargetEnvironmentConfiguration;
import java.io.File;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugins/webDeployment/ir/SshEnvironmentFactory;", "Lcom/intellij/execution/target/TargetEnvironmentFactory;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "targetConfiguration", "Lcom/jetbrains/plugins/webDeployment/ir/SshTargetEnvironmentConfiguration;", "(Lcom/intellij/ssh/ConnectionBuilder;Lcom/jetbrains/plugins/webDeployment/ir/SshTargetEnvironmentConfiguration;)V", "getConnectionBuilder", "()Lcom/intellij/ssh/ConnectionBuilder;", "createRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "fixPermissions", "", "file", "Ljava/io/File;", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "remotePath", "", "generateUploadDirPath", "getTargetConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getTargetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "preparePortForwardings", "request", "Lcom/jetbrains/plugins/webDeployment/ir/SshRemoteEnvironmentRequest;", "prepareRemoteEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "uploadPaths", "Companion", "intellij.webDeployment"})
public final class SshEnvironmentFactory
implements TargetEnvironmentFactory {
    @NotNull
    private final ConnectionBuilder connectionBuilder;
    private final SshTargetEnvironmentConfiguration targetConfiguration;
    private static final int EXECUTE_BY_USER_FILE_ATTRIBUTE = 64;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX, TargetPlatform.Arch.x64bit);
    }

    @NotNull
    public TargetEnvironmentConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    @NotNull
    public TargetEnvironmentRequest createRequest() {
        return new SshRemoteEnvironmentRequest(this.getTargetPlatform());
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, @NotNull ProgressIndicator progress) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        this.uploadPaths((SshRemoteEnvironmentRequest)request);
        this.preparePortForwardings((SshRemoteEnvironmentRequest)request);
        return new SshEnvironment(request, this.connectionBuilder, this.getTargetPlatform());
    }

    private final void uploadPaths(SshRemoteEnvironmentRequest request) {
        SftpChannel sftpChannel = ConnectionBuilder.openSftpChannel$default((ConnectionBuilder)this.connectionBuilder, (int)0, (int)1, null);
        Iterable $this$forEach$iv = request.getPaths$intellij_webDeployment();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeferredTargetValue uploadValue = (DeferredTargetValue)element$iv;
            boolean bl = false;
            uploadValue.getLocalValue().onSuccess((Consumer)new Consumer<String>(uploadValue, this, sftpChannel){
                final /* synthetic */ DeferredTargetValue $uploadValue;
                final /* synthetic */ SshEnvironmentFactory this$0;
                final /* synthetic */ SftpChannel $sftpChannel$inlined;
                {
                    this.$uploadValue = deferredTargetValue;
                    this.this$0 = sshEnvironmentFactory;
                    this.$sftpChannel$inlined = sftpChannel;
                }

                public final void accept(String it) {
                    File file = new File(it);
                    if (file.exists()) {
                        String relativePath;
                        String remotePath = SshEnvironmentFactory.access$generateUploadDirPath(this.this$0);
                        String string = relativePath = file.isDirectory() ? "" : file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativePath");
                        this.$sftpChannel$inlined.uploadFileOrDir(file, remotePath, string);
                        String fullRemotePath = remotePath + '/' + relativePath;
                        SshEnvironmentFactory.access$fixPermissions(this.this$0, file, this.$sftpChannel$inlined, fullRemotePath);
                        this.$uploadValue.resolve((Object)fullRemotePath);
                    }
                }
            });
        }
    }

    private final void preparePortForwardings(SshRemoteEnvironmentRequest request) {
        SshSession sshSession = this.connectionBuilder.connect();
        Iterable $this$forEach$iv = request.getPorts$intellij_webDeployment();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeferredLocalTargetValue portValue = (DeferredLocalTargetValue)element$iv;
            boolean bl = false;
            portValue.getTargetValue().onSuccess((Consumer)new Consumer<Integer>(portValue, sshSession){
                final /* synthetic */ DeferredLocalTargetValue $portValue;
                final /* synthetic */ SshSession $sshSession$inlined;
                {
                    this.$portValue = deferredLocalTargetValue;
                    this.$sshSession$inlined = sshSession;
                }

                public final void accept(Integer remotePort) {
                    Integer n = remotePort;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"remotePort");
                    this.$portValue.resolve((Object)this.$sshSession$inlined.addLocalTunnelWithRandomLocalPort("localhost", n.intValue()));
                }
            });
        }
    }

    private final void fixPermissions(File file, SftpChannel sftpChannel, String remotePath) {
        RemoteFileObject remoteFile;
        int remoteFilePermissions;
        if (file.isFile() && file.canExecute() && ((remoteFilePermissions = (remoteFile = sftpChannel.file(remotePath)).getPermissions()) & 0x40) == 0) {
            remoteFile.setPermissions(remoteFilePermissions | 0x40);
        }
    }

    private final String generateUploadDirPath() {
        return "/tmp/" + UUID.randomUUID();
    }

    @NotNull
    public final ConnectionBuilder getConnectionBuilder() {
        return this.connectionBuilder;
    }

    public SshEnvironmentFactory(@NotNull ConnectionBuilder connectionBuilder, @NotNull SshTargetEnvironmentConfiguration targetConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)connectionBuilder, (String)"connectionBuilder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetConfiguration), (String)"targetConfiguration");
        this.connectionBuilder = connectionBuilder;
        this.targetConfiguration = targetConfiguration;
    }

    public static final /* synthetic */ String access$generateUploadDirPath(SshEnvironmentFactory $this) {
        return $this.generateUploadDirPath();
    }

    public static final /* synthetic */ void access$fixPermissions(SshEnvironmentFactory $this, File file, SftpChannel sftpChannel, String remotePath) {
        $this.fixPermissions(file, sftpChannel, remotePath);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugins/webDeployment/ir/SshEnvironmentFactory$Companion;", "", "()V", "EXECUTE_BY_USER_FILE_ATTRIBUTE", "", "intellij.webDeployment"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

