/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.d.la;
import com.intellij.find.FindManager;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private MatchingProcess a;
    private FindUsagesProcessPresentation b;
    private static final long d = la.a(8873828707814063190L, -7550731011465739114L, MethodHandles.lookup().lookupClass()).a(73648084929049L);

    public SearchCommand(Configuration configuration, SearchContext searchContext) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    protected UsageViewContext createUsageViewContext() {
        Runnable runnable = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, runnable);
    }

    public void startSearching() {
        final UsageViewContext usageViewContext = this.createUsageViewContext();
        final UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        usageViewContext.configure(usageViewPresentation);
        this.b = new FindUsagesProcessPresentation(usageViewPresentation);
        this.b.setShowNotFoundMessage(true);
        this.b.setShowPanelIfOnlyOneUsage(true);
        this.b.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            public ProgressIndicator create() {
                FindProgressIndicator findProgressIndicator = new FindProgressIndicator(SearchCommand.this.mySearchContext.getProject(), usageViewPresentation.getScopeText());
                findProgressIndicator.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                    public void cancel() {
                        super.cancel();
                        SearchCommand.this.stopAsyncSearch();
                    }
                });
                return findProgressIndicator;
            }
        });
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget configurableUsageTarget = usageViewContext.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(configurableUsageTarget);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{configurableUsageTarget}, () -> new UsageSearcher(){
            private static final long a = la.a(-2601698425569577301L, 9064754525235882446L, MethodHandles.lookup().lookupClass()).a(120461234188190L);

            public void generate(@NotNull Processor<? super Usage> processor) {
                if (processor == null) {
                    3.a(0);
                }
                SearchCommand.this.findUsages(processor);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3B941B8E1C29L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/structuralsearch/plugin/ui/SearchCommand$3", "generate"));
            }
        }, this.b, usageViewPresentation, new UsageViewManager.UsageViewStateListener(){
            private static final long a = la.a(-7498735673987254196L, 7937110520399048765L, MethodHandles.lookup().lookupClass()).a(103363131284104L);

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    2.a(0);
                }
                usageViewContext.setUsageView(usageView);
                usageViewContext.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3CE6C2C48B8CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/structuralsearch/plugin/ui/SearchCommand$2", "usageViewCreated"));
            }
        });
    }

    public void findUsages(final Processor<? super Usage> processor) {
        long l2 = d ^ 0x69C013336907L;
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        MatchResultSink matchResultSink = new MatchResultSink(){
            int count;
            private static final long a = la.a(-2545793603485709935L, 5613248331201352340L, MethodHandles.lookup().lookupClass()).a(136781461952359L);

            @Override
            public void setMatchingProcess(MatchingProcess _process) {
                SearchCommand.this.a = _process;
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(PsiFile element) {
                long l2 = a ^ 0xE90D5CC424AL;
                VirtualFile virtualFile = element.getVirtualFile();
                if (virtualFile != null) {
                    progressIndicator.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                long l2 = a ^ 0xD73B4130820L;
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progressIndicator.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progressIndicator;
            }

            @Override
            public void newMatch(MatchResult result) {
                UsageInfo usageInfo;
                long l2 = a ^ 0x4A15A87EFA54L;
                if ("__multi_line__".equals(result.getName())) {
                    int n2 = -1;
                    int n3 = -1;
                    PsiElement psiElement = result.getMatch().getParent();
                    for (MatchResult matchResult : result.getChildren()) {
                        int n4;
                        PsiElement psiElement2 = matchResult.getMatch();
                        int n5 = psiElement2.getTextRange().getStartOffset();
                        if (n2 == -1 || n2 > n5) {
                            n2 = n5;
                        }
                        if ((n4 = n5 + psiElement2.getTextLength()) <= n3) continue;
                        n3 = n4;
                    }
                    int n6 = psiElement.getTextRange().getStartOffset();
                    int n7 = n2 - n6;
                    usageInfo = new UsageInfo(psiElement, n7, n3 - n6);
                } else {
                    PsiElement psiElement = result.getMatch();
                    if (!psiElement.isPhysical()) {
                        return;
                    }
                    usageInfo = new UsageInfo(psiElement);
                }
                UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
                SearchCommand.this.foundUsage(result, (Usage)usageInfo2UsageAdapter);
                processor.process((Object)usageInfo2UsageAdapter);
                ++this.count;
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject(), this.myConfiguration.getMatchOptions()).findMatches(matchResultSink);
        }
        catch (StructuralSearchException structuralSearchException) {
            this.b.setShowNotFoundMessage(false);
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(structuralSearchException instanceof StructuralSearchScriptException ? SSRBundle.message("search.script.problem", structuralSearchException.getCause()) : SSRBundle.message("search.template.problem", structuralSearchException.getMessage())).setImportant(true).notify(this.mySearchContext.getProject());
        }
    }

    public void stopAsyncSearch() {
        if (this.a != null) {
            this.a.stop();
        }
    }

    protected void findStarted() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(true);
    }

    protected void findEnded() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(false);
    }

    protected void foundUsage(MatchResult result, Usage usage) {
    }
}

