/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import a.d.la;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.AuthType;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshEntityConfigurable;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshConfigsMasterComponent
extends MasterDetailsComponent {
    private final MyNamer c;
    private final Cloner<SshUiData> b;
    protected final List<SshUiData> myItems;
    private List<SshUiData> a;
    @NotNull
    protected final Project myProject;
    private final SshConfigConfigurable.Visibility e;
    private Producer<Pair<String, String>> d;
    private static final long h = la.a(1479272681395597459L, 7420058130399726992L, MethodHandles.lookup().lookupClass()).a(198304139153933L);

    SshConfigsMasterComponent(@NotNull Project project, @NotNull SshConfigConfigurable.Visibility defaultVisibility, @Nullable Producer<Pair<String, String>> actualHostPortProducer) {
        long l2 = h ^ 0x1B6FFEE10963L;
        if (project == null) {
            SshConfigsMasterComponent.b(0);
        }
        if (defaultVisibility == null) {
            SshConfigsMasterComponent.b(1);
        }
        this.myItems = new ArrayList<SshUiData>();
        LOG.assertTrue(!project.isDefault() || defaultVisibility == SshConfigConfigurable.Visibility.App, (Object)"Project-level visibility needs a project");
        this.myProject = project;
        this.e = defaultVisibility;
        this.c = new MyNamer();
        this.b = new MyCloner();
        this.d = actualHostPortProducer;
        this.initTree();
    }

    protected void initTree() {
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){
            private static final long a = la.a(-4480519396213323134L, -733060089527531222L, MethodHandles.lookup().lookupClass()).a(202508133611248L);

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.a(0);
                }
                if (!(value instanceof MasterDetailsComponent.MyNode)) {
                    return;
                }
                this.setIconOnTheRight(false);
                MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)value;
                Font font = UIUtil.getTreeFont();
                this.setFont(font.deriveFont(0));
                NamedConfigurable namedConfigurable = myNode.getConfigurable();
                if (namedConfigurable instanceof SshEntityConfigurable) {
                    SshUiData sshUiData = ((SshEntityConfigurable)namedConfigurable).applyToNewDefaultSshDataIfPossible(SshConfigsMasterComponent.this.isInitialized(namedConfigurable));
                    SshConfigsMasterComponent.renderData(sshUiData, (SimpleColoredComponent)this);
                } else {
                    this.append(myNode.getDisplayName(), myNode.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x40C8A80444FDL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$1", "customizeCellRenderer"));
            }
        });
    }

    @Nullable
    @Nls
    protected String getEmptySelectionString() {
        long l2 = h ^ 0xFB3DF94FEAEL;
        return this.myItems.isEmpty() ? SshBundle.message("ssh.master.component.please.add.an.ssh.configuration", new Object[0]) : SshBundle.message("ssh.master.component.please.select.ssh.configuration", new Object[0]);
    }

    void resetFromData(@NotNull SshConfigManager.ConfigsData lastSavedAndCurrentData) {
        if (lastSavedAndCurrentData == null) {
            SshConfigsMasterComponent.b(2);
        }
        if (this.myProject.isDefault()) {
            for (SshUiData sshUiData : lastSavedAndCurrentData.getCurrentData()) {
                LOG.assertTrue(!sshUiData.getConfig().isProjectLevel());
            }
            for (SshUiData sshUiData : lastSavedAndCurrentData.getLastSavedData()) {
                LOG.assertTrue(!sshUiData.getConfig().isProjectLevel());
            }
        }
        Iterator<SshUiData> iterator = this.getSelectedItem();
        this.a = lastSavedAndCurrentData.getLastSavedData();
        this.a(lastSavedAndCurrentData.getCurrentData());
        this.selectItem((SshUiData)((Object)iterator));
    }

    public void reset() {
        SshUiData sshUiData = this.getSelectedItem();
        this.a(this.a);
        this.selectItem(sshUiData);
    }

    private void a(@NotNull List<SshUiData> list2) {
        if (list2 == null) {
            SshConfigsMasterComponent.b(3);
        }
        this.myItems.clear();
        this.clearChildren();
        for (SshUiData sshUiData : list2) {
            this.a((SshUiData)this.b.cloneOf((Object)sshUiData));
        }
        super.reset();
    }

    public boolean isModified() {
        if (this.a.size() != this.myItems.size()) {
            return true;
        }
        for (int i10 = 0; i10 < this.myItems.size(); ++i10) {
            if (this.myItems.get(i10).hasEqualData(this.a.get(i10), true)) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.a = new ArrayList<SshUiData>(this.myItems);
        SshConfigManager.getInstance(this.myProject).applyData(this.myItems, null);
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public void setActualHostPortProducer(@Nullable Producer<Pair<String, String>> actualHostPortProducer) {
        this.d = actualHostPortProducer;
    }

    private static String a() {
        long l2 = h ^ 0x4C840893097BL;
        return SshBundle.message("ssh.master.component.item", new Object[0]);
    }

    @Nullable
    protected SshUiData findByName(String name) {
        for (SshUiData sshUiData : this.myItems) {
            if (!Comparing.equal((String)name, (String)this.c.getName(sshUiData))) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add((AnAction)new AddAction(this));
        arrayList.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, SshConfigsMasterComponent.forAll(object -> SshConfigsMasterComponent.b((SshUiData)((MasterDetailsComponent.MyNode)object).getConfigurable().getEditableObject()))));
        arrayList.add((AnAction)new RenameAction(this));
        return arrayList;
    }

    private void a(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            SshConfigsMasterComponent.b(4);
        }
        this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)this.createConfigurable(sshUiData, this.c.canRename(sshUiData), this.TREE_UPDATER)), this.myRoot);
        this.myItems.add(sshUiData);
    }

    private static boolean b(SshUiData sshUiData) {
        return true;
    }

    protected void onItemDeleted(Object item) {
        this.myItems.remove((SshUiData)item);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SshConfigsMasterComponent.b(5);
        }
        return project;
    }

    public SshUiData getSelectedItem() {
        return (SshUiData)this.getSelectedObject();
    }

    public void selectItem(@Nullable SshUiData exampleItem) {
        SshUiData sshUiData = null;
        if (exampleItem != null) {
            for (SshUiData sshUiData2 : this.myItems) {
                if (!exampleItem.getName().equals(sshUiData2.getName())) continue;
                sshUiData = sshUiData2;
                break;
            }
        }
        this.selectNodeInTree(sshUiData);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof SshEntityConfigurable && ((SshEntityConfigurable)configurable).isRequestFocusOnSelection()) {
            JComponent jComponent = configurable.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)jComponent).requestFocus((Component)jComponent, false);
            ((SshEntityConfigurable)configurable).setRequestFocusOnSelection(false);
        }
    }

    protected void onItemCreated(@NotNull SshUiData newItem) {
        if (newItem == null) {
            SshConfigsMasterComponent.b(6);
        }
        this.a(newItem);
        this.selectNodeInTree(newItem);
        NamedConfigurable namedConfigurable = this.getSelectedConfigurable();
        if (namedConfigurable instanceof SshEntityConfigurable) {
            ((SshEntityConfigurable)namedConfigurable).setRequestFocusOnSelection(true);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        long l2 = h ^ 0x2FEC7D76F398L;
        return SshBundle.message("ssh.configurable.title", new Object[0]);
    }

    protected SshEntityConfigurable createConfigurable(@NotNull SshUiData item, boolean nameEditable, Runnable updater) {
        if (item == null) {
            SshConfigsMasterComponent.b(7);
        }
        LOG.assertTrue(!item.getConfig().isProjectLevel() || !this.myProject.isDefault());
        return new SshEntityConfigurable(item, nameEditable, updater, this.d, this.myProject.isDefault());
    }

    public void disposeUIResources() {
        SshConfigManager.getInstance(this.myProject).disposeCurrentData();
        super.disposeUIResources();
    }

    public static void renderData(@NotNull SshUiData data, @NotNull SimpleColoredComponent renderer) {
        if (data == null) {
            SshConfigsMasterComponent.b(8);
        }
        if (renderer == null) {
            SshConfigsMasterComponent.b(9);
        }
        renderer.append(data.getConfig().getPresentableShortName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        @Nls String string = data.getConfig().getPresentableAddition();
        if (string != null) {
            renderer.append(string, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x38EFEB2F70B8L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSavedAndCurrentData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetFromData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewNode";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onItemCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MainSshConfigsMasterComponent
    extends SshConfigsMasterComponent
    implements SshConfigManager.Listener {
        private HierarchyListener f;
        private static final long i = la.a(3274058621627177078L, -5119592613108831877L, MethodHandles.lookup().lookupClass()).a(152933031048350L);

        MainSshConfigsMasterComponent(@NotNull Project project) {
            if (project == null) {
                MainSshConfigsMasterComponent.c(0);
            }
            super(project, MainSshConfigsMasterComponent.a(project), null);
        }

        @NotNull
        private static SshConfigConfigurable.Visibility a(@NotNull Project project) {
            if (project == null) {
                MainSshConfigsMasterComponent.c(1);
            }
            SshConfigConfigurable.Visibility visibility = PlatformUtils.isPhpStorm() && !project.isDefault() ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App;
            if (visibility == null) {
                MainSshConfigsMasterComponent.c(2);
            }
            return visibility;
        }

        @NotNull
        public JComponent createComponent() {
            JComponent jComponent = super.createComponent();
            this.f = new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e10) {
                    if ((e10.getChangeFlags() & 4L) == 0L) {
                        return;
                    }
                    if (e10.getComponent().isShowing()) {
                        this.addNotify();
                        return;
                    }
                    SshConfigManager.getInstance(myProject).setCurrentData(this.a(), this);
                }
            };
            this.myWholePanel.addHierarchyListener(this.f);
            JComponent jComponent2 = jComponent;
            if (jComponent2 == null) {
                MainSshConfigsMasterComponent.c(3);
            }
            return jComponent2;
        }

        @NotNull
        private List<SshUiData> a() {
            ArrayList<SshUiData> arrayList = new ArrayList<SshUiData>();
            for (MasterDetailsComponent.MyNode myNode : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).filter(MasterDetailsComponent.MyNode.class)) {
                NamedConfigurable namedConfigurable = myNode.getConfigurable();
                if (!(namedConfigurable instanceof SshEntityConfigurable)) continue;
                SshUiData sshUiData = ((SshEntityConfigurable)namedConfigurable).applyToNewDefaultSshDataIfPossible(this.isInitialized(namedConfigurable));
                arrayList.add(sshUiData);
            }
            ArrayList<SshUiData> arrayList2 = arrayList;
            if (arrayList2 == null) {
                MainSshConfigsMasterComponent.c(4);
            }
            return arrayList2;
        }

        @Override
        public void disposeUIResources() {
            if (this.f != null && this.myWholePanel != null) {
                this.myWholePanel.removeHierarchyListener(this.f);
                this.f = null;
            }
            super.disposeUIResources();
        }

        @Override
        public void sshConfigsChanged() {
            this.resetFromData(SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData());
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = i ^ 0x7732E176F341L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        final /* synthetic */ SshConfigsMasterComponent this$0;
        private static final long a = la.a(-3729865142252362903L, -7784024010758709335L, MethodHandles.lookup().lookupClass()).a(241452624560837L);

        private RenameAction(SshConfigsMasterComponent sshConfigsMasterComponent) {
            long l2 = a ^ 0x4DA5D830FE00L;
            this.this$0 = sshConfigsMasterComponent;
            super(SshBundle.message("ssh.master.component.rename.action", new Object[0]), SshBundle.message("ssh.master.component.rename.action", new Object[0]), AllIcons.Actions.EditSource);
            this.registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)sshConfigsMasterComponent.myTree);
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                RenameAction.a(0);
            }
            TreePath[] treePathArray = this.this$0.myTree.getSelectionPaths();
            e10.getPresentation().setEnabled(treePathArray != null && treePathArray.length == 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            TreePath[] treePathArray;
            long l2 = a ^ 0x28A35EFED680L;
            if (e10 == null) {
                RenameAction.a(1);
            }
            if ((treePathArray = this.this$0.myTree.getSelectionPaths()) == null || treePathArray.length != 1) {
                return;
            }
            MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)treePathArray[0].getLastPathComponent();
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            if (!(namedConfigurable instanceof SshEntityConfigurable)) {
                return;
            }
            Object object = namedConfigurable.getEditableObject();
            if (!(object instanceof SshUiData)) {
                return;
            }
            SshUiData sshUiData = (SshUiData)object;
            final String string = sshUiData.getName();
            final HashSet<String> hashSet = new HashSet<String>();
            for (SshUiData sshUiData2 : this.this$0.myItems) {
                hashSet.add(sshUiData2.getName());
            }
            String string2 = Messages.showInputDialog((Component)this.this$0.getTree(), (String)SshBundle.message("ssh.master.component.rename.new.name", new Object[0]), (String)SshBundle.message("ssh.master.component.rename.action", new Object[0]), null, (String)string, (InputValidator)new InputValidatorEx(){
                private static final long a = la.a(2013782444681343510L, 4539380388036094225L, MethodHandles.lookup().lookupClass()).a(87319906484101L);

                @Nullable
                public String getErrorText(String inputString) {
                    long l2 = a ^ 0x273830D80570L;
                    if (StringUtil.isEmptyOrSpaces((String)inputString)) {
                        return SshBundle.message("ssh.master.component.rename.provide.a.name.for.the.ssh.configuration", new Object[0]);
                    }
                    if (this.a(inputString)) {
                        return SshBundle.message("ssh.master.component.rename.server.or.group.named.0.already.exists", inputString);
                    }
                    return null;
                }

                public boolean checkInput(String inputString) {
                    return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.a(inputString);
                }

                public boolean canClose(String inputString) {
                    return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.a(inputString);
                }

                private boolean a(@NotNull String string2) {
                    if (string2 == null) {
                        1.a(0);
                    }
                    return !string2.equals(string) && hashSet.contains(string2);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x69525433DA47L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$RenameAction$1", "banned"));
                }
            });
            if (string2 == null || string2.equals(string)) {
                return;
            }
            ((SshEntityConfigurable)namedConfigurable).setCustomName(string2);
            this.this$0.TREE_UPDATER.run();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x190B6ABE733CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$RenameAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddAction
    extends DumbAwareAction {
        final /* synthetic */ SshConfigsMasterComponent this$0;
        private static final long a = la.a(7752280971542403032L, -7613031133558567188L, MethodHandles.lookup().lookupClass()).a(230412816986330L);

        AddAction(SshConfigsMasterComponent sshConfigsMasterComponent) {
            long l2 = a ^ 0x50DD14A007A0L;
            this.this$0 = sshConfigsMasterComponent;
            super(SshBundle.message("ssh.master.component.add.action", new Object[0]), SshBundle.message("ssh.master.component.add.action", new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)sshConfigsMasterComponent.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddAction.a(0);
            }
            SshConfig sshConfig = new SshConfig(true);
            sshConfig.setAuthType(AuthType.PASSWORD);
            sshConfig.setProjectLevel(this.this$0.e == SshConfigConfigurable.Visibility.Project);
            SshUiData sshUiData = new SshUiData(sshConfig, false);
            sshUiData.setStorePassword(true);
            sshUiData.setStorePassphrase(true);
            this.this$0.onItemCreated(sshUiData);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0xB5760DC3A00L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$AddAction", "actionPerformed"));
        }
    }

    private static class MyCloner
    implements Cloner<SshUiData> {
        private MyCloner() {
        }

        public SshUiData cloneOf(SshUiData data) {
            return data.clone();
        }

        public SshUiData copyOf(SshUiData data) {
            return data.copy();
        }
    }

    private static class MyNamer
    implements Namer<SshUiData> {
        private static final long a = la.a(8567975619975350529L, -8923831725282457915L, MethodHandles.lookup().lookupClass()).a(25543933620575L);

        private MyNamer() {
        }

        public String getName(SshUiData data) {
            return data.getName();
        }

        public boolean canRename(SshUiData item) {
            return false;
        }

        public void setName(SshUiData data, String name) {
            long l2 = a ^ 0x4C53F62BDD51L;
            throw new IllegalStateException("SshUIData is not designed to rename");
        }
    }
}

