/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import a.d.la;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesForm
implements Disposable {
    private final JLabel b;
    private final JLabel k;
    private final JPanel c;
    @NonNls
    private static final String d = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String m = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String j = "find.locateDuplicates.result";
    private final JBSplitter o;
    private final Tree r;
    private final MyDuplicatesModelListener h;
    private final DupInfo s;
    private final Map<DuplicatesPresentation, DuplicatesView> e;
    private final Map<Editor, List<RangeHighlighter>> p;
    private final HighlightManager n;
    private DuplicatesModel g;
    private final Project q;
    private static final DataKey<DuplicatesModel> f;
    private static final String l = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter a;
    private static DupInfo i;
    private static final long t;

    private DuplicatesForm(Project project, DupInfo dupInfo) {
        long l2 = t ^ 0x7D656C442C9AL;
        this.b = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.k = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.c = new JPanel(new BorderLayout());
        this.r = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.h = new MyDuplicatesModelListener();
        this.e = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.p = new HashMap<Editor, List<RangeHighlighter>>();
        this.a = new MyGlassPanePainter();
        this.q = project;
        this.s = dupInfo;
        this.n = HighlightManager.getInstance((Project)this.q);
        DataProvider dataProvider = string -> {
            long l2 = t ^ 0x724A2FC3851CL;
            if (PlatformDataKeys.HELP_ID.is(string)) {
                return j;
            }
            if (f.is(string)) {
                return this.g;
            }
            if (this.g == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.getName().equals(string)) {
                CodeNode codeNode = this.g.getSelectedCodeNode();
                return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
            }
            return null;
        };
        this.o = new MySplitter(dataProvider);
        this.o.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.r));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.r);
        SelectInEditorHandler.installKeyListener((JComponent)this.r);
        this.a();
        this.r.setShowsRootHandles(true);
        this.r.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.r.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installUnknownPopupHandler((JComponent)this.r, (ActionGroup)DuplicatesForm.a(this.getComponent()), (ActionManager)ActionManager.getInstance());
        this.r.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.r.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.r.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.b, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.b.getWidth(), rectangle.y), DuplicatesForm.this.k, 1);
                    }
                }
            }
        });
        this.c.add((Component)this.b, "West");
        this.c.add((Component)this.k, "East");
        this.c.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.r, (Painter)this.a, (Disposable)this);
        this.r.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.r.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.r.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.r.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.b.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.k.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.a.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.a.setPaint(null, null);
            }
        });
    }

    private void a() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.r);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.b();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.q, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.q).openTextEditor(openFileDescriptor, false);
                    if (editor != null) {
                        List list2 = (List)DuplicatesForm.this.p.get(editor);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                DuplicatesForm.this.n.removeSegmentHighlighter(editor, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor, psiFragment, DuplicatesForm.this.n, 0);
                        DuplicatesForm.this.p.put(editor, list3);
                    }
                }
                return true;
            }
        }.installOn((Component)this.r);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.g.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.g.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.r;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l2 = t ^ 0x29A8A65AB43DL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(d);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(m);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel2) {
        panel2.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = la.a(-271296407844147606L, 9119350610322041030L, MethodHandles.lookup().lookupClass()).a(230101262027549L);

            protected boolean isAutoScrollMode() {
                long l2 = a ^ 0x2D13E1CD2750L;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.l);
            }

            protected void setAutoScrollMode(boolean state) {
                long l2 = a ^ 0x4CBC20D687L;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.l, state);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.r);
        panel2.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.c()) {
            panel2.addAction(new EliminateDuplicatesAction(this));
        }
        panel2.addAction(new ExportHTMLAction(this.g.getRoot()));
    }

    private static boolean c() {
        for (int i10 = 0; i10 < i.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentationCache.getPresentation(i, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode b() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.g.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.r.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.g != null) {
            this.g.removeListener(this.h);
        }
        this.g = duplicatesModel;
        this.r.setModel(duplicatesModel.getTreeModel());
        this.r.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.h);
        this.h.a();
    }

    public JComponent getComponent() {
        return this.o;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        i = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project, duplicates);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        for (Editor editor : this.p.keySet()) {
            List<RangeHighlighter> list2 = this.p.get(editor);
            for (RangeHighlighter rangeHighlighter : list2) {
                this.n.removeSegmentHighlighter(editor, rangeHighlighter);
            }
        }
        DuplicatesProfileCache.clear(this.s);
        DuplicatesPresentationCache.clear(this.s);
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, n2, n3, textAttributes, false, arrayList);
        }
        return arrayList;
    }

    static {
        t = la.a(3403965423145301252L, -2663981275197429351L, MethodHandles.lookup().lookupClass()).a(33919699476576L);
        long l2 = t ^ 0x47A25F268E8AL;
        f = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = la.a(8723381646842826044L, 2927460267881598110L, MethodHandles.lookup().lookupClass()).a(261654131466128L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l2 = a ^ 0x2117CED36800L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.b();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.b()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x72ACA71FD268L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon a;
        private Point b;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.a = (Icon)this.setNeedsRepaint(this.a, icon);
            this.b = (Point)this.setNeedsRepaint(this.b, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.a == null) {
                return;
            }
            this.a.paintIcon(component, g10, this.b.x, this.b.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm a = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.a.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.g;
            this.a.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.g && DuplicatesForm.this.o.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.g.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.g.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = (DuplicatesView)DuplicatesForm.this.e.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.q);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.e.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.o.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.o.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.r.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int a;
        private static final long b = la.a(-4071171328644965553L, 2606559099753268195L, MethodHandles.lookup().lookupClass()).a(120757329935250L);

        SendToAction(String text, String description, Icon icon, String actionId, int diffIndex) {
            super(text, description, icon);
            this.a = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(f);
            duplicatesModel.setDiff(this.a, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(f);
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x1F1D9F272E13L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider a;
        private static final long b = la.a(6867149753010633988L, 7313130477034254065L, MethodHandles.lookup().lookupClass()).a(267111697030209L);

        MySplitter(DataProvider dataProvider) {
            long l2 = b ^ 0x7DADD61E678FL;
            super("DuplicatesForm.settings", 0.3f);
            this.a = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.a.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x2B125FF00EE1L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = la.a(-5318131291970098611L, 3641366409254379427L, MethodHandles.lookup().lookupClass()).a(6936993432091L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l2 = a ^ 0x2B46E53AD72AL;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.c, "West");
                DuplicatesForm.this.b.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.k.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long c = la.a(9041963082529946989L, 6106792313399087757L, MethodHandles.lookup().lookupClass()).a(207100390359577L);

        public SendToLeftAction() {
            long l2 = c ^ 0x58FFC823B59CL;
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.d, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long c = la.a(-3579592983671863561L, -7084274193806017308L, MethodHandles.lookup().lookupClass()).a(266475307126225L);

        public SendToRightAction() {
            long l2 = c ^ 0x3E08A90FEE97L;
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.m, 1);
        }
    }
}

