/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.browse.BrowseCssStylesPanel;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xml.util.HtmlUtil;
import icons.CssIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BrowseCssStylesManager
implements ContentManagerListener {
    @NonNls
    private static final String CSS_BROWSE_STYLES_TOOLWINDOW = "CSS Styles";
    private final Project myProject;
    private ToolWindow myToolWindow;
    private final CssResolver myResolver;

    public BrowseCssStylesManager(@NotNull Project project) {
        if (project == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myResolver = CssResolveManager.getInstance().getNewResolver();
        this.myResolver.setUseAgentStylesheet(false);
    }

    public static BrowseCssStylesManager getInstance(@NotNull Project project) {
        if (project == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(1);
        }
        return (BrowseCssStylesManager)ServiceManager.getService((Project)project, BrowseCssStylesManager.class);
    }

    public void addStylesTab(@NotNull XmlTag tag) {
        if (tag == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(2);
        }
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content c = contentFactory.createContent((JComponent)new BrowseCssStylesPanel(tag, this.myResolver), BrowseCssStylesManager.getContentName(tag), true);
        contentManager.addContent(c);
        contentManager.setSelectedContent(c);
        toolWindow.activate(null);
    }

    public void removeStylesTab(@NotNull JComponent c) {
        ContentManager contentManager;
        Content content;
        if (c == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(3);
        }
        if (this.myToolWindow != null && (content = (contentManager = this.myToolWindow.getContentManager()).getContent(c)) != null) {
            contentManager.removeContent(content, true);
        }
    }

    private static String getContentName(@NotNull XmlTag tag) {
        if (tag == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(4);
        }
        String formattedTag = HtmlUtil.getTagPresentation((XmlTag)tag);
        PsiFile file = tag.getContainingFile();
        if (file != null) {
            return SymbolPresentationUtil.getFilePathPresentation((PsiFile)file) + ":" + formattedTag;
        }
        return formattedTag;
    }

    @NotNull
    private ToolWindow getToolWindow() {
        if (this.myToolWindow == null) {
            this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(CSS_BROWSE_STYLES_TOOLWINDOW, true, ToolWindowAnchor.BOTTOM);
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this);
            this.myToolWindow.setIcon(CssIcons.Toolwindow);
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(5);
        }
        return toolWindow;
    }

    public void contentRemoved(@NotNull ContentManagerEvent event) {
        ContentManager contentManager;
        if (event == null) {
            BrowseCssStylesManager.$$$reportNull$$$0(6);
        }
        if (this.myToolWindow != null && (contentManager = this.myToolWindow.getContentManager()).getContentCount() == 0) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(CSS_BROWSE_STYLES_TOOLWINDOW);
            contentManager.removeContentManagerListener((ContentManagerListener)this);
            this.myToolWindow = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/browse/BrowseCssStylesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/browse/BrowseCssStylesManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStylesTab";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeStylesTab";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentName";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contentRemoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

