/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssMinifiedFileChecker;
import org.jetbrains.annotations.NotNull;

public class CssMinifiedFilesFilter
extends GeneratedSourcesFilter {
    private boolean enableMinifiedFilesFilterInTests = false;

    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssMinifiedFilesFilter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CssMinifiedFilesFilter.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.enableMinifiedFilesFilterInTests) {
            return false;
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof LanguageFileType) || !((LanguageFileType)fileType).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file));
        return psiFile != null && CssMinifiedFileChecker.isMinifiedFile(psiFile);
    }

    public static void enableMinifiedFilesFilterInTests(@NotNull Disposable disposable) {
        CssMinifiedFilesFilter instance;
        if (disposable == null) {
            CssMinifiedFilesFilter.$$$reportNull$$$0(2);
        }
        if ((instance = (CssMinifiedFilesFilter)((Object)GeneratedSourcesFilter.EP_NAME.findExtension(CssMinifiedFilesFilter.class))) != null) {
            instance.enableMinifiedFilesFilterInTests = true;
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    instance.enableMinifiedFilesFilterInTests = false;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/CssMinifiedFilesFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGeneratedSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enableMinifiedFilesFilterInTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

